/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-08-17 09:35:44 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `jLLYHvjea_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=265 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=1242 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=772 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `jLLYHvjea_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `jLLYHvjea_duplicator_pro_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `jLLYHvjea_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `jLLYHvjea_learndash_pro_quiz_category` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_name` varchar(200) NOT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_learndash_pro_quiz_form` (
  `form_id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `fieldname` varchar(100) NOT NULL,
  `type` tinyint(4) NOT NULL,
  `required` tinyint(1) unsigned NOT NULL,
  `sort` tinyint(4) NOT NULL,
  `data` mediumtext DEFAULT NULL,
  PRIMARY KEY (`form_id`),
  KEY `quiz_id` (`quiz_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_learndash_pro_quiz_lock` (
  `quiz_id` int(11) NOT NULL,
  `lock_ip` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `lock_type` tinyint(3) unsigned NOT NULL,
  `lock_date` int(11) NOT NULL,
  PRIMARY KEY (`quiz_id`,`lock_ip`,`user_id`,`lock_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_learndash_pro_quiz_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `text` text NOT NULL,
  `result_text` text NOT NULL,
  `result_grade_enabled` tinyint(1) NOT NULL,
  `title_hidden` tinyint(1) NOT NULL,
  `btn_restart_quiz_hidden` tinyint(1) NOT NULL,
  `btn_view_question_hidden` tinyint(1) NOT NULL,
  `question_random` tinyint(1) NOT NULL,
  `answer_random` tinyint(1) NOT NULL,
  `time_limit` int(11) NOT NULL,
  `statistics_on` tinyint(1) NOT NULL,
  `statistics_ip_lock` int(10) unsigned NOT NULL,
  `show_points` tinyint(1) NOT NULL,
  `quiz_run_once` tinyint(1) NOT NULL,
  `quiz_run_once_type` tinyint(4) NOT NULL,
  `quiz_run_once_cookie` tinyint(1) NOT NULL,
  `quiz_run_once_time` int(10) unsigned NOT NULL,
  `numbered_answer` tinyint(1) NOT NULL,
  `hide_answer_message_box` tinyint(1) NOT NULL,
  `disabled_answer_mark` tinyint(1) NOT NULL,
  `show_max_question` tinyint(1) NOT NULL,
  `show_max_question_value` int(10) unsigned NOT NULL,
  `show_max_question_percent` tinyint(1) NOT NULL,
  `toplist_activated` tinyint(1) NOT NULL,
  `toplist_data` text NOT NULL,
  `show_average_result` tinyint(1) NOT NULL,
  `prerequisite` tinyint(1) NOT NULL,
  `quiz_modus` tinyint(3) unsigned NOT NULL,
  `show_review_question` tinyint(1) NOT NULL,
  `quiz_summary_hide` tinyint(1) NOT NULL,
  `skip_question_disabled` tinyint(1) NOT NULL,
  `email_notification` tinyint(3) unsigned NOT NULL,
  `user_email_notification` tinyint(1) unsigned NOT NULL,
  `show_category_score` tinyint(1) unsigned NOT NULL,
  `hide_result_correct_question` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `hide_result_quiz_time` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `hide_result_points` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `autostart` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `forcing_question_solve` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `hide_question_position_overview` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `hide_question_numbering` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `form_activated` tinyint(1) unsigned NOT NULL,
  `form_show_position` tinyint(3) unsigned NOT NULL,
  `start_only_registered_user` tinyint(1) unsigned NOT NULL,
  `questions_per_page` tinyint(3) unsigned NOT NULL,
  `sort_categories` tinyint(1) unsigned NOT NULL,
  `show_category` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_learndash_pro_quiz_prerequisite` (
  `prerequisite_quiz_id` int(11) NOT NULL,
  `quiz_id` int(11) NOT NULL,
  PRIMARY KEY (`prerequisite_quiz_id`,`quiz_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_learndash_pro_quiz_question` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `online` tinyint(1) unsigned NOT NULL,
  `previous_id` int(11) NOT NULL,
  `sort` smallint(5) unsigned NOT NULL,
  `title` text NOT NULL,
  `points` int(11) NOT NULL,
  `question` text NOT NULL,
  `correct_msg` text NOT NULL,
  `incorrect_msg` text NOT NULL,
  `correct_same_text` tinyint(1) NOT NULL,
  `tip_enabled` tinyint(1) NOT NULL,
  `tip_msg` text NOT NULL,
  `answer_type` varchar(50) NOT NULL,
  `show_points_in_box` tinyint(1) NOT NULL,
  `answer_points_activated` tinyint(1) NOT NULL,
  `answer_data` longtext NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `answer_points_diff_modus_activated` tinyint(1) unsigned NOT NULL,
  `disable_correct` tinyint(1) unsigned NOT NULL,
  `matrix_sort_answer_criteria_width` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `quiz_id` (`quiz_id`),
  KEY `category_id` (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_learndash_pro_quiz_statistic` (
  `statistic_ref_id` int(10) unsigned NOT NULL,
  `question_id` int(11) NOT NULL,
  `question_post_id` int(11) NOT NULL,
  `correct_count` int(10) unsigned NOT NULL,
  `incorrect_count` int(10) unsigned NOT NULL,
  `hint_count` int(10) unsigned NOT NULL,
  `points` int(10) unsigned NOT NULL,
  `question_time` int(10) unsigned NOT NULL,
  `answer_data` text DEFAULT NULL,
  PRIMARY KEY (`statistic_ref_id`,`question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_learndash_pro_quiz_statistic_ref` (
  `statistic_ref_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `quiz_post_id` int(11) NOT NULL,
  `course_post_id` int(11) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `create_time` int(11) NOT NULL,
  `is_old` tinyint(1) unsigned NOT NULL,
  `form_data` text DEFAULT NULL,
  PRIMARY KEY (`statistic_ref_id`),
  KEY `quiz_id` (`quiz_id`,`user_id`),
  KEY `time` (`create_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_learndash_pro_quiz_template` (
  `template_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `type` tinyint(3) unsigned NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`template_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_learndash_pro_quiz_toplist` (
  `toplist_id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `name` varchar(30) NOT NULL,
  `email` varchar(200) NOT NULL,
  `points` int(10) unsigned NOT NULL,
  `result` float unsigned NOT NULL,
  `ip` varchar(100) NOT NULL,
  PRIMARY KEY (`toplist_id`,`quiz_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_learndash_user_activity` (
  `activity_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `course_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `activity_type` varchar(50) DEFAULT NULL,
  `activity_status` tinyint(1) unsigned DEFAULT NULL,
  `activity_started` int(11) unsigned DEFAULT NULL,
  `activity_completed` int(11) unsigned DEFAULT NULL,
  `activity_updated` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`activity_id`),
  KEY `user_id` (`user_id`),
  KEY `post_id` (`post_id`),
  KEY `course_id` (`course_id`),
  KEY `activity_status` (`activity_status`),
  KEY `activity_type` (`activity_type`),
  KEY `activity_started` (`activity_started`),
  KEY `activity_completed` (`activity_completed`),
  KEY `activity_updated` (`activity_updated`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_learndash_user_activity_meta` (
  `activity_meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `activity_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `activity_meta_key` varchar(255) DEFAULT NULL,
  `activity_meta_value` mediumtext DEFAULT NULL,
  PRIMARY KEY (`activity_meta_id`),
  KEY `activity_id` (`activity_id`),
  KEY `activity_meta_key` (`activity_meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `jLLYHvjea_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) NOT NULL,
  `cache_tags` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint(4) NOT NULL COMMENT 'mobile=1',
  `webp` tinyint(4) NOT NULL COMMENT 'webp=1',
  `expired` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_automation_run_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_run_id` int(11) unsigned NOT NULL,
  `step_id` varchar(191) NOT NULL,
  `status` varchar(191) NOT NULL,
  `started_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `completed_at` timestamp NULL DEFAULT NULL,
  `error` longtext DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `automation_run_id` (`automation_run_id`),
  KEY `status` (`status`),
  KEY `step_id` (`step_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_automation_run_subjects` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_run_id` int(11) unsigned NOT NULL,
  `key` varchar(191) DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `hash` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `automation_run_id` (`automation_run_id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_automation_runs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_id` int(11) unsigned NOT NULL,
  `version_id` int(11) unsigned NOT NULL,
  `trigger_key` varchar(191) NOT NULL,
  `status` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `next_step_id` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `automation_id` (`automation_id`,`status`),
  KEY `created_at` (`created_at`),
  KEY `version_id` (`version_id`),
  KEY `status` (`status`),
  KEY `next_step_id` (`next_step_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_automation_triggers` (
  `automation_id` int(11) unsigned NOT NULL,
  `trigger_key` varchar(191) NOT NULL,
  PRIMARY KEY (`automation_id`,`trigger_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_automation_versions` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_id` int(11) unsigned NOT NULL,
  `steps` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `automation_id` (`automation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_automations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `author` bigint(20) NOT NULL,
  `status` varchar(191) NOT NULL,
  `meta` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `activated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_custom_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `type` varchar(90) NOT NULL,
  `params` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_dynamic_segment_filters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `segment_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `filter_data` longblob DEFAULT NULL,
  `filter_type` varchar(255) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_feature_flags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `value` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'enabled',
  `body` longtext DEFAULT NULL,
  `settings` longtext DEFAULT NULL,
  `styles` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `level` int(11) DEFAULT NULL,
  `message` longtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `raw_message` longtext DEFAULT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `started_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `completed_at` timestamp NULL DEFAULT NULL,
  `retries` int(11) unsigned NOT NULL DEFAULT 0,
  `error` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_newsletter_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `url` varchar(2083) NOT NULL,
  `hash` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `url` (`url`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_newsletter_option` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `option_field_id` int(11) unsigned NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_option_field_id` (`newsletter_id`,`option_field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_newsletter_option_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `newsletter_type` varchar(90) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_newsletter_type` (`newsletter_type`,`name`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_newsletter_posts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `post_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_newsletter_segment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `segment_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_segment` (`newsletter_id`,`segment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_newsletter_templates` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) DEFAULT 0,
  `name` varchar(250) NOT NULL,
  `categories` varchar(250) NOT NULL DEFAULT '[]',
  `description` varchar(255) NOT NULL DEFAULT '',
  `body` longtext DEFAULT NULL,
  `thumbnail` longtext DEFAULT NULL,
  `thumbnail_data` longtext DEFAULT NULL,
  `readonly` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_newsletters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(150) DEFAULT NULL,
  `parent_id` int(11) unsigned DEFAULT NULL,
  `subject` varchar(250) NOT NULL DEFAULT '',
  `type` varchar(150) NOT NULL DEFAULT 'standard',
  `sender_address` varchar(150) NOT NULL DEFAULT '',
  `sender_name` varchar(150) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT 'draft',
  `reply_to_address` varchar(150) NOT NULL DEFAULT '',
  `reply_to_name` varchar(150) NOT NULL DEFAULT '',
  `preheader` varchar(250) NOT NULL DEFAULT '',
  `body` longtext DEFAULT NULL,
  `sent_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unsubscribe_token` char(15) DEFAULT NULL,
  `ga_campaign` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `type_status` (`type`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_scheduled_task_subscribers` (
  `task_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `processed` int(1) NOT NULL,
  `failed` smallint(1) NOT NULL DEFAULT 0,
  `error` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`task_id`,`subscriber_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_scheduled_tasks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(90) DEFAULT NULL,
  `status` varchar(12) DEFAULT NULL,
  `priority` mediumint(9) NOT NULL DEFAULT 0,
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `in_progress` int(1) DEFAULT NULL,
  `reschedule_count` int(11) NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_segments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `type` varchar(90) NOT NULL DEFAULT 'default',
  `description` varchar(250) NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `average_engagement_score` float unsigned DEFAULT NULL,
  `average_engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `display_in_manage_subscription_page` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `average_engagement_score_updated_at` (`average_engagement_score_updated_at`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_sending_queues` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(11) unsigned NOT NULL,
  `newsletter_id` int(11) unsigned DEFAULT NULL,
  `newsletter_rendered_body` longtext DEFAULT NULL,
  `newsletter_rendered_subject` varchar(250) DEFAULT NULL,
  `subscribers` longtext DEFAULT NULL,
  `count_total` int(11) unsigned NOT NULL DEFAULT 0,
  `count_processed` int(11) unsigned NOT NULL DEFAULT 0,
  `count_to_process` int(11) unsigned NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_id` (`task_id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_settings` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_statistics_bounces` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_statistics_clicks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `link_id` int(11) unsigned NOT NULL,
  `user_agent_id` int(11) unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT 0,
  `count` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_statistics_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_subscriber` (`form_id`,`subscriber_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_statistics_newsletters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `sent_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_statistics_opens` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `user_agent_id` int(11) unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `created_at` (`created_at`),
  KEY `subscriber_id_created_at` (`subscriber_id`,`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_statistics_unsubscribes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned DEFAULT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `source` varchar(255) DEFAULT 'unknown',
  `meta` varchar(255) DEFAULT NULL,
  `method` varchar(40) NOT NULL DEFAULT 'unknown',
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id` (`newsletter_id`,`subscriber_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_statistics_woocommerce_purchases` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `click_id` int(11) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `order_currency` char(3) NOT NULL,
  `order_price_total` float NOT NULL COMMENT 'With shipping and taxes in order_currency',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `click_id_order_id` (`click_id`,`order_id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_stats_notifications` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `task_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_task_id` (`newsletter_id`,`task_id`),
  KEY `task_id` (`task_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_subscriber_custom_field` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `custom_field_id` int(11) unsigned NOT NULL,
  `value` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_id_custom_field_id` (`subscriber_id`,`custom_field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_subscriber_ips` (
  `ip` varchar(45) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`created_at`,`ip`),
  KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_subscriber_segment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `segment_id` int(11) unsigned NOT NULL,
  `status` varchar(12) NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_segment` (`subscriber_id`,`segment_id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_subscriber_tag` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `tag_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_tag` (`subscriber_id`,`tag_id`),
  KEY `tag_id` (`tag_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_subscribers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `wp_user_id` bigint(20) DEFAULT NULL,
  `is_woocommerce_user` int(1) NOT NULL DEFAULT 0,
  `first_name` varchar(255) NOT NULL DEFAULT '',
  `last_name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(150) NOT NULL,
  `status` varchar(12) NOT NULL DEFAULT 'unconfirmed',
  `subscribed_ip` varchar(45) DEFAULT NULL,
  `confirmed_ip` varchar(45) DEFAULT NULL,
  `confirmed_at` timestamp NULL DEFAULT NULL,
  `last_subscribed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unconfirmed_data` longtext DEFAULT NULL,
  `source` enum('form','imported','administrator','api','wordpress_user','woocommerce_user','woocommerce_checkout','unknown') DEFAULT 'unknown',
  `count_confirmations` int(11) unsigned NOT NULL DEFAULT 0,
  `unsubscribe_token` char(15) DEFAULT NULL,
  `link_token` char(32) DEFAULT NULL,
  `engagement_score` float unsigned DEFAULT NULL,
  `engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `last_engagement_at` timestamp NULL DEFAULT NULL,
  `woocommerce_synced_at` timestamp NULL DEFAULT NULL,
  `email_count` int(11) unsigned NOT NULL DEFAULT 0,
  `last_sending_at` timestamp NULL DEFAULT NULL,
  `last_open_at` timestamp NULL DEFAULT NULL,
  `last_click_at` timestamp NULL DEFAULT NULL,
  `last_purchase_at` timestamp NULL DEFAULT NULL,
  `last_page_view_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `wp_user_id` (`wp_user_id`),
  KEY `updated_at` (`updated_at`),
  KEY `status_deleted_at` (`status`,`deleted_at`),
  KEY `last_subscribed_at` (`last_subscribed_at`),
  KEY `engagement_score_updated_at` (`engagement_score_updated_at`),
  KEY `link_token` (`link_token`),
  KEY `first_name` (`first_name`(10)),
  KEY `last_name` (`last_name`(10)),
  KEY `last_sending_at` (`last_sending_at`),
  KEY `last_open_at` (`last_open_at`),
  KEY `last_click_at` (`last_click_at`),
  KEY `last_purchase_at` (`last_purchase_at`),
  KEY `last_page_view_at` (`last_page_view_at`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_tags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_user_agents` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(32) NOT NULL,
  `user_agent` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_mailpoet_user_flags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_name` (`user_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=3504 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `jLLYHvjea_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4633 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `jLLYHvjea_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=543 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `jLLYHvjea_social_users` (
  `social_users_id` int(11) NOT NULL AUTO_INCREMENT,
  `ID` int(11) NOT NULL,
  `type` varchar(20) NOT NULL,
  `identifier` varchar(100) NOT NULL,
  `register_date` datetime DEFAULT NULL,
  `login_date` datetime DEFAULT NULL,
  `link_date` datetime DEFAULT NULL,
  PRIMARY KEY (`social_users_id`),
  KEY `ID` (`ID`,`type`),
  KEY `identifier` (`identifier`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_solid_affiliate_affiliate_customer_links` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `affiliate_id` bigint(20) NOT NULL,
  `customer_id` bigint(20) NOT NULL,
  `customer_email` varchar(255) NOT NULL,
  `expires_on_unix_seconds` bigint(20) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `affiliate_id` (`affiliate_id`),
  KEY `created_at` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_solid_affiliate_affiliate_groups` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `commission_type` varchar(255) NOT NULL,
  `commission_rate` float NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at` (`created_at`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_solid_affiliate_affiliate_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `affiliate_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) NOT NULL,
  `meta_value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `affiliate_id` (`affiliate_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `created_at` (`created_at`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_solid_affiliate_affiliate_product_rates` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `woocommerce_product_id` bigint(20) NOT NULL,
  `affiliate_id` bigint(20) NOT NULL,
  `commission_type` varchar(255) NOT NULL,
  `commission_rate` float NOT NULL,
  `is_auto_referral` tinyint(1) NOT NULL,
  `is_prevent_additional_referrals_when_auto_referral_is_triggered` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_solid_affiliate_affiliates` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `affiliate_group_id` bigint(20) NOT NULL DEFAULT 0,
  `commission_type` varchar(255) NOT NULL,
  `commission_rate` float NOT NULL,
  `payment_email` varchar(255) NOT NULL DEFAULT '',
  `mailchimp_user_id` varchar(255) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL DEFAULT '',
  `last_name` varchar(255) NOT NULL DEFAULT '',
  `registration_notes` text NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL,
  `custom_registration_data` text NOT NULL DEFAULT '',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `status` (`status`(191)),
  KEY `created_at` (`created_at`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_solid_affiliate_creatives` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `status` varchar(255) NOT NULL,
  `name` text NOT NULL,
  `description` text NOT NULL,
  `url` text NOT NULL,
  `creative_text` text NOT NULL,
  `creative_image_url` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`(191)),
  KEY `created_at` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_solid_affiliate_payouts` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `affiliate_id` bigint(20) NOT NULL,
  `amount` float NOT NULL,
  `description` text NOT NULL,
  `payout_method` varchar(255) NOT NULL,
  `bulk_payout_id` bigint(20) NOT NULL DEFAULT 0,
  `created_by_user_id` bigint(20) NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `affiliate_id` (`affiliate_id`),
  KEY `bulk_payout_id` (`bulk_payout_id`),
  KEY `created_by_user_id` (`created_by_user_id`),
  KEY `status` (`status`(191)),
  KEY `created_at` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_solid_affiliate_referrals` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `affiliate_id` bigint(20) NOT NULL,
  `order_amount` float NOT NULL,
  `commission_amount` float NOT NULL,
  `referral_source` varchar(255) NOT NULL,
  `visit_id` bigint(20) NOT NULL DEFAULT 0,
  `coupon_id` bigint(20) NOT NULL DEFAULT 0,
  `customer_id` bigint(20) NOT NULL DEFAULT 0,
  `referral_type` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `order_source` varchar(255) NOT NULL,
  `order_id` bigint(20) NOT NULL,
  `order_refunded_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `payout_id` bigint(20) NOT NULL DEFAULT 0,
  `status` varchar(255) NOT NULL DEFAULT 'unpaid',
  `serialized_item_commissions` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `affiliate_id` (`affiliate_id`),
  KEY `customer_id` (`customer_id`),
  KEY `order_id` (`order_id`),
  KEY `order_refunded_at` (`order_refunded_at`),
  KEY `created_at` (`created_at`),
  KEY `payout_id` (`payout_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_solid_affiliate_store_credit_transactions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `affiliate_id` bigint(20) NOT NULL,
  `amount` float NOT NULL,
  `description` text NOT NULL,
  `source` varchar(255) NOT NULL,
  `source_id` bigint(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `created_by_user_id` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `affiliate_id` (`affiliate_id`),
  KEY `source_id` (`source_id`),
  KEY `created_by_user_id` (`created_by_user_id`),
  KEY `created_at` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_solid_affiliate_visits` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `previous_visit_id` bigint(20) NOT NULL DEFAULT 0,
  `affiliate_id` bigint(20) NOT NULL,
  `referral_id` bigint(20) NOT NULL DEFAULT 0,
  `landing_url` text NOT NULL,
  `http_referrer` text NOT NULL DEFAULT '',
  `http_ip` varchar(255) NOT NULL DEFAULT '',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `affiliate_id` (`affiliate_id`),
  KEY `referral_id` (`referral_id`),
  KEY `created_at` (`created_at`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_solid_affiliates_bulk_payouts` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_range_start` datetime NOT NULL,
  `date_range_end` datetime NOT NULL,
  `currency` varchar(255) NOT NULL,
  `method` varchar(255) NOT NULL,
  `date_range` varchar(255) NOT NULL,
  `total_amount` float NOT NULL,
  `status` varchar(255) NOT NULL,
  `reference` text NOT NULL,
  `api_mode` varchar(255) NOT NULL,
  `created_by_user_id` bigint(20) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `serialized_logic_rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `jLLYHvjea_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=94 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `jLLYHvjea_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=163 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `jLLYHvjea_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=94 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `jLLYHvjea_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `jLLYHvjea_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `jLLYHvjea_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1373 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(250)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wpcc_urls` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) NOT NULL,
  `url` varchar(2560) NOT NULL,
  `thumbnail_url` varchar(2560) DEFAULT NULL,
  `category_id` mediumint(9) NOT NULL,
  `is_saved` tinyint(1) NOT NULL DEFAULT 0,
  `saved_post_id` bigint(20) unsigned DEFAULT NULL,
  `update_count` int(10) unsigned NOT NULL DEFAULT 0,
  `is_locked` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT '0000-00-00 00:00:00',
  `updated_at` datetime DEFAULT '0000-00-00 00:00:00',
  `saved_at` datetime DEFAULT NULL,
  `recrawled_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jLLYHvjea_wpsmtp_logs` (
  `mail_id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `to` varchar(200) NOT NULL DEFAULT '0',
  `subject` varchar(200) NOT NULL DEFAULT '0',
  `message` text DEFAULT NULL,
  `headers` text DEFAULT NULL,
  `error` text DEFAULT NULL,
  PRIMARY KEY (`mail_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `jLLYHvjea_yith_wcwl` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `prod_id` bigint(20) NOT NULL,
  `quantity` int(11) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `wishlist_id` bigint(20) DEFAULT NULL,
  `position` int(11) DEFAULT 0,
  `original_price` decimal(9,3) DEFAULT NULL,
  `original_currency` char(3) DEFAULT NULL,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `on_sale` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `prod_id` (`prod_id`)
) ENGINE=MyISAM AUTO_INCREMENT=161 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `jLLYHvjea_yith_wcwl_lists` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `wishlist_slug` varchar(200) NOT NULL,
  `wishlist_name` text DEFAULT NULL,
  `wishlist_token` varchar(64) NOT NULL,
  `wishlist_privacy` tinyint(1) NOT NULL DEFAULT 0,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `expiration` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `wishlist_token` (`wishlist_token`),
  KEY `wishlist_slug` (`wishlist_slug`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;


 /* SQL Chunk Header Index 1 */ 

/* INSERT TABLE DATA: jLLYHvjea_actionscheduler_actions */
INSERT INTO `jLLYHvjea_actionscheduler_actions` VALUES(6, 'action_scheduler/migration_hook', 'complete', '2023-08-15 15:04:58', '2023-08-15 15:04:58', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692111898;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692111898;}', 1, 1, '2023-08-15 15:05:19', '2023-08-15 15:05:19', 0, NULL),
 (7, 'woocommerce_cleanup_draft_orders', 'complete', '2023-08-15 15:03:58', '2023-08-15 15:03:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692111838;s:18:\"\0*\0first_timestamp\";i:1692111838;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692111838;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}', 2, 1, '2023-08-15 15:03:59', '2023-08-15 15:03:59', 0, NULL),
 (8, 'woocommerce_cleanup_draft_orders', 'complete', '2023-08-16 15:03:59', '2023-08-16 15:03:59', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692198239;s:18:\"\0*\0first_timestamp\";i:1692111838;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692198239;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}', 2, 1, '2023-08-16 15:06:44', '2023-08-16 15:06:44', 0, NULL),
 (9, 'woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications', 'failed', '2023-08-15 15:14:20', '2023-08-15 15:14:20', 10, '[]', 'O:28:\"ActionScheduler_NullSchedule\":0:{}', 2, 1, '2023-08-15 15:14:30', '2023-08-15 15:14:30', 0, NULL),
 (10, 'wc_schedule_update_product_default_cat', 'complete', '2023-08-16 06:56:31', '2023-08-16 06:56:31', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692168991;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692168991;}', 3, 1, '2023-08-16 06:56:32', '2023-08-16 06:56:32', 0, NULL),
 (11, 'wc_schedule_update_product_default_cat', 'complete', '2023-08-16 06:58:57', '2023-08-16 06:58:57', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692169137;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692169137;}', 3, 1, '2023-08-16 06:58:58', '2023-08-16 06:58:58', 0, NULL),
 (12, 'wc_schedule_update_product_default_cat', 'complete', '2023-08-16 06:58:57', '2023-08-16 06:58:57', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692169137;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692169137;}', 3, 1, '2023-08-16 06:58:58', '2023-08-16 06:58:58', 0, NULL),
 (13, 'wc_schedule_update_product_default_cat', 'complete', '2023-08-16 06:58:57', '2023-08-16 06:58:57', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692169137;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692169137;}', 3, 1, '2023-08-16 06:58:58', '2023-08-16 06:58:58', 0, NULL),
 (14, 'wc_schedule_update_product_default_cat', 'complete', '2023-08-16 06:58:57', '2023-08-16 06:58:57', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692169137;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692169137;}', 3, 1, '2023-08-16 06:58:58', '2023-08-16 06:58:58', 0, NULL),
 (15, 'wc_schedule_update_product_default_cat', 'complete', '2023-08-16 06:58:57', '2023-08-16 06:58:57', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692169137;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692169137;}', 3, 1, '2023-08-16 06:58:58', '2023-08-16 06:58:58', 0, NULL),
 (16, 'wc_schedule_update_product_default_cat', 'complete', '2023-08-16 06:58:58', '2023-08-16 06:58:58', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692169138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692169138;}', 3, 1, '2023-08-16 06:58:58', '2023-08-16 06:58:58', 0, NULL),
 (17, 'wc_schedule_update_product_default_cat', 'complete', '2023-08-16 06:58:58', '2023-08-16 06:58:58', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692169138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692169138;}', 3, 1, '2023-08-16 07:00:03', '2023-08-16 07:00:03', 0, NULL),
 (18, 'wc_schedule_update_product_default_cat', 'complete', '2023-08-16 06:58:58', '2023-08-16 06:58:58', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692169138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692169138;}', 3, 1, '2023-08-16 07:00:03', '2023-08-16 07:00:03', 0, NULL),
 (19, 'wc_schedule_update_product_default_cat', 'complete', '2023-08-16 06:58:58', '2023-08-16 06:58:58', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692169138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692169138;}', 3, 1, '2023-08-16 07:00:03', '2023-08-16 07:00:03', 0, NULL),
 (20, 'action_scheduler/migration_hook', 'complete', '2023-08-16 07:37:26', '2023-08-16 07:37:26', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692171446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692171446;}', 1, 1, '2023-08-16 07:37:30', '2023-08-16 07:37:30', 0, NULL),
 (21, 'action_scheduler/migration_hook', 'failed', '2023-08-16 07:38:30', '2023-08-16 07:38:30', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692171510;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692171510;}', 1, 1, '2023-08-16 07:38:36', '2023-08-16 07:38:36', 0, NULL),
 (22, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:19', '2023-08-16 08:51:19', 10, '[166,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175879;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175879;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (23, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:19', '2023-08-16 08:51:19', 10, '[167,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175879;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175879;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (24, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:19', '2023-08-16 08:51:19', 10, '[168,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175879;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175879;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (25, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[169,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (26, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[170,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (27, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[171,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (28, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[172,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (29, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[173,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (30, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[174,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (31, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[175,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (32, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[176,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (33, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[177,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (34, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[178,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (35, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[179,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (36, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[180,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (37, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[181,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (38, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[182,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (39, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[183,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (40, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[184,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (41, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:51:20', '2023-08-16 08:51:20', 10, '[185,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175880;}', 4, 1, '2023-08-16 08:52:58', '2023-08-16 08:52:58', 0, NULL),
 (42, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:02', '2023-08-16 08:53:02', 10, '[186,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175982;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175982;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (43, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[187,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (44, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[188,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (45, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[189,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (46, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[190,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (47, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[191,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (48, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[192,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (49, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[193,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (50, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[194,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (51, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[195,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (52, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[196,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (53, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[197,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (54, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[198,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (55, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[199,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (56, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[200,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (57, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[201,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (58, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[202,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (59, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:03', '2023-08-16 08:53:03', 10, '[203,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175983;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (60, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:04', '2023-08-16 08:53:04', 10, '[204,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175984;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (61, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:04', '2023-08-16 08:53:04', 10, '[205,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175984;}', 4, 1, '2023-08-16 08:53:05', '2023-08-16 08:53:05', 0, NULL),
 (62, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:18', '2023-08-16 08:53:18', 10, '[206,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175998;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (63, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:18', '2023-08-16 08:53:18', 10, '[207,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175998;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (64, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:18', '2023-08-16 08:53:18', 10, '[208,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175998;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (65, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[209,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (66, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[210,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (67, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[211,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (68, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[212,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (69, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[213,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (70, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[214,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (71, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[215,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (72, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[216,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (73, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[217,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (74, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[218,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (75, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[219,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (76, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[220,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (77, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[221,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (78, 'woocommerce_run_product_attribute_lookup_update_callback', 'complete', '2023-08-16 08:53:19', '2023-08-16 08:53:19', 10, '[222,3]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692175999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692175999;}', 4, 1, '2023-08-16 08:53:59', '2023-08-16 08:53:59', 0, NULL),
 (79, 'woocommerce_plugins_install_and_activate_async_callback', 'complete', '2023-08-16 09:12:49', '2023-08-16 09:12:49', 10, '[[\"mailpoet\",\"jetpack\"],\"64dc9311b6338\"]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692177169;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692177169;}', 2, 1, '2023-08-16 09:13:12', '2023-08-16 09:13:12', 0, NULL),
 (80, 'pinterest_for_woocommerce_daily_heartbeat', 'complete', '2023-08-16 09:12:51', '2023-08-16 09:12:51', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692177171;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692177171;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}', 5, 1, '2023-08-16 09:13:22', '2023-08-16 09:13:22', 0, NULL),
 (81, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-16 09:12:51', '2023-08-16 09:12:51', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692177171;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692177171;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-16 09:13:22', '2023-08-16 09:13:22', 0, NULL),
 (82, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:12:53', '2023-08-16 09:12:53', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692177173;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692177173;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:13:23', '2023-08-16 09:13:23', 0, NULL),
 (83, 'pinterest_for_woocommerce_daily_heartbeat', 'complete', '2023-08-17 09:13:22', '2023-08-17 09:13:22', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692263602;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692263602;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}', 5, 1, '2023-08-17 09:14:00', '2023-08-17 09:14:00', 0, NULL),
 (84, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-16 10:13:22', '2023-08-16 10:13:22', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692180802;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692180802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-16 10:14:03', '2023-08-16 10:14:03', 0, NULL),
 (87, 'mailpoet/cron/daemon-run', 'complete', '2023-08-16 09:15:38', '2023-08-16 09:15:38', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692177338;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692177338;}', 6, 1, '2023-08-16 09:15:55', '2023-08-16 09:15:55', 0, NULL),
 (85, 'mailpoet/cron/daemon-run', 'complete', '2023-08-16 09:13:22', '2023-08-16 09:13:22', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692177202;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692177202;}', 6, 1, '2023-08-16 09:13:23', '2023-08-16 09:13:23', 0, NULL),
 (86, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:15:23', '2023-08-16 09:15:23', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692177323;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692177323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:15:43', '2023-08-16 09:15:43', 0, NULL),
 (88, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:17:43', '2023-08-16 09:17:43', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692177463;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692177463;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:17:59', '2023-08-16 09:17:59', 0, NULL),
 (89, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:19:59', '2023-08-16 09:19:59', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692177599;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692177599;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:20:06', '2023-08-16 09:20:06', 0, NULL),
 (90, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:22:06', '2023-08-16 09:22:06', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692177726;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692177726;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:22:31', '2023-08-16 09:22:31', 0, NULL),
 (91, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:24:31', '2023-08-16 09:24:31', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692177871;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692177871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:25:13', '2023-08-16 09:25:13', 0, NULL),
 (92, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:27:13', '2023-08-16 09:27:13', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692178033;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692178033;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:27:50', '2023-08-16 09:27:50', 0, NULL),
 (93, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:29:50', '2023-08-16 09:29:50', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692178190;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692178190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:30:35', '2023-08-16 09:30:35', 0, NULL),
 (94, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:32:35', '2023-08-16 09:32:35', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692178355;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692178355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:32:51', '2023-08-16 09:32:51', 0, NULL),
 (95, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:34:51', '2023-08-16 09:34:51', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692178491;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692178491;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:35:37', '2023-08-16 09:35:37', 0, NULL),
 (96, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:37:37', '2023-08-16 09:37:37', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692178657;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692178657;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:38:14', '2023-08-16 09:38:14', 0, NULL),
 (97, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:40:14', '2023-08-16 09:40:14', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692178814;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692178814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:46:47', '2023-08-16 09:46:47', 0, NULL),
 (98, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:48:47', '2023-08-16 09:48:47', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692179327;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692179327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:54:18', '2023-08-16 09:54:18', 0, NULL),
 (99, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:56:18', '2023-08-16 09:56:18', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692179778;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692179778;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:56:57', '2023-08-16 09:56:57', 0, NULL),
 (100, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 09:58:57', '2023-08-16 09:58:57', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692179937;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692179937;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 09:58:58', '2023-08-16 09:58:58', 0, NULL),
 (101, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 10:00:58', '2023-08-16 10:00:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692180058;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692180058;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 10:00:58', '2023-08-16 10:00:58', 0, NULL),
 (102, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 10:02:58', '2023-08-16 10:02:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692180178;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692180178;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 10:02:58', '2023-08-16 10:02:58', 0, NULL),
 (103, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 10:04:58', '2023-08-16 10:04:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692180298;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692180298;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 10:05:08', '2023-08-16 10:05:08', 0, NULL),
 (104, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 10:07:08', '2023-08-16 10:07:08', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692180428;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692180428;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 10:09:08', '2023-08-16 10:09:08', 0, NULL),
 (105, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 10:11:08', '2023-08-16 10:11:08', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692180668;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692180668;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 10:13:01', '2023-08-16 10:13:01', 0, NULL),
 (106, 'mailpoet/cron/daemon-run', 'complete', '2023-08-16 10:13:00', '2023-08-16 10:13:00', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692180780;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692180780;}', 6, 1, '2023-08-16 10:13:01', '2023-08-16 10:13:01', 0, NULL),
 (107, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 10:15:01', '2023-08-16 10:15:01', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692180901;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692180901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 10:15:18', '2023-08-16 10:15:18', 0, NULL),
 (108, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-16 11:14:03', '2023-08-16 11:14:03', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692184443;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692184443;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-16 11:16:10', '2023-08-16 11:16:10', 0, NULL),
 (109, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 10:17:18', '2023-08-16 10:17:18', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692181038;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692181038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 10:47:35', '2023-08-16 10:47:35', 0, NULL),
 (110, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 10:49:35', '2023-08-16 10:49:35', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692182975;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692182975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 11:09:21', '2023-08-16 11:09:21', 0, NULL),
 (111, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 11:11:21', '2023-08-16 11:11:21', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692184281;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692184281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 11:16:10', '2023-08-16 11:16:10', 0, NULL),
 (114, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 11:21:27', '2023-08-16 11:21:27', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692184887;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692184887;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 11:21:30', '2023-08-16 11:21:30', 0, NULL),
 (112, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 11:18:10', '2023-08-16 11:18:10', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692184690;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692184690;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 11:19:27', '2023-08-16 11:19:27', 0, NULL),
 (113, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-16 12:16:10', '2023-08-16 12:16:10', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692188170;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692188170;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-16 12:16:30', '2023-08-16 12:16:30', 0, NULL),
 (115, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 11:23:30', '2023-08-16 11:23:30', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692185010;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692185010;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 11:24:01', '2023-08-16 11:24:01', 0, NULL),
 (116, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 11:26:01', '2023-08-16 11:26:01', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692185161;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692185161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 11:26:58', '2023-08-16 11:26:58', 0, NULL),
 (117, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 11:28:58', '2023-08-16 11:28:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692185338;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692185338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 11:28:59', '2023-08-16 11:28:59', 0, NULL),
 (118, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 11:30:59', '2023-08-16 11:30:59', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692185459;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692185459;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 11:38:17', '2023-08-16 11:38:17', 0, NULL),
 (119, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 11:40:17', '2023-08-16 11:40:17', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692186017;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692186017;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 11:43:36', '2023-08-16 11:43:36', 0, NULL),
 (120, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 11:45:36', '2023-08-16 11:45:36', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692186336;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692186336;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 11:46:11', '2023-08-16 11:46:11', 0, NULL),
 (121, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 11:48:11', '2023-08-16 11:48:11', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692186491;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692186491;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 11:48:35', '2023-08-16 11:48:35', 0, NULL),
 (122, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 11:50:35', '2023-08-16 11:50:35', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692186635;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692186635;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 12:16:30', '2023-08-16 12:16:30', 0, NULL),
 (125, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 12:20:58', '2023-08-16 12:20:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692188458;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692188458;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 12:21:59', '2023-08-16 12:21:59', 0, NULL),
 (123, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 12:18:30', '2023-08-16 12:18:30', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692188310;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692188310;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 12:18:58', '2023-08-16 12:18:58', 0, NULL),
 (124, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-16 13:16:30', '2023-08-16 13:16:30', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692191790;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692191790;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-16 13:23:48', '2023-08-16 13:23:48', 0, NULL),
 (126, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 12:23:59', '2023-08-16 12:23:59', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692188639;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692188639;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 12:24:08', '2023-08-16 12:24:08', 0, NULL),
 (127, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 12:26:08', '2023-08-16 12:26:08', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692188768;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692188768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 12:27:06', '2023-08-16 12:27:06', 0, NULL),
 (128, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 12:29:06', '2023-08-16 12:29:06', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692188946;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692188946;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 12:38:17', '2023-08-16 12:38:17', 0, NULL),
 (129, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 12:40:17', '2023-08-16 12:40:17', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692189617;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692189617;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 12:45:13', '2023-08-16 12:45:13', 0, NULL),
 (130, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 12:47:13', '2023-08-16 12:47:13', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692190033;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692190033;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:23:48', '2023-08-16 13:23:48', 0, NULL),
 (133, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:27:59', '2023-08-16 13:27:59', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692192479;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692192479;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:28:57', '2023-08-16 13:28:57', 0, NULL),
 (131, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:25:48', '2023-08-16 13:25:48', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692192348;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692192348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:25:59', '2023-08-16 13:25:59', 0, NULL),
 (132, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-16 14:23:48', '2023-08-16 14:23:48', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692195828;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692195828;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-16 14:23:59', '2023-08-16 14:23:59', 0, NULL),
 (134, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:30:57', '2023-08-16 13:30:57', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692192657;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692192657;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:30:58', '2023-08-16 13:30:58', 0, NULL),
 (135, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:32:58', '2023-08-16 13:32:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692192778;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692192778;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:35:03', '2023-08-16 13:35:03', 0, NULL),
 (136, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:37:03', '2023-08-16 13:37:03', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692193023;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692193023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:37:06', '2023-08-16 13:37:06', 0, NULL),
 (137, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:39:06', '2023-08-16 13:39:06', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692193146;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692193146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:39:08', '2023-08-16 13:39:08', 0, NULL),
 (138, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:41:08', '2023-08-16 13:41:08', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692193268;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692193268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:41:44', '2023-08-16 13:41:44', 0, NULL),
 (139, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:43:44', '2023-08-16 13:43:44', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692193424;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692193424;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:43:58', '2023-08-16 13:43:58', 0, NULL),
 (140, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:45:58', '2023-08-16 13:45:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692193558;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692193558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:45:58', '2023-08-16 13:45:58', 0, NULL),
 (141, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:47:58', '2023-08-16 13:47:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692193678;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692193678;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:48:17', '2023-08-16 13:48:17', 0, NULL),
 (142, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:50:17', '2023-08-16 13:50:17', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692193817;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692193817;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:51:01', '2023-08-16 13:51:01', 0, NULL),
 (143, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:53:01', '2023-08-16 13:53:01', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692193981;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692193981;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:53:09', '2023-08-16 13:53:09', 0, NULL),
 (144, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:55:09', '2023-08-16 13:55:09', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692194109;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692194109;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:55:13', '2023-08-16 13:55:13', 0, NULL),
 (145, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 13:57:13', '2023-08-16 13:57:13', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692194233;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692194233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 13:58:13', '2023-08-16 13:58:13', 0, NULL),
 (146, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:00:13', '2023-08-16 14:00:13', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692194413;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692194413;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:00:28', '2023-08-16 14:00:28', 0, NULL),
 (147, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:02:28', '2023-08-16 14:02:28', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692194548;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692194548;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:03:28', '2023-08-16 14:03:28', 0, NULL),
 (148, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:05:28', '2023-08-16 14:05:28', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692194728;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692194728;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:06:22', '2023-08-16 14:06:22', 0, NULL),
 (149, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:08:22', '2023-08-16 14:08:22', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692194902;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692194902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:08:57', '2023-08-16 14:08:57', 0, NULL),
 (150, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:10:57', '2023-08-16 14:10:57', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692195057;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692195057;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:11:04', '2023-08-16 14:11:04', 0, NULL),
 (151, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:13:04', '2023-08-16 14:13:04', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692195184;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692195184;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:13:33', '2023-08-16 14:13:33', 0, NULL),
 (152, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:15:33', '2023-08-16 14:15:33', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692195333;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692195333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:16:19', '2023-08-16 14:16:19', 0, NULL),
 (153, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:18:19', '2023-08-16 14:18:19', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692195499;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692195499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:18:28', '2023-08-16 14:18:28', 0, NULL),
 (154, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:20:28', '2023-08-16 14:20:28', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692195628;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692195628;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:20:45', '2023-08-16 14:20:45', 0, NULL),
 (155, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:22:45', '2023-08-16 14:22:45', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692195765;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692195765;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:23:05', '2023-08-16 14:23:05', 0, NULL),
 (156, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:25:05', '2023-08-16 14:25:05', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692195905;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692195905;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:25:13', '2023-08-16 14:25:13', 0, NULL),
 (157, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-16 15:23:59', '2023-08-16 15:23:59', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692199439;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692199439;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-16 15:24:47', '2023-08-16 15:24:47', 0, NULL),
 (158, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:27:13', '2023-08-16 14:27:13', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692196033;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692196033;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:27:37', '2023-08-16 14:27:37', 0, NULL),
 (159, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:29:37', '2023-08-16 14:29:37', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692196177;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692196177;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:29:59', '2023-08-16 14:29:59', 0, NULL),
 (160, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:31:59', '2023-08-16 14:31:59', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692196319;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692196319;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:32:07', '2023-08-16 14:32:07', 0, NULL),
 (161, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:34:07', '2023-08-16 14:34:07', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692196447;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692196447;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:34:59', '2023-08-16 14:34:59', 0, NULL),
 (162, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:36:59', '2023-08-16 14:36:59', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692196619;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692196619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:37:00', '2023-08-16 14:37:00', 0, NULL),
 (163, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:39:00', '2023-08-16 14:39:00', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692196740;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692196740;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:39:07', '2023-08-16 14:39:07', 0, NULL),
 (164, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:41:07', '2023-08-16 14:41:07', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692196867;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692196867;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:41:40', '2023-08-16 14:41:40', 0, NULL),
 (165, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:43:40', '2023-08-16 14:43:40', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692197020;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692197020;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:47:08', '2023-08-16 14:47:08', 0, NULL),
 (166, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:49:08', '2023-08-16 14:49:08', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692197348;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692197348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 14:52:28', '2023-08-16 14:52:28', 0, NULL),
 (167, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 14:54:28', '2023-08-16 14:54:28', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692197668;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692197668;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 15:00:19', '2023-08-16 15:00:19', 0, NULL),
 (168, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 15:02:19', '2023-08-16 15:02:19', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692198139;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692198139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 15:02:52', '2023-08-16 15:02:52', 0, NULL),
 (169, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 15:04:52', '2023-08-16 15:04:52', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692198292;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692198292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 15:06:44', '2023-08-16 15:06:44', 0, NULL),
 (170, 'woocommerce_cleanup_draft_orders', 'pending', '2023-08-17 15:06:44', '2023-08-17 15:06:44', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692284804;s:18:\"\0*\0first_timestamp\";i:1692111838;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692284804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}', 2, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, NULL),
 (172, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 15:10:58', '2023-08-16 15:10:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692198658;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692198658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 15:10:58', '2023-08-16 15:10:58', 0, NULL),
 (171, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 15:08:44', '2023-08-16 15:08:44', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692198524;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692198524;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 15:08:58', '2023-08-16 15:08:58', 0, NULL),
 (173, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 15:12:58', '2023-08-16 15:12:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692198778;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692198778;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 15:12:58', '2023-08-16 15:12:58', 0, NULL),
 (174, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 15:14:58', '2023-08-16 15:14:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692198898;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692198898;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 15:14:58', '2023-08-16 15:14:58', 0, NULL),
 (175, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 15:16:58', '2023-08-16 15:16:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692199018;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692199018;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 15:16:58', '2023-08-16 15:16:58', 0, NULL),
 (176, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 15:18:58', '2023-08-16 15:18:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692199138;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692199138;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 15:20:34', '2023-08-16 15:20:34', 0, NULL),
 (177, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 15:22:34', '2023-08-16 15:22:34', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692199354;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692199354;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 15:23:19', '2023-08-16 15:23:19', 0, NULL),
 (178, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 15:25:19', '2023-08-16 15:25:19', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692199519;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692199519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 15:27:32', '2023-08-16 15:27:32', 0, NULL),
 (179, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-16 16:24:47', '2023-08-16 16:24:47', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692203087;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692203087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-16 17:07:58', '2023-08-16 17:07:58', 0, NULL),
 (180, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 15:29:32', '2023-08-16 15:29:32', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692199772;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692199772;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 15:32:51', '2023-08-16 15:32:51', 0, NULL),
 (181, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 15:34:51', '2023-08-16 15:34:51', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692200091;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692200091;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 17:07:58', '2023-08-16 17:07:58', 0, NULL),
 (184, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 17:13:05', '2023-08-16 17:13:05', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692205985;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692205985;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 17:14:00', '2023-08-16 17:14:00', 0, NULL),
 (182, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 17:09:58', '2023-08-16 17:09:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692205798;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692205798;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 17:11:05', '2023-08-16 17:11:05', 0, NULL),
 (183, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-16 18:07:58', '2023-08-16 18:07:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692209278;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692209278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-16 18:13:23', '2023-08-16 18:13:23', 0, NULL),
 (185, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 17:16:00', '2023-08-16 17:16:00', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692206160;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692206160;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 17:16:07', '2023-08-16 17:16:07', 0, NULL),
 (186, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 17:18:07', '2023-08-16 17:18:07', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692206287;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692206287;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 17:18:59', '2023-08-16 17:18:59', 0, NULL),
 (187, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 17:20:59', '2023-08-16 17:20:59', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692206459;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692206459;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 17:21:13', '2023-08-16 17:21:13', 0, NULL),
 (188, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 17:23:13', '2023-08-16 17:23:13', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692206593;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692206593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 17:24:58', '2023-08-16 17:24:58', 0, NULL),
 (189, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 17:26:58', '2023-08-16 17:26:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692206818;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692206818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 18:13:23', '2023-08-16 18:13:23', 0, NULL),
 (192, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 18:17:57', '2023-08-16 18:17:57', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692209877;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692209877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 18:17:58', '2023-08-16 18:17:58', 0, NULL),
 (190, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 18:15:23', '2023-08-16 18:15:23', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692209723;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692209723;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 18:15:57', '2023-08-16 18:15:57', 0, NULL),
 (191, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-16 19:13:23', '2023-08-16 19:13:23', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692213203;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692213203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-16 19:25:01', '2023-08-16 19:25:01', 0, NULL),
 (193, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 18:19:58', '2023-08-16 18:19:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692209998;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692209998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 18:19:58', '2023-08-16 18:19:58', 0, NULL),
 (194, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 18:21:58', '2023-08-16 18:21:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692210118;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692210118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 18:22:36', '2023-08-16 18:22:36', 0, NULL),
 (195, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 18:24:36', '2023-08-16 18:24:36', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692210276;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692210276;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 18:26:10', '2023-08-16 18:26:10', 0, NULL),
 (196, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 18:28:10', '2023-08-16 18:28:10', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692210490;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692210490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 18:31:22', '2023-08-16 18:31:22', 0, NULL),
 (197, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 18:33:22', '2023-08-16 18:33:22', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692210802;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692210802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 18:42:21', '2023-08-16 18:42:21', 0, NULL),
 (198, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 18:44:21', '2023-08-16 18:44:21', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692211461;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692211461;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 19:25:01', '2023-08-16 19:25:01', 0, NULL),
 (201, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 19:29:06', '2023-08-16 19:29:06', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692214146;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692214146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 19:33:25', '2023-08-16 19:33:25', 0, NULL),
 (199, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 19:27:01', '2023-08-16 19:27:01', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692214021;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692214021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 19:27:06', '2023-08-16 19:27:06', 0, NULL),
 (200, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-16 20:25:01', '2023-08-16 20:25:01', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692217501;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692217501;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-16 20:26:58', '2023-08-16 20:26:58', 0, NULL),
 (202, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 19:35:25', '2023-08-16 19:35:25', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692214525;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692214525;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 19:39:42', '2023-08-16 19:39:42', 0, NULL),
 (203, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 19:41:42', '2023-08-16 19:41:42', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692214902;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692214902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 19:54:22', '2023-08-16 19:54:22', 0, NULL),
 (204, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 19:56:22', '2023-08-16 19:56:22', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692215782;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692215782;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 19:57:27', '2023-08-16 19:57:27', 0, NULL),
 (205, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 19:59:27', '2023-08-16 19:59:27', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692215967;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692215967;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 20:03:45', '2023-08-16 20:03:45', 0, NULL),
 (206, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 20:05:45', '2023-08-16 20:05:45', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692216345;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692216345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 20:10:35', '2023-08-16 20:10:35', 0, NULL),
 (207, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 20:12:35', '2023-08-16 20:12:35', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692216755;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692216755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 20:12:46', '2023-08-16 20:12:46', 0, NULL),
 (208, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 20:14:46', '2023-08-16 20:14:46', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692216886;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692216886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 20:15:00', '2023-08-16 20:15:00', 0, NULL),
 (209, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 20:17:00', '2023-08-16 20:17:00', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692217020;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692217020;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 20:17:07', '2023-08-16 20:17:07', 0, NULL),
 (210, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 20:19:07', '2023-08-16 20:19:07', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692217147;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692217147;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 20:19:09', '2023-08-16 20:19:09', 0, NULL),
 (211, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 20:21:09', '2023-08-16 20:21:09', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692217269;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692217269;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 20:23:10', '2023-08-16 20:23:10', 0, NULL),
 (212, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 20:25:10', '2023-08-16 20:25:10', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692217510;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692217510;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 20:26:58', '2023-08-16 20:26:58', 0, NULL),
 (213, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-16 21:26:58', '2023-08-16 21:26:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692221218;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692221218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-16 21:27:24', '2023-08-16 21:27:24', 0, NULL),
 (215, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 20:31:51', '2023-08-16 20:31:51', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692217911;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692217911;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 20:33:59', '2023-08-16 20:33:59', 0, NULL),
 (214, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 20:28:58', '2023-08-16 20:28:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692217738;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692217738;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 20:29:51', '2023-08-16 20:29:51', 0, NULL),
 (216, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 20:35:59', '2023-08-16 20:35:59', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692218159;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692218159;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 21:11:07', '2023-08-16 21:11:07', 0, NULL),
 (217, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 21:13:07', '2023-08-16 21:13:07', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692220387;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692220387;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 21:13:58', '2023-08-16 21:13:58', 0, NULL),
 (218, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 21:15:58', '2023-08-16 21:15:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692220558;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692220558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 21:23:19', '2023-08-16 21:23:19', 0, NULL),
 (219, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 21:25:19', '2023-08-16 21:25:19', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692221119;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692221119;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 21:27:24', '2023-08-16 21:27:24', 0, NULL),
 (222, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 21:37:23', '2023-08-16 21:37:23', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692221843;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692221843;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 21:38:32', '2023-08-16 21:38:32', 0, NULL),
 (220, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 21:29:24', '2023-08-16 21:29:24', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692221364;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692221364;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 21:35:23', '2023-08-16 21:35:23', 0, NULL),
 (221, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-16 22:27:24', '2023-08-16 22:27:24', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692224844;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692224844;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-16 23:20:17', '2023-08-16 23:20:17', 0, NULL),
 (223, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 21:40:32', '2023-08-16 21:40:32', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692222032;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692222032;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 22:08:05', '2023-08-16 22:08:05', 0, NULL),
 (224, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 22:10:05', '2023-08-16 22:10:05', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692223805;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692223805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 22:15:35', '2023-08-16 22:15:35', 0, NULL),
 (225, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 22:17:35', '2023-08-16 22:17:35', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692224255;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692224255;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 22:27:17', '2023-08-16 22:27:17', 0, NULL),
 (226, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 22:29:17', '2023-08-16 22:29:17', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692224957;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692224957;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 23:20:17', '2023-08-16 23:20:17', 0, NULL),
 (227, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-17 00:20:17', '2023-08-17 00:20:17', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692231617;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692231617;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-17 00:23:34', '2023-08-17 00:23:34', 0, NULL),
 (229, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 23:28:38', '2023-08-16 23:28:38', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692228518;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692228518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 23:37:32', '2023-08-16 23:37:32', 0, NULL),
 (228, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 23:22:17', '2023-08-16 23:22:17', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692228137;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692228137;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-16 23:26:38', '2023-08-16 23:26:38', 0, NULL),
 (230, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-16 23:39:32', '2023-08-16 23:39:32', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692229172;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692229172;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 00:23:34', '2023-08-17 00:23:34', 0, NULL),
 (233, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 00:31:51', '2023-08-17 00:31:51', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692232311;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692232311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 00:40:09', '2023-08-17 00:40:09', 0, NULL),
 (231, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 00:25:34', '2023-08-17 00:25:34', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692231934;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692231934;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 00:29:51', '2023-08-17 00:29:51', 0, NULL),
 (232, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-17 01:23:34', '2023-08-17 01:23:34', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692235414;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692235414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-17 01:23:43', '2023-08-17 01:23:43', 0, NULL),
 (234, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 00:42:09', '2023-08-17 00:42:09', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692232929;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692232929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 00:45:22', '2023-08-17 00:45:22', 0, NULL),
 (235, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 00:47:22', '2023-08-17 00:47:22', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692233242;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692233242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 00:54:01', '2023-08-17 00:54:01', 0, NULL),
 (236, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 00:56:01', '2023-08-17 00:56:01', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692233761;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692233761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 00:57:02', '2023-08-17 00:57:02', 0, NULL),
 (237, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 00:59:02', '2023-08-17 00:59:02', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692233942;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692233942;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 00:59:07', '2023-08-17 00:59:07', 0, NULL),
 (238, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 01:01:07', '2023-08-17 01:01:07', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692234067;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692234067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 01:01:57', '2023-08-17 01:01:57', 0, NULL),
 (239, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 01:03:57', '2023-08-17 01:03:57', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692234237;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692234237;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 01:04:09', '2023-08-17 01:04:09', 0, NULL),
 (240, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 01:06:09', '2023-08-17 01:06:09', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692234369;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692234369;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 01:07:21', '2023-08-17 01:07:21', 0, NULL),
 (241, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 01:09:21', '2023-08-17 01:09:21', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692234561;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692234561;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 01:09:56', '2023-08-17 01:09:56', 0, NULL),
 (242, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 01:11:56', '2023-08-17 01:11:56', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692234716;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692234716;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 01:12:17', '2023-08-17 01:12:17', 0, NULL),
 (243, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 01:14:17', '2023-08-17 01:14:17', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692234857;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692234857;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 01:14:43', '2023-08-17 01:14:43', 0, NULL),
 (244, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 01:16:43', '2023-08-17 01:16:43', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692235003;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692235003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 01:16:54', '2023-08-17 01:16:54', 0, NULL),
 (245, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 01:18:54', '2023-08-17 01:18:54', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692235134;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692235134;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 01:19:14', '2023-08-17 01:19:14', 0, NULL),
 (246, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 01:21:14', '2023-08-17 01:21:14', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692235274;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692235274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 01:21:24', '2023-08-17 01:21:24', 0, NULL),
 (247, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 01:23:24', '2023-08-17 01:23:24', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692235404;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692235404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 01:23:43', '2023-08-17 01:23:43', 0, NULL),
 (250, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 01:28:21', '2023-08-17 01:28:21', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692235701;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692235701;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 01:28:22', '2023-08-17 01:28:22', 0, NULL),
 (248, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 01:25:43', '2023-08-17 01:25:43', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692235543;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692235543;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 01:26:21', '2023-08-17 01:26:21', 0, NULL),
 (249, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-17 02:23:43', '2023-08-17 02:23:43', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692239023;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692239023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-17 02:24:10', '2023-08-17 02:24:10', 0, NULL),
 (251, 'mailpoet/cron/daemon-trigger', 'complete', '2023-08-17 01:30:22', '2023-08-17 01:30:22', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692235822;s:18:\"\0*\0first_timestamp\";i:1692177173;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692235822;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}', 6, 1, '2023-08-17 01:31:00', '2023-08-17 01:31:00', 0, NULL),
 (254, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-17 03:24:10', '2023-08-17 03:24:10', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692242650;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692242650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-17 03:24:45', '2023-08-17 03:24:45', 0, NULL),
 (253, 'action_scheduler/migration_hook', 'complete', '2023-08-17 01:33:24', '2023-08-17 01:33:24', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692236004;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692236004;}', 1, 1, '2023-08-17 01:33:58', '2023-08-17 01:33:58', 0, NULL),
 (255, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-17 04:24:45', '2023-08-17 04:24:45', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692246285;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692246285;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-17 04:24:58', '2023-08-17 04:24:58', 0, NULL),
 (256, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-17 05:24:58', '2023-08-17 05:24:58', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692249898;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692249898;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-17 05:47:52', '2023-08-17 05:47:52', 0, NULL),
 (257, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-17 06:47:52', '2023-08-17 06:47:52', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692254872;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692254872;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-17 07:01:05', '2023-08-17 07:01:05', 0, NULL),
 (258, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-17 08:01:05', '2023-08-17 08:01:05', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692259265;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692259265;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-17 08:01:17', '2023-08-17 08:01:17', 0, NULL),
 (259, 'solid_affiliate/notifications/email/Affiliate/new_registration', 'complete', '2023-08-17 07:09:02', '2023-08-17 07:09:02', 10, '{\"to\":[\"s27101995@gmail.com\"],\"affiliate_id\":1,\"user_id\":2}', 'O:28:\"ActionScheduler_NullSchedule\":0:{}', 7, 1, '2023-08-17 07:09:04', '2023-08-17 07:09:04', 0, NULL),
 (260, 'solid_affiliate/notifications/email/Affiliate/application_approved', 'complete', '2023-08-17 07:11:17', '2023-08-17 07:11:17', 10, '{\"affiliate_id\":\"1\"}', 'O:28:\"ActionScheduler_NullSchedule\":0:{}', 7, 1, '2023-08-17 07:11:19', '2023-08-17 07:11:19', 0, NULL),
 (261, 'pinterest_for_woocommerce_hourly_heartbeat', 'complete', '2023-08-17 09:01:17', '2023-08-17 09:01:17', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692262877;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692262877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 1, '2023-08-17 09:01:40', '2023-08-17 09:01:40', 0, NULL),
 (262, 'wc_schedule_update_product_default_cat', 'complete', '2023-08-17 08:58:58', '2023-08-17 08:58:58', 10, '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1692262738;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1692262738;}', 3, 1, '2023-08-17 08:59:00', '2023-08-17 08:59:00', 0, NULL),
 (263, 'pinterest_for_woocommerce_hourly_heartbeat', 'pending', '2023-08-17 10:01:40', '2023-08-17 10:01:40', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692266500;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692266500;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}', 5, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, NULL),
 (264, 'pinterest_for_woocommerce_daily_heartbeat', 'pending', '2023-08-18 09:14:00', '2023-08-18 09:14:00', 10, '[]', 'O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1692350040;s:18:\"\0*\0first_timestamp\";i:1692177171;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1692350040;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}', 5, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, NULL);

/* INSERT TABLE DATA: jLLYHvjea_actionscheduler_groups */
INSERT INTO `jLLYHvjea_actionscheduler_groups` VALUES(1, 'action-scheduler-migration'),
 (2, ''),
 (3, 'wc_update_product_default_cat'),
 (4, 'woocommerce-db-updates'),
 (5, 'pinterest-for-woocommerce'),
 (6, 'mailpoet-cron'),
 (7, 'solid_affiliate/notifications');

/* INSERT TABLE DATA: jLLYHvjea_actionscheduler_logs */
INSERT INTO `jLLYHvjea_actionscheduler_logs` VALUES(1, 6, 'action created', '2023-08-15 15:03:58', '2023-08-15 15:03:58'),
 (2, 7, 'action created', '2023-08-15 15:03:58', '2023-08-15 15:03:58'),
 (3, 7, 'action started via WP Cron', '2023-08-15 15:03:59', '2023-08-15 15:03:59'),
 (4, 7, 'action complete via WP Cron', '2023-08-15 15:03:59', '2023-08-15 15:03:59'),
 (5, 8, 'action created', '2023-08-15 15:03:59', '2023-08-15 15:03:59'),
 (6, 6, 'action started via Async Request', '2023-08-15 15:05:19', '2023-08-15 15:05:19'),
 (7, 6, 'action complete via Async Request', '2023-08-15 15:05:19', '2023-08-15 15:05:19'),
 (8, 9, 'hành động được tạo', '2023-08-15 15:14:20', '2023-08-15 15:14:20'),
 (9, 9, 'action started via Async Request', '2023-08-15 15:14:30', '2023-08-15 15:14:30'),
 (10, 9, 'action failed via Async Request: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.', '2023-08-15 15:14:30', '2023-08-15 15:14:30'),
 (11, 10, 'hành động được tạo', '2023-08-16 06:56:31', '2023-08-16 06:56:31'),
 (12, 10, 'action started via Async Request', '2023-08-16 06:56:32', '2023-08-16 06:56:32'),
 (13, 10, 'action complete via Async Request', '2023-08-16 06:56:32', '2023-08-16 06:56:32'),
 (14, 11, 'hành động được tạo', '2023-08-16 06:58:57', '2023-08-16 06:58:57'),
 (15, 12, 'hành động được tạo', '2023-08-16 06:58:57', '2023-08-16 06:58:57'),
 (16, 13, 'hành động được tạo', '2023-08-16 06:58:57', '2023-08-16 06:58:57'),
 (17, 14, 'hành động được tạo', '2023-08-16 06:58:57', '2023-08-16 06:58:57'),
 (18, 15, 'hành động được tạo', '2023-08-16 06:58:57', '2023-08-16 06:58:57'),
 (19, 11, 'action started via WP Cron', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (20, 11, 'action complete via WP Cron', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (21, 12, 'action started via WP Cron', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (22, 12, 'action complete via WP Cron', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (23, 16, 'hành động được tạo', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (24, 13, 'action started via WP Cron', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (25, 13, 'action complete via WP Cron', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (26, 14, 'action started via WP Cron', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (27, 14, 'action complete via WP Cron', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (28, 15, 'action started via WP Cron', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (29, 15, 'action complete via WP Cron', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (30, 16, 'action started via WP Cron', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (31, 16, 'action complete via WP Cron', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (32, 17, 'hành động được tạo', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (33, 18, 'hành động được tạo', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (34, 19, 'hành động được tạo', '2023-08-16 06:58:58', '2023-08-16 06:58:58'),
 (35, 17, 'action started via WP Cron', '2023-08-16 07:00:03', '2023-08-16 07:00:03'),
 (36, 17, 'action complete via WP Cron', '2023-08-16 07:00:03', '2023-08-16 07:00:03'),
 (37, 18, 'action started via WP Cron', '2023-08-16 07:00:03', '2023-08-16 07:00:03'),
 (38, 18, 'action complete via WP Cron', '2023-08-16 07:00:03', '2023-08-16 07:00:03'),
 (39, 19, 'action started via WP Cron', '2023-08-16 07:00:03', '2023-08-16 07:00:03'),
 (40, 19, 'action complete via WP Cron', '2023-08-16 07:00:03', '2023-08-16 07:00:03'),
 (41, 20, 'hành động được tạo', '2023-08-16 07:36:26', '2023-08-16 07:36:26'),
 (42, 20, 'action started via WP Cron', '2023-08-16 07:37:30', '2023-08-16 07:37:30'),
 (43, 20, 'action complete via WP Cron', '2023-08-16 07:37:30', '2023-08-16 07:37:30'),
 (44, 21, 'hành động được tạo', '2023-08-16 07:37:30', '2023-08-16 07:37:30'),
 (45, 21, 'action started via Async Request', '2023-08-16 07:38:36', '2023-08-16 07:38:36'),
 (46, 21, 'action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.', '2023-08-16 07:38:36', '2023-08-16 07:38:36'),
 (47, 22, 'hành động được tạo', '2023-08-16 08:51:18', '2023-08-16 08:51:18'),
 (48, 23, 'hành động được tạo', '2023-08-16 08:51:18', '2023-08-16 08:51:18'),
 (49, 24, 'hành động được tạo', '2023-08-16 08:51:18', '2023-08-16 08:51:18'),
 (50, 25, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (51, 26, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (52, 27, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (53, 28, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (54, 29, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (55, 30, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (56, 31, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (57, 32, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (58, 33, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (59, 34, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (60, 35, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (61, 36, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (62, 37, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (63, 38, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (64, 39, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (65, 40, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (66, 41, 'hành động được tạo', '2023-08-16 08:51:19', '2023-08-16 08:51:19'),
 (67, 22, 'action started via WP Cron', '2023-08-16 08:52:57', '2023-08-16 08:52:57'),
 (68, 22, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (69, 23, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (70, 23, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (71, 24, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (72, 24, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (73, 25, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (74, 25, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (75, 26, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (76, 26, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (77, 27, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (78, 27, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (79, 28, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (80, 28, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (81, 29, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (82, 29, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (83, 30, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (84, 30, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (85, 31, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (86, 31, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (87, 32, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (88, 32, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (89, 33, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (90, 33, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (91, 34, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (92, 34, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (93, 35, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (94, 35, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (95, 36, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (96, 36, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (97, 37, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (98, 37, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (99, 38, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (100, 38, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (101, 39, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (102, 39, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (103, 40, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (104, 40, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (105, 41, 'action started via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (106, 41, 'action complete via WP Cron', '2023-08-16 08:52:58', '2023-08-16 08:52:58'),
 (107, 42, 'hành động được tạo', '2023-08-16 08:53:01', '2023-08-16 08:53:01'),
 (108, 43, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (109, 44, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (110, 45, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (111, 46, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (112, 47, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (113, 48, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (114, 49, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (115, 50, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (116, 51, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (117, 52, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (118, 53, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (119, 54, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (120, 55, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (121, 56, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (122, 57, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (123, 58, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (124, 59, 'hành động được tạo', '2023-08-16 08:53:02', '2023-08-16 08:53:02'),
 (125, 60, 'hành động được tạo', '2023-08-16 08:53:03', '2023-08-16 08:53:03'),
 (126, 61, 'hành động được tạo', '2023-08-16 08:53:03', '2023-08-16 08:53:03'),
 (127, 42, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (128, 42, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (129, 43, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (130, 43, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (131, 44, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (132, 44, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (133, 45, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (134, 45, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (135, 46, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (136, 46, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (137, 47, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (138, 47, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (139, 48, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (140, 48, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (141, 49, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (142, 49, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (143, 50, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (144, 50, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (145, 51, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (146, 51, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (147, 52, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (148, 52, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (149, 53, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (150, 53, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (151, 54, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (152, 54, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (153, 55, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (154, 55, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (155, 56, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (156, 56, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (157, 57, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (158, 57, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (159, 58, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (160, 58, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (161, 59, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (162, 59, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (163, 60, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (164, 60, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (165, 61, 'action started via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (166, 61, 'action complete via Async Request', '2023-08-16 08:53:05', '2023-08-16 08:53:05'),
 (167, 62, 'hành động được tạo', '2023-08-16 08:53:17', '2023-08-16 08:53:17'),
 (168, 63, 'hành động được tạo', '2023-08-16 08:53:17', '2023-08-16 08:53:17'),
 (169, 64, 'hành động được tạo', '2023-08-16 08:53:17', '2023-08-16 08:53:17'),
 (170, 65, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (171, 66, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (172, 67, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (173, 68, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (174, 69, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (175, 70, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (176, 71, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (177, 72, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (178, 73, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (179, 74, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (180, 75, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (181, 76, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (182, 77, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (183, 78, 'hành động được tạo', '2023-08-16 08:53:18', '2023-08-16 08:53:18'),
 (184, 62, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (185, 62, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (186, 63, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (187, 63, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (188, 64, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (189, 64, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (190, 65, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (191, 65, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (192, 66, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (193, 66, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (194, 67, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (195, 67, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (196, 68, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (197, 68, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (198, 69, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (199, 69, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (200, 70, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (201, 70, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (202, 71, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (203, 71, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (204, 72, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (205, 72, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (206, 73, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (207, 73, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (208, 74, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (209, 74, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (210, 75, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (211, 75, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (212, 76, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (213, 76, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (214, 77, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (215, 77, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (216, 78, 'action started via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (217, 78, 'action complete via WP Cron', '2023-08-16 08:53:59', '2023-08-16 08:53:59'),
 (218, 79, 'hành động được tạo', '2023-08-16 09:12:49', '2023-08-16 09:12:49'),
 (219, 80, 'hành động được tạo', '2023-08-16 09:12:51', '2023-08-16 09:12:51'),
 (220, 81, 'hành động được tạo', '2023-08-16 09:12:51', '2023-08-16 09:12:51'),
 (221, 82, 'hành động được tạo', '2023-08-16 09:12:53', '2023-08-16 09:12:53'),
 (222, 79, 'action started via Async Request', '2023-08-16 09:12:54', '2023-08-16 09:12:54'),
 (223, 79, 'action complete via Async Request', '2023-08-16 09:13:12', '2023-08-16 09:13:12'),
 (224, 80, 'action started via Async Request', '2023-08-16 09:13:21', '2023-08-16 09:13:21'),
 (225, 80, 'action complete via Async Request', '2023-08-16 09:13:22', '2023-08-16 09:13:22'),
 (226, 83, 'hành động được tạo', '2023-08-16 09:13:22', '2023-08-16 09:13:22'),
 (227, 81, 'action started via Async Request', '2023-08-16 09:13:22', '2023-08-16 09:13:22'),
 (228, 81, 'action complete via Async Request', '2023-08-16 09:13:22', '2023-08-16 09:13:22'),
 (229, 84, 'hành động được tạo', '2023-08-16 09:13:22', '2023-08-16 09:13:22'),
 (230, 82, 'action started via Async Request', '2023-08-16 09:13:22', '2023-08-16 09:13:22'),
 (231, 85, 'hành động được tạo', '2023-08-16 09:13:22', '2023-08-16 09:13:22'),
 (232, 85, 'action started via WP Cron', '2023-08-16 09:13:23', '2023-08-16 09:13:23'),
 (233, 85, 'action complete via WP Cron', '2023-08-16 09:13:23', '2023-08-16 09:13:23'),
 (234, 82, 'action complete via Async Request', '2023-08-16 09:13:23', '2023-08-16 09:13:23'),
 (235, 86, 'hành động được tạo', '2023-08-16 09:13:23', '2023-08-16 09:13:23'),
 (236, 86, 'action started via WP Cron', '2023-08-16 09:15:37', '2023-08-16 09:15:37'),
 (237, 87, 'hành động được tạo', '2023-08-16 09:15:38', '2023-08-16 09:15:38'),
 (238, 86, 'action complete via WP Cron', '2023-08-16 09:15:43', '2023-08-16 09:15:43'),
 (239, 88, 'hành động được tạo', '2023-08-16 09:15:43', '2023-08-16 09:15:43'),
 (240, 87, 'action started via WP Cron', '2023-08-16 09:15:52', '2023-08-16 09:15:52'),
 (241, 87, 'action complete via WP Cron', '2023-08-16 09:15:55', '2023-08-16 09:15:55'),
 (242, 88, 'action started via WP Cron', '2023-08-16 09:17:59', '2023-08-16 09:17:59'),
 (243, 88, 'action complete via WP Cron', '2023-08-16 09:17:59', '2023-08-16 09:17:59'),
 (244, 89, 'hành động được tạo', '2023-08-16 09:17:59', '2023-08-16 09:17:59'),
 (245, 89, 'action started via WP Cron', '2023-08-16 09:20:06', '2023-08-16 09:20:06'),
 (246, 89, 'action complete via WP Cron', '2023-08-16 09:20:06', '2023-08-16 09:20:06'),
 (247, 90, 'hành động được tạo', '2023-08-16 09:20:06', '2023-08-16 09:20:06'),
 (248, 90, 'action started via WP Cron', '2023-08-16 09:22:31', '2023-08-16 09:22:31'),
 (249, 90, 'action complete via WP Cron', '2023-08-16 09:22:31', '2023-08-16 09:22:31'),
 (250, 91, 'hành động được tạo', '2023-08-16 09:22:31', '2023-08-16 09:22:31'),
 (251, 91, 'action started via WP Cron', '2023-08-16 09:25:12', '2023-08-16 09:25:12'),
 (252, 91, 'action complete via WP Cron', '2023-08-16 09:25:13', '2023-08-16 09:25:13'),
 (253, 92, 'hành động được tạo', '2023-08-16 09:25:13', '2023-08-16 09:25:13'),
 (254, 92, 'action started via Async Request', '2023-08-16 09:27:50', '2023-08-16 09:27:50'),
 (255, 92, 'action complete via Async Request', '2023-08-16 09:27:50', '2023-08-16 09:27:50'),
 (256, 93, 'hành động được tạo', '2023-08-16 09:27:50', '2023-08-16 09:27:50'),
 (257, 93, 'action started via WP Cron', '2023-08-16 09:30:35', '2023-08-16 09:30:35'),
 (258, 93, 'action complete via WP Cron', '2023-08-16 09:30:35', '2023-08-16 09:30:35'),
 (259, 94, 'hành động được tạo', '2023-08-16 09:30:35', '2023-08-16 09:30:35'),
 (260, 94, 'action started via WP Cron', '2023-08-16 09:32:51', '2023-08-16 09:32:51'),
 (261, 94, 'action complete via WP Cron', '2023-08-16 09:32:51', '2023-08-16 09:32:51'),
 (262, 95, 'hành động được tạo', '2023-08-16 09:32:51', '2023-08-16 09:32:51'),
 (263, 95, 'action started via WP Cron', '2023-08-16 09:35:37', '2023-08-16 09:35:37'),
 (264, 95, 'action complete via WP Cron', '2023-08-16 09:35:37', '2023-08-16 09:35:37'),
 (265, 96, 'hành động được tạo', '2023-08-16 09:35:37', '2023-08-16 09:35:37'),
 (266, 96, 'action started via WP Cron', '2023-08-16 09:38:14', '2023-08-16 09:38:14'),
 (267, 96, 'action complete via WP Cron', '2023-08-16 09:38:14', '2023-08-16 09:38:14'),
 (268, 97, 'hành động được tạo', '2023-08-16 09:38:14', '2023-08-16 09:38:14'),
 (269, 97, 'action started via WP Cron', '2023-08-16 09:46:47', '2023-08-16 09:46:47'),
 (270, 97, 'action complete via WP Cron', '2023-08-16 09:46:47', '2023-08-16 09:46:47'),
 (271, 98, 'hành động được tạo', '2023-08-16 09:46:47', '2023-08-16 09:46:47'),
 (272, 98, 'action started via WP Cron', '2023-08-16 09:54:18', '2023-08-16 09:54:18'),
 (273, 98, 'action complete via WP Cron', '2023-08-16 09:54:18', '2023-08-16 09:54:18'),
 (274, 99, 'hành động được tạo', '2023-08-16 09:54:18', '2023-08-16 09:54:18'),
 (275, 99, 'action started via WP Cron', '2023-08-16 09:56:57', '2023-08-16 09:56:57'),
 (276, 99, 'action complete via WP Cron', '2023-08-16 09:56:57', '2023-08-16 09:56:57'),
 (277, 100, 'hành động được tạo', '2023-08-16 09:56:57', '2023-08-16 09:56:57'),
 (278, 100, 'action started via WP Cron', '2023-08-16 09:58:58', '2023-08-16 09:58:58'),
 (279, 100, 'action complete via WP Cron', '2023-08-16 09:58:58', '2023-08-16 09:58:58'),
 (280, 101, 'hành động được tạo', '2023-08-16 09:58:58', '2023-08-16 09:58:58'),
 (281, 101, 'action started via WP Cron', '2023-08-16 10:00:58', '2023-08-16 10:00:58'),
 (282, 101, 'action complete via WP Cron', '2023-08-16 10:00:58', '2023-08-16 10:00:58'),
 (283, 102, 'hành động được tạo', '2023-08-16 10:00:58', '2023-08-16 10:00:58'),
 (284, 102, 'action started via WP Cron', '2023-08-16 10:02:58', '2023-08-16 10:02:58'),
 (285, 102, 'action complete via WP Cron', '2023-08-16 10:02:58', '2023-08-16 10:02:58'),
 (286, 103, 'hành động được tạo', '2023-08-16 10:02:58', '2023-08-16 10:02:58'),
 (287, 103, 'action started via Async Request', '2023-08-16 10:05:08', '2023-08-16 10:05:08'),
 (288, 103, 'action complete via Async Request', '2023-08-16 10:05:08', '2023-08-16 10:05:08'),
 (289, 104, 'hành động được tạo', '2023-08-16 10:05:08', '2023-08-16 10:05:08'),
 (290, 104, 'action started via WP Cron', '2023-08-16 10:09:08', '2023-08-16 10:09:08'),
 (291, 104, 'action complete via WP Cron', '2023-08-16 10:09:08', '2023-08-16 10:09:08'),
 (292, 105, 'hành động được tạo', '2023-08-16 10:09:08', '2023-08-16 10:09:08'),
 (293, 105, 'action started via WP Cron', '2023-08-16 10:13:00', '2023-08-16 10:13:00'),
 (294, 106, 'hành động được tạo', '2023-08-16 10:13:00', '2023-08-16 10:13:00'),
 (295, 106, 'action started via WP Cron', '2023-08-16 10:13:01', '2023-08-16 10:13:01'),
 (296, 106, 'action complete via WP Cron', '2023-08-16 10:13:01', '2023-08-16 10:13:01'),
 (297, 105, 'action complete via WP Cron', '2023-08-16 10:13:01', '2023-08-16 10:13:01'),
 (298, 107, 'hành động được tạo', '2023-08-16 10:13:01', '2023-08-16 10:13:01'),
 (299, 84, 'action started via WP Cron', '2023-08-16 10:14:03', '2023-08-16 10:14:03'),
 (300, 84, 'action complete via WP Cron', '2023-08-16 10:14:03', '2023-08-16 10:14:03'),
 (301, 108, 'hành động được tạo', '2023-08-16 10:14:03', '2023-08-16 10:14:03'),
 (302, 107, 'action started via WP Cron', '2023-08-16 10:15:18', '2023-08-16 10:15:18'),
 (303, 107, 'action complete via WP Cron', '2023-08-16 10:15:18', '2023-08-16 10:15:18'),
 (304, 109, 'hành động được tạo', '2023-08-16 10:15:18', '2023-08-16 10:15:18'),
 (305, 109, 'action started via WP Cron', '2023-08-16 10:47:35', '2023-08-16 10:47:35'),
 (306, 109, 'action complete via WP Cron', '2023-08-16 10:47:35', '2023-08-16 10:47:35'),
 (307, 110, 'hành động được tạo', '2023-08-16 10:47:35', '2023-08-16 10:47:35'),
 (308, 110, 'action started via WP Cron', '2023-08-16 11:09:21', '2023-08-16 11:09:21'),
 (309, 110, 'action complete via WP Cron', '2023-08-16 11:09:21', '2023-08-16 11:09:21'),
 (310, 111, 'hành động được tạo', '2023-08-16 11:09:21', '2023-08-16 11:09:21'),
 (311, 111, 'action started via WP Cron', '2023-08-16 11:16:10', '2023-08-16 11:16:10'),
 (312, 111, 'action complete via WP Cron', '2023-08-16 11:16:10', '2023-08-16 11:16:10'),
 (313, 112, 'hành động được tạo', '2023-08-16 11:16:10', '2023-08-16 11:16:10'),
 (314, 108, 'action started via WP Cron', '2023-08-16 11:16:10', '2023-08-16 11:16:10'),
 (315, 108, 'action complete via WP Cron', '2023-08-16 11:16:10', '2023-08-16 11:16:10'),
 (316, 113, 'hành động được tạo', '2023-08-16 11:16:10', '2023-08-16 11:16:10'),
 (317, 112, 'action started via WP Cron', '2023-08-16 11:19:27', '2023-08-16 11:19:27'),
 (318, 112, 'action complete via WP Cron', '2023-08-16 11:19:27', '2023-08-16 11:19:27'),
 (319, 114, 'hành động được tạo', '2023-08-16 11:19:27', '2023-08-16 11:19:27'),
 (320, 114, 'action started via WP Cron', '2023-08-16 11:21:30', '2023-08-16 11:21:30'),
 (321, 114, 'action complete via WP Cron', '2023-08-16 11:21:30', '2023-08-16 11:21:30'),
 (322, 115, 'hành động được tạo', '2023-08-16 11:21:30', '2023-08-16 11:21:30'),
 (323, 115, 'action started via WP Cron', '2023-08-16 11:24:01', '2023-08-16 11:24:01'),
 (324, 115, 'action complete via WP Cron', '2023-08-16 11:24:01', '2023-08-16 11:24:01'),
 (325, 116, 'hành động được tạo', '2023-08-16 11:24:01', '2023-08-16 11:24:01'),
 (326, 116, 'action started via WP Cron', '2023-08-16 11:26:58', '2023-08-16 11:26:58'),
 (327, 116, 'action complete via WP Cron', '2023-08-16 11:26:58', '2023-08-16 11:26:58'),
 (328, 117, 'hành động được tạo', '2023-08-16 11:26:58', '2023-08-16 11:26:58'),
 (329, 117, 'action started via WP Cron', '2023-08-16 11:28:59', '2023-08-16 11:28:59'),
 (330, 117, 'action complete via WP Cron', '2023-08-16 11:28:59', '2023-08-16 11:28:59'),
 (331, 118, 'hành động được tạo', '2023-08-16 11:28:59', '2023-08-16 11:28:59'),
 (332, 118, 'action started via WP Cron', '2023-08-16 11:38:17', '2023-08-16 11:38:17'),
 (333, 118, 'action complete via WP Cron', '2023-08-16 11:38:17', '2023-08-16 11:38:17'),
 (334, 119, 'hành động được tạo', '2023-08-16 11:38:17', '2023-08-16 11:38:17'),
 (335, 119, 'action started via WP Cron', '2023-08-16 11:43:36', '2023-08-16 11:43:36'),
 (336, 119, 'action complete via WP Cron', '2023-08-16 11:43:36', '2023-08-16 11:43:36'),
 (337, 120, 'hành động được tạo', '2023-08-16 11:43:36', '2023-08-16 11:43:36'),
 (338, 120, 'action started via WP Cron', '2023-08-16 11:46:11', '2023-08-16 11:46:11'),
 (339, 120, 'action complete via WP Cron', '2023-08-16 11:46:11', '2023-08-16 11:46:11'),
 (340, 121, 'hành động được tạo', '2023-08-16 11:46:11', '2023-08-16 11:46:11'),
 (341, 121, 'action started via WP Cron', '2023-08-16 11:48:35', '2023-08-16 11:48:35'),
 (342, 121, 'action complete via WP Cron', '2023-08-16 11:48:35', '2023-08-16 11:48:35'),
 (343, 122, 'hành động được tạo', '2023-08-16 11:48:35', '2023-08-16 11:48:35'),
 (344, 122, 'action started via WP Cron', '2023-08-16 12:16:30', '2023-08-16 12:16:30'),
 (345, 122, 'action complete via WP Cron', '2023-08-16 12:16:30', '2023-08-16 12:16:30'),
 (346, 123, 'hành động được tạo', '2023-08-16 12:16:30', '2023-08-16 12:16:30'),
 (347, 113, 'action started via WP Cron', '2023-08-16 12:16:30', '2023-08-16 12:16:30'),
 (348, 113, 'action complete via WP Cron', '2023-08-16 12:16:30', '2023-08-16 12:16:30'),
 (349, 124, 'hành động được tạo', '2023-08-16 12:16:30', '2023-08-16 12:16:30'),
 (350, 123, 'action started via WP Cron', '2023-08-16 12:18:58', '2023-08-16 12:18:58'),
 (351, 123, 'action complete via WP Cron', '2023-08-16 12:18:58', '2023-08-16 12:18:58'),
 (352, 125, 'hành động được tạo', '2023-08-16 12:18:58', '2023-08-16 12:18:58'),
 (353, 125, 'action started via WP Cron', '2023-08-16 12:21:59', '2023-08-16 12:21:59'),
 (354, 125, 'action complete via WP Cron', '2023-08-16 12:21:59', '2023-08-16 12:21:59'),
 (355, 126, 'hành động được tạo', '2023-08-16 12:21:59', '2023-08-16 12:21:59'),
 (356, 126, 'action started via Async Request', '2023-08-16 12:24:08', '2023-08-16 12:24:08'),
 (357, 126, 'action complete via Async Request', '2023-08-16 12:24:08', '2023-08-16 12:24:08'),
 (358, 127, 'hành động được tạo', '2023-08-16 12:24:08', '2023-08-16 12:24:08'),
 (359, 127, 'action started via WP Cron', '2023-08-16 12:27:06', '2023-08-16 12:27:06'),
 (360, 127, 'action complete via WP Cron', '2023-08-16 12:27:06', '2023-08-16 12:27:06'),
 (361, 128, 'hành động được tạo', '2023-08-16 12:27:06', '2023-08-16 12:27:06'),
 (362, 128, 'action started via WP Cron', '2023-08-16 12:38:17', '2023-08-16 12:38:17'),
 (363, 128, 'action complete via WP Cron', '2023-08-16 12:38:17', '2023-08-16 12:38:17'),
 (364, 129, 'hành động được tạo', '2023-08-16 12:38:17', '2023-08-16 12:38:17'),
 (365, 129, 'action started via WP Cron', '2023-08-16 12:45:13', '2023-08-16 12:45:13'),
 (366, 129, 'action complete via WP Cron', '2023-08-16 12:45:13', '2023-08-16 12:45:13'),
 (367, 130, 'hành động được tạo', '2023-08-16 12:45:13', '2023-08-16 12:45:13'),
 (368, 130, 'action started via WP Cron', '2023-08-16 13:23:48', '2023-08-16 13:23:48'),
 (369, 130, 'action complete via WP Cron', '2023-08-16 13:23:48', '2023-08-16 13:23:48'),
 (370, 131, 'hành động được tạo', '2023-08-16 13:23:48', '2023-08-16 13:23:48'),
 (371, 124, 'action started via WP Cron', '2023-08-16 13:23:48', '2023-08-16 13:23:48'),
 (372, 124, 'action complete via WP Cron', '2023-08-16 13:23:48', '2023-08-16 13:23:48'),
 (373, 132, 'hành động được tạo', '2023-08-16 13:23:48', '2023-08-16 13:23:48'),
 (374, 131, 'action started via WP Cron', '2023-08-16 13:25:59', '2023-08-16 13:25:59'),
 (375, 131, 'action complete via WP Cron', '2023-08-16 13:25:59', '2023-08-16 13:25:59'),
 (376, 133, 'hành động được tạo', '2023-08-16 13:25:59', '2023-08-16 13:25:59'),
 (377, 133, 'action started via WP Cron', '2023-08-16 13:28:57', '2023-08-16 13:28:57'),
 (378, 133, 'action complete via WP Cron', '2023-08-16 13:28:57', '2023-08-16 13:28:57'),
 (379, 134, 'hành động được tạo', '2023-08-16 13:28:57', '2023-08-16 13:28:57'),
 (380, 134, 'action started via WP Cron', '2023-08-16 13:30:58', '2023-08-16 13:30:58'),
 (381, 134, 'action complete via WP Cron', '2023-08-16 13:30:58', '2023-08-16 13:30:58'),
 (382, 135, 'hành động được tạo', '2023-08-16 13:30:58', '2023-08-16 13:30:58'),
 (383, 135, 'action started via WP Cron', '2023-08-16 13:35:02', '2023-08-16 13:35:02'),
 (384, 135, 'action complete via WP Cron', '2023-08-16 13:35:03', '2023-08-16 13:35:03'),
 (385, 136, 'hành động được tạo', '2023-08-16 13:35:03', '2023-08-16 13:35:03'),
 (386, 136, 'action started via Async Request', '2023-08-16 13:37:06', '2023-08-16 13:37:06'),
 (387, 136, 'action complete via Async Request', '2023-08-16 13:37:06', '2023-08-16 13:37:06'),
 (388, 137, 'hành động được tạo', '2023-08-16 13:37:06', '2023-08-16 13:37:06'),
 (389, 137, 'action started via WP Cron', '2023-08-16 13:39:08', '2023-08-16 13:39:08'),
 (390, 137, 'action complete via WP Cron', '2023-08-16 13:39:08', '2023-08-16 13:39:08'),
 (391, 138, 'hành động được tạo', '2023-08-16 13:39:08', '2023-08-16 13:39:08'),
 (392, 138, 'action started via WP Cron', '2023-08-16 13:41:44', '2023-08-16 13:41:44'),
 (393, 138, 'action complete via WP Cron', '2023-08-16 13:41:44', '2023-08-16 13:41:44'),
 (394, 139, 'hành động được tạo', '2023-08-16 13:41:44', '2023-08-16 13:41:44'),
 (395, 139, 'action started via Async Request', '2023-08-16 13:43:58', '2023-08-16 13:43:58'),
 (396, 139, 'action complete via Async Request', '2023-08-16 13:43:58', '2023-08-16 13:43:58'),
 (397, 140, 'hành động được tạo', '2023-08-16 13:43:58', '2023-08-16 13:43:58'),
 (398, 140, 'action started via WP Cron', '2023-08-16 13:45:58', '2023-08-16 13:45:58'),
 (399, 140, 'action complete via WP Cron', '2023-08-16 13:45:58', '2023-08-16 13:45:58'),
 (400, 141, 'hành động được tạo', '2023-08-16 13:45:58', '2023-08-16 13:45:58'),
 (401, 141, 'action started via WP Cron', '2023-08-16 13:48:17', '2023-08-16 13:48:17'),
 (402, 141, 'action complete via WP Cron', '2023-08-16 13:48:17', '2023-08-16 13:48:17'),
 (403, 142, 'hành động được tạo', '2023-08-16 13:48:17', '2023-08-16 13:48:17'),
 (404, 142, 'action started via WP Cron', '2023-08-16 13:51:01', '2023-08-16 13:51:01'),
 (405, 142, 'action complete via WP Cron', '2023-08-16 13:51:01', '2023-08-16 13:51:01'),
 (406, 143, 'hành động được tạo', '2023-08-16 13:51:01', '2023-08-16 13:51:01'),
 (407, 143, 'action started via WP Cron', '2023-08-16 13:53:09', '2023-08-16 13:53:09'),
 (408, 143, 'action complete via WP Cron', '2023-08-16 13:53:09', '2023-08-16 13:53:09'),
 (409, 144, 'hành động được tạo', '2023-08-16 13:53:09', '2023-08-16 13:53:09'),
 (410, 144, 'action started via Async Request', '2023-08-16 13:55:13', '2023-08-16 13:55:13'),
 (411, 144, 'action complete via Async Request', '2023-08-16 13:55:13', '2023-08-16 13:55:13'),
 (412, 145, 'hành động được tạo', '2023-08-16 13:55:13', '2023-08-16 13:55:13'),
 (413, 145, 'action started via Async Request', '2023-08-16 13:58:13', '2023-08-16 13:58:13'),
 (414, 145, 'action complete via Async Request', '2023-08-16 13:58:13', '2023-08-16 13:58:13'),
 (415, 146, 'hành động được tạo', '2023-08-16 13:58:13', '2023-08-16 13:58:13'),
 (416, 146, 'action started via WP Cron', '2023-08-16 14:00:28', '2023-08-16 14:00:28'),
 (417, 146, 'action complete via WP Cron', '2023-08-16 14:00:28', '2023-08-16 14:00:28'),
 (418, 147, 'hành động được tạo', '2023-08-16 14:00:28', '2023-08-16 14:00:28'),
 (419, 147, 'action started via WP Cron', '2023-08-16 14:03:28', '2023-08-16 14:03:28'),
 (420, 147, 'action complete via WP Cron', '2023-08-16 14:03:28', '2023-08-16 14:03:28'),
 (421, 148, 'hành động được tạo', '2023-08-16 14:03:28', '2023-08-16 14:03:28'),
 (422, 148, 'action started via WP Cron', '2023-08-16 14:06:22', '2023-08-16 14:06:22'),
 (423, 148, 'action complete via WP Cron', '2023-08-16 14:06:22', '2023-08-16 14:06:22'),
 (424, 149, 'hành động được tạo', '2023-08-16 14:06:22', '2023-08-16 14:06:22'),
 (425, 149, 'action started via WP Cron', '2023-08-16 14:08:57', '2023-08-16 14:08:57'),
 (426, 149, 'action complete via WP Cron', '2023-08-16 14:08:57', '2023-08-16 14:08:57'),
 (427, 150, 'hành động được tạo', '2023-08-16 14:08:57', '2023-08-16 14:08:57'),
 (428, 150, 'action started via WP Cron', '2023-08-16 14:11:04', '2023-08-16 14:11:04'),
 (429, 150, 'action complete via WP Cron', '2023-08-16 14:11:04', '2023-08-16 14:11:04'),
 (430, 151, 'hành động được tạo', '2023-08-16 14:11:04', '2023-08-16 14:11:04'),
 (431, 151, 'action started via WP Cron', '2023-08-16 14:13:33', '2023-08-16 14:13:33'),
 (432, 151, 'action complete via WP Cron', '2023-08-16 14:13:33', '2023-08-16 14:13:33'),
 (433, 152, 'hành động được tạo', '2023-08-16 14:13:33', '2023-08-16 14:13:33'),
 (434, 152, 'action started via Async Request', '2023-08-16 14:16:19', '2023-08-16 14:16:19'),
 (435, 152, 'action complete via Async Request', '2023-08-16 14:16:19', '2023-08-16 14:16:19'),
 (436, 153, 'hành động được tạo', '2023-08-16 14:16:19', '2023-08-16 14:16:19'),
 (437, 153, 'action started via WP Cron', '2023-08-16 14:18:28', '2023-08-16 14:18:28'),
 (438, 153, 'action complete via WP Cron', '2023-08-16 14:18:28', '2023-08-16 14:18:28'),
 (439, 154, 'hành động được tạo', '2023-08-16 14:18:28', '2023-08-16 14:18:28'),
 (440, 154, 'action started via Async Request', '2023-08-16 14:20:45', '2023-08-16 14:20:45'),
 (441, 154, 'action complete via Async Request', '2023-08-16 14:20:45', '2023-08-16 14:20:45'),
 (442, 155, 'hành động được tạo', '2023-08-16 14:20:45', '2023-08-16 14:20:45'),
 (443, 155, 'action started via WP Cron', '2023-08-16 14:23:05', '2023-08-16 14:23:05'),
 (444, 155, 'action complete via WP Cron', '2023-08-16 14:23:05', '2023-08-16 14:23:05'),
 (445, 156, 'hành động được tạo', '2023-08-16 14:23:05', '2023-08-16 14:23:05'),
 (446, 132, 'action started via WP Cron', '2023-08-16 14:23:59', '2023-08-16 14:23:59'),
 (447, 132, 'action complete via WP Cron', '2023-08-16 14:23:59', '2023-08-16 14:23:59'),
 (448, 157, 'hành động được tạo', '2023-08-16 14:23:59', '2023-08-16 14:23:59'),
 (449, 156, 'action started via Async Request', '2023-08-16 14:25:13', '2023-08-16 14:25:13'),
 (450, 156, 'action complete via Async Request', '2023-08-16 14:25:13', '2023-08-16 14:25:13'),
 (451, 158, 'hành động được tạo', '2023-08-16 14:25:13', '2023-08-16 14:25:13'),
 (452, 158, 'action started via Async Request', '2023-08-16 14:27:37', '2023-08-16 14:27:37'),
 (453, 158, 'action complete via Async Request', '2023-08-16 14:27:37', '2023-08-16 14:27:37'),
 (454, 159, 'hành động được tạo', '2023-08-16 14:27:37', '2023-08-16 14:27:37'),
 (455, 159, 'action started via WP Cron', '2023-08-16 14:29:59', '2023-08-16 14:29:59'),
 (456, 159, 'action complete via WP Cron', '2023-08-16 14:29:59', '2023-08-16 14:29:59'),
 (457, 160, 'hành động được tạo', '2023-08-16 14:29:59', '2023-08-16 14:29:59'),
 (458, 160, 'action started via WP Cron', '2023-08-16 14:32:07', '2023-08-16 14:32:07'),
 (459, 160, 'action complete via WP Cron', '2023-08-16 14:32:07', '2023-08-16 14:32:07'),
 (460, 161, 'hành động được tạo', '2023-08-16 14:32:07', '2023-08-16 14:32:07'),
 (461, 161, 'action started via WP Cron', '2023-08-16 14:34:59', '2023-08-16 14:34:59'),
 (462, 161, 'action complete via WP Cron', '2023-08-16 14:34:59', '2023-08-16 14:34:59'),
 (463, 162, 'hành động được tạo', '2023-08-16 14:34:59', '2023-08-16 14:34:59'),
 (464, 162, 'action started via WP Cron', '2023-08-16 14:37:00', '2023-08-16 14:37:00'),
 (465, 162, 'action complete via WP Cron', '2023-08-16 14:37:00', '2023-08-16 14:37:00'),
 (466, 163, 'hành động được tạo', '2023-08-16 14:37:00', '2023-08-16 14:37:00'),
 (467, 163, 'action started via Async Request', '2023-08-16 14:39:07', '2023-08-16 14:39:07'),
 (468, 163, 'action complete via Async Request', '2023-08-16 14:39:07', '2023-08-16 14:39:07'),
 (469, 164, 'hành động được tạo', '2023-08-16 14:39:07', '2023-08-16 14:39:07'),
 (470, 164, 'action started via Async Request', '2023-08-16 14:41:40', '2023-08-16 14:41:40'),
 (471, 164, 'action complete via Async Request', '2023-08-16 14:41:40', '2023-08-16 14:41:40'),
 (472, 165, 'hành động được tạo', '2023-08-16 14:41:40', '2023-08-16 14:41:40'),
 (473, 165, 'action started via WP Cron', '2023-08-16 14:47:08', '2023-08-16 14:47:08'),
 (474, 165, 'action complete via WP Cron', '2023-08-16 14:47:08', '2023-08-16 14:47:08'),
 (475, 166, 'hành động được tạo', '2023-08-16 14:47:08', '2023-08-16 14:47:08'),
 (476, 166, 'action started via WP Cron', '2023-08-16 14:52:28', '2023-08-16 14:52:28'),
 (477, 166, 'action complete via WP Cron', '2023-08-16 14:52:28', '2023-08-16 14:52:28'),
 (478, 167, 'hành động được tạo', '2023-08-16 14:52:28', '2023-08-16 14:52:28'),
 (479, 167, 'action started via WP Cron', '2023-08-16 15:00:19', '2023-08-16 15:00:19'),
 (480, 167, 'action complete via WP Cron', '2023-08-16 15:00:19', '2023-08-16 15:00:19'),
 (481, 168, 'hành động được tạo', '2023-08-16 15:00:19', '2023-08-16 15:00:19'),
 (482, 168, 'action started via WP Cron', '2023-08-16 15:02:52', '2023-08-16 15:02:52'),
 (483, 168, 'action complete via WP Cron', '2023-08-16 15:02:52', '2023-08-16 15:02:52'),
 (484, 169, 'hành động được tạo', '2023-08-16 15:02:52', '2023-08-16 15:02:52'),
 (485, 8, 'action started via WP Cron', '2023-08-16 15:06:44', '2023-08-16 15:06:44'),
 (486, 8, 'action complete via WP Cron', '2023-08-16 15:06:44', '2023-08-16 15:06:44'),
 (487, 170, 'hành động được tạo', '2023-08-16 15:06:44', '2023-08-16 15:06:44'),
 (488, 169, 'action started via WP Cron', '2023-08-16 15:06:44', '2023-08-16 15:06:44'),
 (489, 169, 'action complete via WP Cron', '2023-08-16 15:06:44', '2023-08-16 15:06:44'),
 (490, 171, 'hành động được tạo', '2023-08-16 15:06:44', '2023-08-16 15:06:44'),
 (491, 171, 'action started via WP Cron', '2023-08-16 15:08:57', '2023-08-16 15:08:57'),
 (492, 171, 'action complete via WP Cron', '2023-08-16 15:08:58', '2023-08-16 15:08:58'),
 (493, 172, 'hành động được tạo', '2023-08-16 15:08:58', '2023-08-16 15:08:58'),
 (494, 172, 'action started via WP Cron', '2023-08-16 15:10:58', '2023-08-16 15:10:58'),
 (495, 172, 'action complete via WP Cron', '2023-08-16 15:10:58', '2023-08-16 15:10:58'),
 (496, 173, 'hành động được tạo', '2023-08-16 15:10:58', '2023-08-16 15:10:58'),
 (497, 173, 'action started via WP Cron', '2023-08-16 15:12:58', '2023-08-16 15:12:58'),
 (498, 173, 'action complete via WP Cron', '2023-08-16 15:12:58', '2023-08-16 15:12:58'),
 (499, 174, 'hành động được tạo', '2023-08-16 15:12:58', '2023-08-16 15:12:58'),
 (500, 174, 'action started via WP Cron', '2023-08-16 15:14:58', '2023-08-16 15:14:58');
INSERT INTO `jLLYHvjea_actionscheduler_logs` VALUES(501, 174, 'action complete via WP Cron', '2023-08-16 15:14:58', '2023-08-16 15:14:58'),
 (502, 175, 'hành động được tạo', '2023-08-16 15:14:58', '2023-08-16 15:14:58'),
 (503, 175, 'action started via WP Cron', '2023-08-16 15:16:58', '2023-08-16 15:16:58'),
 (504, 175, 'action complete via WP Cron', '2023-08-16 15:16:58', '2023-08-16 15:16:58'),
 (505, 176, 'hành động được tạo', '2023-08-16 15:16:58', '2023-08-16 15:16:58'),
 (506, 176, 'action started via WP Cron', '2023-08-16 15:20:34', '2023-08-16 15:20:34'),
 (507, 176, 'action complete via WP Cron', '2023-08-16 15:20:34', '2023-08-16 15:20:34'),
 (508, 177, 'hành động được tạo', '2023-08-16 15:20:34', '2023-08-16 15:20:34'),
 (509, 177, 'action started via WP Cron', '2023-08-16 15:23:19', '2023-08-16 15:23:19'),
 (510, 177, 'action complete via WP Cron', '2023-08-16 15:23:19', '2023-08-16 15:23:19'),
 (511, 178, 'hành động được tạo', '2023-08-16 15:23:19', '2023-08-16 15:23:19'),
 (512, 157, 'action started via WP Cron', '2023-08-16 15:24:47', '2023-08-16 15:24:47'),
 (513, 157, 'action complete via WP Cron', '2023-08-16 15:24:47', '2023-08-16 15:24:47'),
 (514, 179, 'hành động được tạo', '2023-08-16 15:24:47', '2023-08-16 15:24:47'),
 (515, 178, 'action started via WP Cron', '2023-08-16 15:27:32', '2023-08-16 15:27:32'),
 (516, 178, 'action complete via WP Cron', '2023-08-16 15:27:32', '2023-08-16 15:27:32'),
 (517, 180, 'hành động được tạo', '2023-08-16 15:27:32', '2023-08-16 15:27:32'),
 (518, 180, 'action started via WP Cron', '2023-08-16 15:32:51', '2023-08-16 15:32:51'),
 (519, 180, 'action complete via WP Cron', '2023-08-16 15:32:51', '2023-08-16 15:32:51'),
 (520, 181, 'hành động được tạo', '2023-08-16 15:32:51', '2023-08-16 15:32:51'),
 (521, 181, 'action started via WP Cron', '2023-08-16 17:07:58', '2023-08-16 17:07:58'),
 (522, 181, 'action complete via WP Cron', '2023-08-16 17:07:58', '2023-08-16 17:07:58'),
 (523, 182, 'hành động được tạo', '2023-08-16 17:07:58', '2023-08-16 17:07:58'),
 (524, 179, 'action started via WP Cron', '2023-08-16 17:07:58', '2023-08-16 17:07:58'),
 (525, 179, 'action complete via WP Cron', '2023-08-16 17:07:58', '2023-08-16 17:07:58'),
 (526, 183, 'hành động được tạo', '2023-08-16 17:07:58', '2023-08-16 17:07:58'),
 (527, 182, 'action started via WP Cron', '2023-08-16 17:11:05', '2023-08-16 17:11:05'),
 (528, 182, 'action complete via WP Cron', '2023-08-16 17:11:05', '2023-08-16 17:11:05'),
 (529, 184, 'hành động được tạo', '2023-08-16 17:11:05', '2023-08-16 17:11:05'),
 (530, 184, 'action started via WP Cron', '2023-08-16 17:14:00', '2023-08-16 17:14:00'),
 (531, 184, 'action complete via WP Cron', '2023-08-16 17:14:00', '2023-08-16 17:14:00'),
 (532, 185, 'hành động được tạo', '2023-08-16 17:14:00', '2023-08-16 17:14:00'),
 (533, 185, 'action started via Async Request', '2023-08-16 17:16:07', '2023-08-16 17:16:07'),
 (534, 185, 'action complete via Async Request', '2023-08-16 17:16:07', '2023-08-16 17:16:07'),
 (535, 186, 'hành động được tạo', '2023-08-16 17:16:07', '2023-08-16 17:16:07'),
 (536, 186, 'action started via WP Cron', '2023-08-16 17:18:59', '2023-08-16 17:18:59'),
 (537, 186, 'action complete via WP Cron', '2023-08-16 17:18:59', '2023-08-16 17:18:59'),
 (538, 187, 'hành động được tạo', '2023-08-16 17:18:59', '2023-08-16 17:18:59'),
 (539, 187, 'action started via WP Cron', '2023-08-16 17:21:13', '2023-08-16 17:21:13'),
 (540, 187, 'action complete via WP Cron', '2023-08-16 17:21:13', '2023-08-16 17:21:13'),
 (541, 188, 'hành động được tạo', '2023-08-16 17:21:13', '2023-08-16 17:21:13'),
 (542, 188, 'action started via WP Cron', '2023-08-16 17:24:57', '2023-08-16 17:24:57'),
 (543, 188, 'action complete via WP Cron', '2023-08-16 17:24:58', '2023-08-16 17:24:58'),
 (544, 189, 'hành động được tạo', '2023-08-16 17:24:58', '2023-08-16 17:24:58'),
 (545, 189, 'action started via WP Cron', '2023-08-16 18:13:23', '2023-08-16 18:13:23'),
 (546, 189, 'action complete via WP Cron', '2023-08-16 18:13:23', '2023-08-16 18:13:23'),
 (547, 190, 'hành động được tạo', '2023-08-16 18:13:23', '2023-08-16 18:13:23'),
 (548, 183, 'action started via WP Cron', '2023-08-16 18:13:23', '2023-08-16 18:13:23'),
 (549, 183, 'action complete via WP Cron', '2023-08-16 18:13:23', '2023-08-16 18:13:23'),
 (550, 191, 'hành động được tạo', '2023-08-16 18:13:23', '2023-08-16 18:13:23'),
 (551, 190, 'action started via WP Cron', '2023-08-16 18:15:57', '2023-08-16 18:15:57'),
 (552, 190, 'action complete via WP Cron', '2023-08-16 18:15:57', '2023-08-16 18:15:57'),
 (553, 192, 'hành động được tạo', '2023-08-16 18:15:57', '2023-08-16 18:15:57'),
 (554, 192, 'action started via WP Cron', '2023-08-16 18:17:58', '2023-08-16 18:17:58'),
 (555, 192, 'action complete via WP Cron', '2023-08-16 18:17:58', '2023-08-16 18:17:58'),
 (556, 193, 'hành động được tạo', '2023-08-16 18:17:58', '2023-08-16 18:17:58'),
 (557, 193, 'action started via WP Cron', '2023-08-16 18:19:58', '2023-08-16 18:19:58'),
 (558, 193, 'action complete via WP Cron', '2023-08-16 18:19:58', '2023-08-16 18:19:58'),
 (559, 194, 'hành động được tạo', '2023-08-16 18:19:58', '2023-08-16 18:19:58'),
 (560, 194, 'action started via WP Cron', '2023-08-16 18:22:36', '2023-08-16 18:22:36'),
 (561, 194, 'action complete via WP Cron', '2023-08-16 18:22:36', '2023-08-16 18:22:36'),
 (562, 195, 'hành động được tạo', '2023-08-16 18:22:36', '2023-08-16 18:22:36'),
 (563, 195, 'action started via WP Cron', '2023-08-16 18:26:10', '2023-08-16 18:26:10'),
 (564, 195, 'action complete via WP Cron', '2023-08-16 18:26:10', '2023-08-16 18:26:10'),
 (565, 196, 'hành động được tạo', '2023-08-16 18:26:10', '2023-08-16 18:26:10'),
 (566, 196, 'action started via WP Cron', '2023-08-16 18:31:22', '2023-08-16 18:31:22'),
 (567, 196, 'action complete via WP Cron', '2023-08-16 18:31:22', '2023-08-16 18:31:22'),
 (568, 197, 'hành động được tạo', '2023-08-16 18:31:22', '2023-08-16 18:31:22'),
 (569, 197, 'action started via WP Cron', '2023-08-16 18:42:21', '2023-08-16 18:42:21'),
 (570, 197, 'action complete via WP Cron', '2023-08-16 18:42:21', '2023-08-16 18:42:21'),
 (571, 198, 'hành động được tạo', '2023-08-16 18:42:21', '2023-08-16 18:42:21'),
 (572, 198, 'action started via WP Cron', '2023-08-16 19:25:01', '2023-08-16 19:25:01'),
 (573, 198, 'action complete via WP Cron', '2023-08-16 19:25:01', '2023-08-16 19:25:01'),
 (574, 199, 'hành động được tạo', '2023-08-16 19:25:01', '2023-08-16 19:25:01'),
 (575, 191, 'action started via WP Cron', '2023-08-16 19:25:01', '2023-08-16 19:25:01'),
 (576, 191, 'action complete via WP Cron', '2023-08-16 19:25:01', '2023-08-16 19:25:01'),
 (577, 200, 'hành động được tạo', '2023-08-16 19:25:01', '2023-08-16 19:25:01'),
 (578, 199, 'action started via Async Request', '2023-08-16 19:27:06', '2023-08-16 19:27:06'),
 (579, 199, 'action complete via Async Request', '2023-08-16 19:27:06', '2023-08-16 19:27:06'),
 (580, 201, 'hành động được tạo', '2023-08-16 19:27:06', '2023-08-16 19:27:06'),
 (581, 201, 'action started via WP Cron', '2023-08-16 19:33:25', '2023-08-16 19:33:25'),
 (582, 201, 'action complete via WP Cron', '2023-08-16 19:33:25', '2023-08-16 19:33:25'),
 (583, 202, 'hành động được tạo', '2023-08-16 19:33:25', '2023-08-16 19:33:25'),
 (584, 202, 'action started via WP Cron', '2023-08-16 19:39:42', '2023-08-16 19:39:42'),
 (585, 202, 'action complete via WP Cron', '2023-08-16 19:39:42', '2023-08-16 19:39:42'),
 (586, 203, 'hành động được tạo', '2023-08-16 19:39:42', '2023-08-16 19:39:42'),
 (587, 203, 'action started via WP Cron', '2023-08-16 19:54:22', '2023-08-16 19:54:22'),
 (588, 203, 'action complete via WP Cron', '2023-08-16 19:54:22', '2023-08-16 19:54:22'),
 (589, 204, 'hành động được tạo', '2023-08-16 19:54:22', '2023-08-16 19:54:22'),
 (590, 204, 'action started via WP Cron', '2023-08-16 19:57:27', '2023-08-16 19:57:27'),
 (591, 204, 'action complete via WP Cron', '2023-08-16 19:57:27', '2023-08-16 19:57:27'),
 (592, 205, 'hành động được tạo', '2023-08-16 19:57:27', '2023-08-16 19:57:27'),
 (593, 205, 'action started via WP Cron', '2023-08-16 20:03:45', '2023-08-16 20:03:45'),
 (594, 205, 'action complete via WP Cron', '2023-08-16 20:03:45', '2023-08-16 20:03:45'),
 (595, 206, 'hành động được tạo', '2023-08-16 20:03:45', '2023-08-16 20:03:45'),
 (596, 206, 'action started via WP Cron', '2023-08-16 20:10:35', '2023-08-16 20:10:35'),
 (597, 206, 'action complete via WP Cron', '2023-08-16 20:10:35', '2023-08-16 20:10:35'),
 (598, 207, 'hành động được tạo', '2023-08-16 20:10:35', '2023-08-16 20:10:35'),
 (599, 207, 'action started via WP Cron', '2023-08-16 20:12:46', '2023-08-16 20:12:46'),
 (600, 207, 'action complete via WP Cron', '2023-08-16 20:12:46', '2023-08-16 20:12:46'),
 (601, 208, 'hành động được tạo', '2023-08-16 20:12:46', '2023-08-16 20:12:46'),
 (602, 208, 'action started via WP Cron', '2023-08-16 20:15:00', '2023-08-16 20:15:00'),
 (603, 208, 'action complete via WP Cron', '2023-08-16 20:15:00', '2023-08-16 20:15:00'),
 (604, 209, 'hành động được tạo', '2023-08-16 20:15:00', '2023-08-16 20:15:00'),
 (605, 209, 'action started via Async Request', '2023-08-16 20:17:07', '2023-08-16 20:17:07'),
 (606, 209, 'action complete via Async Request', '2023-08-16 20:17:07', '2023-08-16 20:17:07'),
 (607, 210, 'hành động được tạo', '2023-08-16 20:17:07', '2023-08-16 20:17:07'),
 (608, 210, 'action started via Async Request', '2023-08-16 20:19:09', '2023-08-16 20:19:09'),
 (609, 210, 'action complete via Async Request', '2023-08-16 20:19:09', '2023-08-16 20:19:09'),
 (610, 211, 'hành động được tạo', '2023-08-16 20:19:09', '2023-08-16 20:19:09'),
 (611, 211, 'action started via WP Cron', '2023-08-16 20:23:10', '2023-08-16 20:23:10'),
 (612, 211, 'action complete via WP Cron', '2023-08-16 20:23:10', '2023-08-16 20:23:10'),
 (613, 212, 'hành động được tạo', '2023-08-16 20:23:10', '2023-08-16 20:23:10'),
 (614, 200, 'action started via WP Cron', '2023-08-16 20:26:58', '2023-08-16 20:26:58'),
 (615, 200, 'action complete via WP Cron', '2023-08-16 20:26:58', '2023-08-16 20:26:58'),
 (616, 213, 'hành động được tạo', '2023-08-16 20:26:58', '2023-08-16 20:26:58'),
 (617, 212, 'action started via WP Cron', '2023-08-16 20:26:58', '2023-08-16 20:26:58'),
 (618, 212, 'action complete via WP Cron', '2023-08-16 20:26:58', '2023-08-16 20:26:58'),
 (619, 214, 'hành động được tạo', '2023-08-16 20:26:58', '2023-08-16 20:26:58'),
 (620, 214, 'action started via WP Cron', '2023-08-16 20:29:51', '2023-08-16 20:29:51'),
 (621, 214, 'action complete via WP Cron', '2023-08-16 20:29:51', '2023-08-16 20:29:51'),
 (622, 215, 'hành động được tạo', '2023-08-16 20:29:51', '2023-08-16 20:29:51'),
 (623, 215, 'action started via WP Cron', '2023-08-16 20:33:59', '2023-08-16 20:33:59'),
 (624, 215, 'action complete via WP Cron', '2023-08-16 20:33:59', '2023-08-16 20:33:59'),
 (625, 216, 'hành động được tạo', '2023-08-16 20:33:59', '2023-08-16 20:33:59'),
 (626, 216, 'action started via WP Cron', '2023-08-16 21:11:07', '2023-08-16 21:11:07'),
 (627, 216, 'action complete via WP Cron', '2023-08-16 21:11:07', '2023-08-16 21:11:07'),
 (628, 217, 'hành động được tạo', '2023-08-16 21:11:07', '2023-08-16 21:11:07'),
 (629, 217, 'action started via WP Cron', '2023-08-16 21:13:58', '2023-08-16 21:13:58'),
 (630, 217, 'action complete via WP Cron', '2023-08-16 21:13:58', '2023-08-16 21:13:58'),
 (631, 218, 'hành động được tạo', '2023-08-16 21:13:58', '2023-08-16 21:13:58'),
 (632, 218, 'action started via WP Cron', '2023-08-16 21:23:19', '2023-08-16 21:23:19'),
 (633, 218, 'action complete via WP Cron', '2023-08-16 21:23:19', '2023-08-16 21:23:19'),
 (634, 219, 'hành động được tạo', '2023-08-16 21:23:20', '2023-08-16 21:23:20'),
 (635, 219, 'action started via WP Cron', '2023-08-16 21:27:24', '2023-08-16 21:27:24'),
 (636, 219, 'action complete via WP Cron', '2023-08-16 21:27:24', '2023-08-16 21:27:24'),
 (637, 220, 'hành động được tạo', '2023-08-16 21:27:24', '2023-08-16 21:27:24'),
 (638, 213, 'action started via WP Cron', '2023-08-16 21:27:24', '2023-08-16 21:27:24'),
 (639, 213, 'action complete via WP Cron', '2023-08-16 21:27:24', '2023-08-16 21:27:24'),
 (640, 221, 'hành động được tạo', '2023-08-16 21:27:24', '2023-08-16 21:27:24'),
 (641, 220, 'action started via WP Cron', '2023-08-16 21:35:23', '2023-08-16 21:35:23'),
 (642, 220, 'action complete via WP Cron', '2023-08-16 21:35:23', '2023-08-16 21:35:23'),
 (643, 222, 'hành động được tạo', '2023-08-16 21:35:23', '2023-08-16 21:35:23'),
 (644, 222, 'action started via WP Cron', '2023-08-16 21:38:32', '2023-08-16 21:38:32'),
 (645, 222, 'action complete via WP Cron', '2023-08-16 21:38:32', '2023-08-16 21:38:32'),
 (646, 223, 'hành động được tạo', '2023-08-16 21:38:32', '2023-08-16 21:38:32'),
 (647, 223, 'action started via WP Cron', '2023-08-16 22:08:05', '2023-08-16 22:08:05'),
 (648, 223, 'action complete via WP Cron', '2023-08-16 22:08:05', '2023-08-16 22:08:05'),
 (649, 224, 'hành động được tạo', '2023-08-16 22:08:05', '2023-08-16 22:08:05'),
 (650, 224, 'action started via WP Cron', '2023-08-16 22:15:35', '2023-08-16 22:15:35'),
 (651, 224, 'action complete via WP Cron', '2023-08-16 22:15:35', '2023-08-16 22:15:35'),
 (652, 225, 'hành động được tạo', '2023-08-16 22:15:35', '2023-08-16 22:15:35'),
 (653, 225, 'action started via WP Cron', '2023-08-16 22:27:17', '2023-08-16 22:27:17'),
 (654, 225, 'action complete via WP Cron', '2023-08-16 22:27:17', '2023-08-16 22:27:17'),
 (655, 226, 'hành động được tạo', '2023-08-16 22:27:17', '2023-08-16 22:27:17'),
 (656, 221, 'action started via WP Cron', '2023-08-16 23:20:17', '2023-08-16 23:20:17'),
 (657, 221, 'action complete via WP Cron', '2023-08-16 23:20:17', '2023-08-16 23:20:17'),
 (658, 227, 'hành động được tạo', '2023-08-16 23:20:17', '2023-08-16 23:20:17'),
 (659, 226, 'action started via WP Cron', '2023-08-16 23:20:17', '2023-08-16 23:20:17'),
 (660, 226, 'action complete via WP Cron', '2023-08-16 23:20:17', '2023-08-16 23:20:17'),
 (661, 228, 'hành động được tạo', '2023-08-16 23:20:17', '2023-08-16 23:20:17'),
 (662, 228, 'action started via WP Cron', '2023-08-16 23:26:38', '2023-08-16 23:26:38'),
 (663, 228, 'action complete via WP Cron', '2023-08-16 23:26:38', '2023-08-16 23:26:38'),
 (664, 229, 'hành động được tạo', '2023-08-16 23:26:38', '2023-08-16 23:26:38'),
 (665, 229, 'action started via WP Cron', '2023-08-16 23:37:32', '2023-08-16 23:37:32'),
 (666, 229, 'action complete via WP Cron', '2023-08-16 23:37:32', '2023-08-16 23:37:32'),
 (667, 230, 'hành động được tạo', '2023-08-16 23:37:32', '2023-08-16 23:37:32'),
 (668, 230, 'action started via WP Cron', '2023-08-17 00:23:34', '2023-08-17 00:23:34'),
 (669, 230, 'action complete via WP Cron', '2023-08-17 00:23:34', '2023-08-17 00:23:34'),
 (670, 231, 'hành động được tạo', '2023-08-17 00:23:34', '2023-08-17 00:23:34'),
 (671, 227, 'action started via WP Cron', '2023-08-17 00:23:34', '2023-08-17 00:23:34'),
 (672, 227, 'action complete via WP Cron', '2023-08-17 00:23:34', '2023-08-17 00:23:34'),
 (673, 232, 'hành động được tạo', '2023-08-17 00:23:34', '2023-08-17 00:23:34'),
 (674, 231, 'action started via WP Cron', '2023-08-17 00:29:51', '2023-08-17 00:29:51'),
 (675, 231, 'action complete via WP Cron', '2023-08-17 00:29:51', '2023-08-17 00:29:51'),
 (676, 233, 'hành động được tạo', '2023-08-17 00:29:51', '2023-08-17 00:29:51'),
 (677, 233, 'action started via WP Cron', '2023-08-17 00:40:09', '2023-08-17 00:40:09'),
 (678, 233, 'action complete via WP Cron', '2023-08-17 00:40:09', '2023-08-17 00:40:09'),
 (679, 234, 'hành động được tạo', '2023-08-17 00:40:09', '2023-08-17 00:40:09'),
 (680, 234, 'action started via WP Cron', '2023-08-17 00:45:21', '2023-08-17 00:45:21'),
 (681, 234, 'action complete via WP Cron', '2023-08-17 00:45:22', '2023-08-17 00:45:22'),
 (682, 235, 'hành động được tạo', '2023-08-17 00:45:22', '2023-08-17 00:45:22'),
 (683, 235, 'action started via WP Cron', '2023-08-17 00:54:01', '2023-08-17 00:54:01'),
 (684, 235, 'action complete via WP Cron', '2023-08-17 00:54:01', '2023-08-17 00:54:01'),
 (685, 236, 'hành động được tạo', '2023-08-17 00:54:01', '2023-08-17 00:54:01'),
 (686, 236, 'action started via WP Cron', '2023-08-17 00:57:02', '2023-08-17 00:57:02'),
 (687, 236, 'action complete via WP Cron', '2023-08-17 00:57:02', '2023-08-17 00:57:02'),
 (688, 237, 'hành động được tạo', '2023-08-17 00:57:02', '2023-08-17 00:57:02'),
 (689, 237, 'action started via Async Request', '2023-08-17 00:59:07', '2023-08-17 00:59:07'),
 (690, 237, 'action complete via Async Request', '2023-08-17 00:59:07', '2023-08-17 00:59:07'),
 (691, 238, 'hành động được tạo', '2023-08-17 00:59:07', '2023-08-17 00:59:07'),
 (692, 238, 'action started via WP Cron', '2023-08-17 01:01:57', '2023-08-17 01:01:57'),
 (693, 238, 'action complete via WP Cron', '2023-08-17 01:01:57', '2023-08-17 01:01:57'),
 (694, 239, 'hành động được tạo', '2023-08-17 01:01:57', '2023-08-17 01:01:57'),
 (695, 239, 'action started via WP Cron', '2023-08-17 01:04:09', '2023-08-17 01:04:09'),
 (696, 239, 'action complete via WP Cron', '2023-08-17 01:04:09', '2023-08-17 01:04:09'),
 (697, 240, 'hành động được tạo', '2023-08-17 01:04:09', '2023-08-17 01:04:09'),
 (698, 240, 'action started via Async Request', '2023-08-17 01:07:21', '2023-08-17 01:07:21'),
 (699, 240, 'action complete via Async Request', '2023-08-17 01:07:21', '2023-08-17 01:07:21'),
 (700, 241, 'hành động được tạo', '2023-08-17 01:07:21', '2023-08-17 01:07:21'),
 (701, 241, 'action started via Async Request', '2023-08-17 01:09:56', '2023-08-17 01:09:56'),
 (702, 241, 'action complete via Async Request', '2023-08-17 01:09:56', '2023-08-17 01:09:56'),
 (703, 242, 'hành động được tạo', '2023-08-17 01:09:56', '2023-08-17 01:09:56'),
 (704, 242, 'action started via WP Cron', '2023-08-17 01:12:17', '2023-08-17 01:12:17'),
 (705, 242, 'action complete via WP Cron', '2023-08-17 01:12:17', '2023-08-17 01:12:17'),
 (706, 243, 'hành động được tạo', '2023-08-17 01:12:17', '2023-08-17 01:12:17'),
 (707, 243, 'action started via Async Request', '2023-08-17 01:14:43', '2023-08-17 01:14:43'),
 (708, 243, 'action complete via Async Request', '2023-08-17 01:14:43', '2023-08-17 01:14:43'),
 (709, 244, 'hành động được tạo', '2023-08-17 01:14:43', '2023-08-17 01:14:43'),
 (710, 244, 'action started via Async Request', '2023-08-17 01:16:54', '2023-08-17 01:16:54'),
 (711, 244, 'action complete via Async Request', '2023-08-17 01:16:54', '2023-08-17 01:16:54'),
 (712, 245, 'hành động được tạo', '2023-08-17 01:16:54', '2023-08-17 01:16:54'),
 (713, 245, 'action started via Async Request', '2023-08-17 01:19:14', '2023-08-17 01:19:14'),
 (714, 245, 'action complete via Async Request', '2023-08-17 01:19:14', '2023-08-17 01:19:14'),
 (715, 246, 'hành động được tạo', '2023-08-17 01:19:14', '2023-08-17 01:19:14'),
 (716, 246, 'action started via Async Request', '2023-08-17 01:21:24', '2023-08-17 01:21:24'),
 (717, 246, 'action complete via Async Request', '2023-08-17 01:21:24', '2023-08-17 01:21:24'),
 (718, 247, 'hành động được tạo', '2023-08-17 01:21:24', '2023-08-17 01:21:24'),
 (719, 247, 'action started via Async Request', '2023-08-17 01:23:43', '2023-08-17 01:23:43'),
 (720, 247, 'action complete via Async Request', '2023-08-17 01:23:43', '2023-08-17 01:23:43'),
 (721, 248, 'hành động được tạo', '2023-08-17 01:23:43', '2023-08-17 01:23:43'),
 (722, 232, 'action started via Async Request', '2023-08-17 01:23:43', '2023-08-17 01:23:43'),
 (723, 232, 'action complete via Async Request', '2023-08-17 01:23:43', '2023-08-17 01:23:43'),
 (724, 249, 'hành động được tạo', '2023-08-17 01:23:43', '2023-08-17 01:23:43'),
 (725, 248, 'action started via WP Cron', '2023-08-17 01:26:21', '2023-08-17 01:26:21'),
 (726, 248, 'action complete via WP Cron', '2023-08-17 01:26:21', '2023-08-17 01:26:21'),
 (727, 250, 'hành động được tạo', '2023-08-17 01:26:21', '2023-08-17 01:26:21'),
 (728, 250, 'action started via Async Request', '2023-08-17 01:28:22', '2023-08-17 01:28:22'),
 (729, 250, 'action complete via Async Request', '2023-08-17 01:28:22', '2023-08-17 01:28:22'),
 (730, 251, 'hành động được tạo', '2023-08-17 01:28:22', '2023-08-17 01:28:22'),
 (731, 251, 'action started via Async Request', '2023-08-17 01:31:00', '2023-08-17 01:31:00'),
 (732, 251, 'action complete via Async Request', '2023-08-17 01:31:00', '2023-08-17 01:31:00'),
 (739, 249, 'action started via WP Cron', '2023-08-17 02:24:10', '2023-08-17 02:24:10'),
 (734, 253, 'hành động được tạo', '2023-08-17 01:32:24', '2023-08-17 01:32:24'),
 (738, 253, 'action complete via WP Cron', '2023-08-17 01:33:58', '2023-08-17 01:33:58'),
 (737, 253, 'action started via WP Cron', '2023-08-17 01:33:58', '2023-08-17 01:33:58'),
 (740, 249, 'action complete via WP Cron', '2023-08-17 02:24:10', '2023-08-17 02:24:10'),
 (741, 254, 'hành động được tạo', '2023-08-17 02:24:10', '2023-08-17 02:24:10'),
 (742, 254, 'action started via Async Request', '2023-08-17 03:24:45', '2023-08-17 03:24:45'),
 (743, 254, 'action complete via Async Request', '2023-08-17 03:24:45', '2023-08-17 03:24:45'),
 (744, 255, 'hành động được tạo', '2023-08-17 03:24:45', '2023-08-17 03:24:45'),
 (745, 255, 'action started via WP Cron', '2023-08-17 04:24:58', '2023-08-17 04:24:58'),
 (746, 255, 'action complete via WP Cron', '2023-08-17 04:24:58', '2023-08-17 04:24:58'),
 (747, 256, 'hành động được tạo', '2023-08-17 04:24:58', '2023-08-17 04:24:58'),
 (748, 256, 'action started via WP Cron', '2023-08-17 05:47:52', '2023-08-17 05:47:52'),
 (749, 256, 'action complete via WP Cron', '2023-08-17 05:47:52', '2023-08-17 05:47:52'),
 (750, 257, 'hành động được tạo', '2023-08-17 05:47:52', '2023-08-17 05:47:52'),
 (751, 257, 'action started via WP Cron', '2023-08-17 07:01:05', '2023-08-17 07:01:05'),
 (752, 257, 'action complete via WP Cron', '2023-08-17 07:01:05', '2023-08-17 07:01:05'),
 (753, 258, 'hành động được tạo', '2023-08-17 07:01:05', '2023-08-17 07:01:05'),
 (754, 259, 'hành động được tạo', '2023-08-17 07:09:02', '2023-08-17 07:09:02'),
 (755, 259, 'action started via WP Cron', '2023-08-17 07:09:04', '2023-08-17 07:09:04'),
 (756, 259, 'action complete via WP Cron', '2023-08-17 07:09:04', '2023-08-17 07:09:04'),
 (757, 260, 'hành động được tạo', '2023-08-17 07:11:17', '2023-08-17 07:11:17'),
 (758, 260, 'action started via Async Request', '2023-08-17 07:11:19', '2023-08-17 07:11:19'),
 (759, 260, 'action complete via Async Request', '2023-08-17 07:11:19', '2023-08-17 07:11:19'),
 (760, 258, 'action started via Async Request', '2023-08-17 08:01:17', '2023-08-17 08:01:17'),
 (761, 258, 'action complete via Async Request', '2023-08-17 08:01:17', '2023-08-17 08:01:17'),
 (762, 261, 'hành động được tạo', '2023-08-17 08:01:17', '2023-08-17 08:01:17'),
 (763, 262, 'hành động được tạo', '2023-08-17 08:58:58', '2023-08-17 08:58:58'),
 (764, 262, 'action started via WP Cron', '2023-08-17 08:59:00', '2023-08-17 08:59:00'),
 (765, 262, 'action complete via WP Cron', '2023-08-17 08:59:00', '2023-08-17 08:59:00'),
 (766, 261, 'action started via WP Cron', '2023-08-17 09:01:40', '2023-08-17 09:01:40'),
 (767, 261, 'action complete via WP Cron', '2023-08-17 09:01:40', '2023-08-17 09:01:40'),
 (768, 263, 'hành động được tạo', '2023-08-17 09:01:40', '2023-08-17 09:01:40'),
 (769, 83, 'action started via WP Cron', '2023-08-17 09:14:00', '2023-08-17 09:14:00'),
 (770, 83, 'action complete via WP Cron', '2023-08-17 09:14:00', '2023-08-17 09:14:00'),
 (771, 264, 'hành động được tạo', '2023-08-17 09:14:00', '2023-08-17 09:14:00');

/* INSERT TABLE DATA: jLLYHvjea_commentmeta */
INSERT INTO `jLLYHvjea_commentmeta` VALUES(1, 2, 'rating', '5'),
 (2, 2, 'verified', '0');

/* INSERT TABLE DATA: jLLYHvjea_comments */
INSERT INTO `jLLYHvjea_comments` VALUES(1, 1, 'A WordPress Commenter', 'wapuu@wordpress.example', 'https://wordpress.org/', '', '2023-08-15 14:51:51', '2023-08-15 14:51:51', 'Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.', 0, 'post-trashed', '', 'comment', 0, 0),
 (2, 368, 'Sỹ Anh', 's27101995@gmail.com', '', '14.248.42.17', '2023-08-17 03:41:10', '2023-08-17 03:41:10', 'Sản phẩm tốt, giá rẻ, nhân viên tư vấn nhiệt tình', 0, '0', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36', 'review', 0, 0);

/* INSERT TABLE DATA: jLLYHvjea_duplicator_pro_entities */
INSERT INTO `jLLYHvjea_duplicator_pro_entities` VALUES(1, 'DUP_PRO_Global_Entity', '{\"uninstall_settings\":false,\"uninstall_packages\":false,\"uninstall_tables\":true,\"wpfront_integrate\":false,\"package_ui_created\":1,\"package_mysqldump\":false,\"package_mysqldump_path\":\"\",\"package_phpdump_mode\":0,\"package_phpdump_qrylimit\":500,\"package_php_chunking\":null,\"archive_build_mode\":1,\"archive_compression\":true,\"ziparchive_validation\":false,\"ziparchive_mode\":0,\"ziparchive_chunk_size_in_mb\":6,\"archive_build_mode_schedule\":-1,\"archive_compression_schedule\":true,\"server_load_reduction\":0,\"max_package_runtime_in_min\":90,\"php_max_worker_time_in_sec\":18,\"lock_mode\":0,\"json_mode\":0,\"ajax_protocol\":\"https\",\"custom_ajax_url\":\"http:\\/\\/skvshop.com\\/wp-admin\\/admin-ajax.php\",\"clientside_kickoff\":false,\"basic_auth_enabled\":false,\"basic_auth_user\":\"\",\"basic_auth_password\":\"\",\"installer_base_name\":\"installer.php\",\"chunk_size\":2048,\"skip_archive_scan\":false,\"send_email_on_build_mode\":1,\"notification_email_address\":\"\",\"storage_htaccess_off\":false,\"max_storage_retries\":10,\"max_default_store_files\":20,\"purge_default_package_record\":false,\"dropbox_upload_chunksize_in_kb\":2000,\"dropbox_transfer_mode\":1,\"gdrive_upload_chunksize_in_kb\":1000,\"s3_upload_part_size_in_kb\":6000,\"manual_mode_storage_ids\":[\"-2\"],\"license_status\":0,\"license_expiration_time\":1692171457,\"license_no_activations_left\":false,\"license_key_visible\":true,\"lkp\":\"\",\"license_limit\":-1,\"last_edd_api_response\":null,\"last_edd_api_timestamp\":0,\"last_system_check_timestamp\":1692257910,\"initial_activation_timestamp\":1692171469,\"ssl_useservercerts\":true,\"ssl_disableverify\":true,\"ipv4_only\":false,\"debug_on\":false,\"trace_profiler_on\":false,\"profile_idea\":false,\"profile_beta\":false,\"dupHidePackagesGiftFeatures\":true,\"type\":\"DUP_PRO_Global_Entity\",\"notices\":{\"dupArchiveSwitch\":true}}'),
 (2, 'DUP_PRO_Secure_Global_Entity', '{\"basic_auth_password\":\"\",\"lkp\":\"\",\"type\":\"DUP_PRO_Secure_Global_Entity\"}'),
 (3, 'DUP_PRO_System_Global_Entity', '{\"recommended_fixes\":[],\"schedule_failed\":false,\"package_check_ts\":1692264941,\"type\":\"DUP_PRO_System_Global_Entity\"}'),
 (4, 'DUP_PRO_Package_Template_Entity', '{\"name\":\"Default\",\"notes\":\"The default template.\",\"filter_sites\":[],\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":[],\"installer_opts_secure_on\":null,\"installer_opts_secure_pass\":null,\"installer_opts_skip_scan\":null,\"installer_opts_db_host\":null,\"installer_opts_db_name\":null,\"installer_opts_db_user\":null,\"installer_opts_cpnl_enable\":false,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":true,\"is_manual\":false,\"type\":\"DUP_PRO_Package_Template_Entity\"}'),
 (5, 'DUP_PRO_Package_Template_Entity', '{\"name\":\"[Manual Mode]\",\"notes\":\"\",\"filter_sites\":\"\",\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":\"\",\"installer_opts_secure_on\":0,\"installer_opts_secure_pass\":\"\",\"installer_opts_skip_scan\":0,\"installer_opts_db_host\":\"\",\"installer_opts_db_name\":\"\",\"installer_opts_db_user\":\"\",\"installer_opts_cpnl_enable\":0,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":false,\"is_manual\":true,\"type\":\"DUP_PRO_Package_Template_Entity\"}');

/* INSERT TABLE DATA: jLLYHvjea_duplicator_pro_packages */
INSERT INTO `jLLYHvjea_duplicator_pro_packages` VALUES(4, '20230817_skvvisuckhoeviet', 'ab485c9571cfbe241813_20230817093520', 20, '2023-08-17 09:35:29', 'unknown', '{\"Created\":\"2023-08-17 09:35:20\",\"Version\":\"3.8.2\",\"VersionWP\":\"6.3\",\"VersionDB\":\"10.6.14\",\"VersionPHP\":\"7.4.33\",\"VersionOS\":\"Linux\",\"ID\":\"4\",\"Name\":\"20230817_skvvisuckhoeviet\",\"Hash\":\"ab485c9571cfbe241813_20230817093520\",\"NameHash\":\"20230817_skvvisuckhoeviet_ab485c9571cfbe241813_20230817093520\",\"Type\":0,\"Notes\":\"\",\"StorePath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/skvshop.com\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20230817_skvvisuckhoeviet_ab485c9571cfbe241813_20230817093520_scan.json\",\"timer_start\":1692264942.393443,\"Runtime\":null,\"ExeSize\":null,\"ZipSize\":0,\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/ai1wm-backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/backups-dup-pro\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/backupwordpress\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/cache\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/content\\/cache\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/contents\\/cache\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/managewp\\/backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/old-cache\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/updraft\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/wfcache\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/wishlist-backup\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/icpharma\\/skvshop.com\\/.htaccess\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20230817_skvvisuckhoeviet_ab485c9571cfbe241813_20230817093520_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/icpharma\\/skvshop.com\",\"Size\":254365869,\"Dirs\":null,\"DirCount\":3115,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":19880,\"file_count\":-1,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/icpharma\\/skvshop.com\\/wp-snapshots\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/ai1wm-backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/backupwordpress\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/content\\/cache\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/contents\\/cache\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/managewp\\/backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/old-cache\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/updraft\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/wishlist-backup\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/wfcache\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/cache\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":5729689,\"bytes\":\"5.46MB\",\"name\":\"bokeh-product-background.jpg\",\"dir\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/2023\\/08\",\"path\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/uploads\\/2023\\/08\\/bokeh-product-background.jpg\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/icpharma\\/skvshop.com\\/.htaccess\",\"\\/home\\/icpharma\\/skvshop.com\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":{\"tree\":{\"id\":\"0\",\"parentId\":\"\",\"name\":\"skvshop.com\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\",\"isDir\":true,\"childs\":{\".htaccess\":{\"id\":\"0_0\",\"parentId\":\"0\",\"name\":\".htaccess\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/.htaccess\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".htaccess.bk\":{\"id\":\"0_1\",\"parentId\":\"0\",\"name\":\".htaccess.bk\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/.htaccess.bk\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".user.ini\":{\"id\":\"0_2\",\"parentId\":\"0\",\"name\":\".user.ini\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/.user.ini\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".well-known\":{\"id\":\"0_3\",\"parentId\":\"0\",\"name\":\".well-known\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/.well-known\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\".wp-cli\":{\"id\":\"0_4\",\"parentId\":\"0\",\"name\":\".wp-cli\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/.wp-cli\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"cgi-bin\":{\"id\":\"0_5\",\"parentId\":\"0\",\"name\":\"cgi-bin\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/cgi-bin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":false},\"error_log\":{\"id\":\"0_6\",\"parentId\":\"0\",\"name\":\"error_log\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/error_log\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"index.php\":{\"id\":\"0_7\",\"parentId\":\"0\",\"name\":\"index.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/index.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"license.txt\":{\"id\":\"0_8\",\"parentId\":\"0\",\"name\":\"license.txt\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/license.txt\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"php.ini\":{\"id\":\"0_9\",\"parentId\":\"0\",\"name\":\"php.ini\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/php.ini\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"readme.html\":{\"id\":\"0_10\",\"parentId\":\"0\",\"name\":\"readme.html\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/readme.html\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-activate.php\":{\"id\":\"0_11\",\"parentId\":\"0\",\"name\":\"wp-activate.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-activate.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-admin\":{\"id\":\"0_12\",\"parentId\":\"0\",\"name\":\"wp-admin\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-admin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-blog-header.php\":{\"id\":\"0_13\",\"parentId\":\"0\",\"name\":\"wp-blog-header.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-blog-header.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-comments-post.php\":{\"id\":\"0_14\",\"parentId\":\"0\",\"name\":\"wp-comments-post.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-comments-post.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-config-sample.php\":{\"id\":\"0_15\",\"parentId\":\"0\",\"name\":\"wp-config-sample.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-config-sample.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-config.php\":{\"id\":\"0_16\",\"parentId\":\"0\",\"name\":\"wp-config.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-config.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-content\":{\"id\":\"0_17\",\"parentId\":\"0\",\"name\":\"wp-content\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-cron.php\":{\"id\":\"0_18\",\"parentId\":\"0\",\"name\":\"wp-cron.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-cron.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-includes\":{\"id\":\"0_19\",\"parentId\":\"0\",\"name\":\"wp-includes\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-includes\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-links-opml.php\":{\"id\":\"0_20\",\"parentId\":\"0\",\"name\":\"wp-links-opml.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-links-opml.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-load.php\":{\"id\":\"0_21\",\"parentId\":\"0\",\"name\":\"wp-load.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-load.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-login.php\":{\"id\":\"0_22\",\"parentId\":\"0\",\"name\":\"wp-login.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-login.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-mail.php\":{\"id\":\"0_23\",\"parentId\":\"0\",\"name\":\"wp-mail.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-mail.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-settings.php\":{\"id\":\"0_24\",\"parentId\":\"0\",\"name\":\"wp-settings.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-settings.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-signup.php\":{\"id\":\"0_25\",\"parentId\":\"0\",\"name\":\"wp-signup.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-signup.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-trackback.php\":{\"id\":\"0_26\",\"parentId\":\"0\",\"name\":\"wp-trackback.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-trackback.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"xmlrpc.php\":{\"id\":\"0_27\",\"parentId\":\"0\",\"name\":\"xmlrpc.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/xmlrpc.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null}},\"data\":[],\"haveChildren\":true},\"rootPath\":\"\\/home\\/icpharma\\/skvshop.com\"},\"TreeWarning\":{\"tree\":{\"id\":\"0\",\"parentId\":\"\",\"name\":\"skvshop.com\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\",\"isDir\":true,\"childs\":{\".htaccess\":{\"id\":\"0_0\",\"parentId\":\"0\",\"name\":\".htaccess\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/.htaccess\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".htaccess.bk\":{\"id\":\"0_1\",\"parentId\":\"0\",\"name\":\".htaccess.bk\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/.htaccess.bk\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".user.ini\":{\"id\":\"0_2\",\"parentId\":\"0\",\"name\":\".user.ini\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/.user.ini\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".well-known\":{\"id\":\"0_3\",\"parentId\":\"0\",\"name\":\".well-known\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/.well-known\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\".wp-cli\":{\"id\":\"0_4\",\"parentId\":\"0\",\"name\":\".wp-cli\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/.wp-cli\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"cgi-bin\":{\"id\":\"0_5\",\"parentId\":\"0\",\"name\":\"cgi-bin\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/cgi-bin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":false},\"error_log\":{\"id\":\"0_6\",\"parentId\":\"0\",\"name\":\"error_log\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/error_log\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"index.php\":{\"id\":\"0_7\",\"parentId\":\"0\",\"name\":\"index.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/index.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"license.txt\":{\"id\":\"0_8\",\"parentId\":\"0\",\"name\":\"license.txt\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/license.txt\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"php.ini\":{\"id\":\"0_9\",\"parentId\":\"0\",\"name\":\"php.ini\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/php.ini\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"readme.html\":{\"id\":\"0_10\",\"parentId\":\"0\",\"name\":\"readme.html\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/readme.html\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-activate.php\":{\"id\":\"0_11\",\"parentId\":\"0\",\"name\":\"wp-activate.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-activate.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-admin\":{\"id\":\"0_12\",\"parentId\":\"0\",\"name\":\"wp-admin\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-admin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-blog-header.php\":{\"id\":\"0_13\",\"parentId\":\"0\",\"name\":\"wp-blog-header.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-blog-header.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-comments-post.php\":{\"id\":\"0_14\",\"parentId\":\"0\",\"name\":\"wp-comments-post.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-comments-post.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-config-sample.php\":{\"id\":\"0_15\",\"parentId\":\"0\",\"name\":\"wp-config-sample.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-config-sample.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-config.php\":{\"id\":\"0_16\",\"parentId\":\"0\",\"name\":\"wp-config.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-config.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-content\":{\"id\":\"0_17\",\"parentId\":\"0\",\"name\":\"wp-content\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-cron.php\":{\"id\":\"0_18\",\"parentId\":\"0\",\"name\":\"wp-cron.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-cron.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-includes\":{\"id\":\"0_19\",\"parentId\":\"0\",\"name\":\"wp-includes\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-includes\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-links-opml.php\":{\"id\":\"0_20\",\"parentId\":\"0\",\"name\":\"wp-links-opml.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-links-opml.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-load.php\":{\"id\":\"0_21\",\"parentId\":\"0\",\"name\":\"wp-load.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-load.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-login.php\":{\"id\":\"0_22\",\"parentId\":\"0\",\"name\":\"wp-login.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-login.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-mail.php\":{\"id\":\"0_23\",\"parentId\":\"0\",\"name\":\"wp-mail.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-mail.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-settings.php\":{\"id\":\"0_24\",\"parentId\":\"0\",\"name\":\"wp-settings.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-settings.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-signup.php\":{\"id\":\"0_25\",\"parentId\":\"0\",\"name\":\"wp-signup.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-signup.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-trackback.php\":{\"id\":\"0_26\",\"parentId\":\"0\",\"name\":\"wp-trackback.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-trackback.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"xmlrpc.php\":{\"id\":\"0_27\",\"parentId\":\"0\",\"name\":\"xmlrpc.php\",\"fullPath\":\"\\/home\\/icpharma\\/skvshop.com\\/xmlrpc.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null}},\"data\":[],\"haveChildren\":true},\"rootPath\":\"\\/home\\/icpharma\\/skvshop.com\"}},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false},\"Multisite\":{\"FilterSites\":\"\"},\"Installer\":{\"File\":\"20230817_skvvisuckhoeviet_ab485c9571cfbe241813_20230817093520_installer.php\",\"Size\":0,\"OptsSecureOn\":0,\"OptsSecurePass\":\"\",\"OptsSkipScan\":0,\"OptsDBHost\":\"\",\"OptsDBName\":\"\",\"OptsDBUser\":\"\",\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":0,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"utf8mb4_unicode_ci\",\"latin1_swedish_ci\",\"utf8mb3_general_ci\"],\"isTablesUpperCase\":1,\"isNameUpperCase\":0,\"name\":\"icpharma_db_skvshop\",\"tablesBaseCount\":120,\"tablesFinalCount\":120,\"tablesRowCount\":8045,\"tablesSizeOnDisk\":6497369,\"varLowerCaseTables\":\"0\",\"version\":\"10.6.14\",\"versionComment\":\"MariaDB Server\",\"tableWiseRowCounts\":{\"jLLYHvjea_actionscheduler_actions\":\"258\",\"jLLYHvjea_actionscheduler_claims\":\"0\",\"jLLYHvjea_actionscheduler_groups\":\"7\",\"jLLYHvjea_actionscheduler_logs\":\"768\",\"jLLYHvjea_commentmeta\":\"2\",\"jLLYHvjea_comments\":\"2\",\"jLLYHvjea_duplicator_pro_entities\":\"5\",\"jLLYHvjea_duplicator_pro_packages\":\"1\"}},\"Type\":\"MySQL\",\"Size\":null,\"File\":\"20230817_skvvisuckhoeviet_ab485c9571cfbe241813_20230817093520_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":\"\",\"Comments\":\"MariaDB Server\",\"dbStorePathPublic\":\"\\/home\\/icpharma\\/skvshop.com\\/wp-content\\/backups-dup-pro\\/tmp\\/20230817_skvvisuckhoeviet_ab485c9571cfbe241813_20230817093520_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,136724,139824,149292,236472,246784,255576,264520],\"intFieldsStruct\":{\"jLLYHvjea_actionscheduler_actions\":{\"action_id\":\"NULL\",\"priority\":\"10\",\"group_id\":\"0\",\"attempts\":\"0\",\"claim_id\":\"0\"},\"jLLYHvjea_actionscheduler_claims\":{\"claim_id\":\"NULL\"},\"jLLYHvjea_actionscheduler_groups\":{\"group_id\":\"NULL\"},\"jLLYHvjea_actionscheduler_logs\":{\"log_id\":\"NULL\",\"action_id\":\"NULL\"},\"jLLYHvjea_commentmeta\":{\"meta_id\":\"NULL\",\"comment_id\":\"0\"},\"jLLYHvjea_comments\":{\"comment_ID\":\"NULL\",\"comment_post_ID\":\"0\",\"comment_karma\":\"0\",\"comment_parent\":\"0\",\"user_id\":\"0\"},\"jLLYHvjea_duplicator_pro_entities\":{\"id\":\"NULL\"}}},\"Status\":20,\"schedule_id\":-1,\"build_progress\":{\"thread_start_time\":1692264945,\"initialized\":true,\"installer_built\":false,\"archive_started\":false,\"archive_has_database\":false,\"archive_built\":false,\"database_script_built\":false,\"failed\":false,\"next_archive_file_index\":0,\"next_archive_dir_index\":0,\"retries\":0,\"current_build_mode\":1,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":0,\"tableOffset\":0,\"totalRowOffset\":0,\"chunkIndex\":null,\"validationStage1\":false,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":false,\"tablesToProcess\":[\"jLLYHvjea_actionscheduler_actions\",\"jLLYHvjea_actionscheduler_claims\",\"jLLYHvjea_actionscheduler_groups\",\"jLLYHvjea_actionscheduler_logs\",\"jLLYHvjea_commentmeta\",\"jLLYHvjea_comments\",\"jLLYHvjea_duplicator_pro_entities\",\"jLLYHvjea_duplicator_pro_packages\",\"jLLYHvjea_learndash_pro_quiz_category\",\"jLLYHvjea_learndash_pro_quiz_form\",\"jLLYHvjea_learndash_pro_quiz_lock\",\"jLLYHvjea_learndash_pro_quiz_master\",\"jLLYHvjea_learndash_pro_quiz_prerequisite\",\"jLLYHvjea_learndash_pro_quiz_question\",\"jLLYHvjea_learndash_pro_quiz_statistic\",\"jLLYHvjea_learndash_pro_quiz_statistic_ref\",\"jLLYHvjea_learndash_pro_quiz_template\",\"jLLYHvjea_learndash_pro_quiz_toplist\",\"jLLYHvjea_learndash_user_activity\",\"jLLYHvjea_learndash_user_activity_meta\",\"jLLYHvjea_links\",\"jLLYHvjea_litespeed_url\",\"jLLYHvjea_litespeed_url_file\",\"jLLYHvjea_mailpoet_automation_run_logs\",\"jLLYHvjea_mailpoet_automation_run_subjects\",\"jLLYHvjea_mailpoet_automation_runs\",\"jLLYHvjea_mailpoet_automation_triggers\",\"jLLYHvjea_mailpoet_automation_versions\",\"jLLYHvjea_mailpoet_automations\",\"jLLYHvjea_mailpoet_custom_fields\",\"jLLYHvjea_mailpoet_dynamic_segment_filters\",\"jLLYHvjea_mailpoet_feature_flags\",\"jLLYHvjea_mailpoet_forms\",\"jLLYHvjea_mailpoet_log\",\"jLLYHvjea_mailpoet_migrations\",\"jLLYHvjea_mailpoet_newsletter_links\",\"jLLYHvjea_mailpoet_newsletter_option\",\"jLLYHvjea_mailpoet_newsletter_option_fields\",\"jLLYHvjea_mailpoet_newsletter_posts\",\"jLLYHvjea_mailpoet_newsletter_segment\",\"jLLYHvjea_mailpoet_newsletter_templates\",\"jLLYHvjea_mailpoet_newsletters\",\"jLLYHvjea_mailpoet_scheduled_task_subscribers\",\"jLLYHvjea_mailpoet_scheduled_tasks\",\"jLLYHvjea_mailpoet_segments\",\"jLLYHvjea_mailpoet_sending_queues\",\"jLLYHvjea_mailpoet_settings\",\"jLLYHvjea_mailpoet_statistics_bounces\",\"jLLYHvjea_mailpoet_statistics_clicks\",\"jLLYHvjea_mailpoet_statistics_forms\",\"jLLYHvjea_mailpoet_statistics_newsletters\",\"jLLYHvjea_mailpoet_statistics_opens\",\"jLLYHvjea_mailpoet_statistics_unsubscribes\",\"jLLYHvjea_mailpoet_statistics_woocommerce_purchases\",\"jLLYHvjea_mailpoet_stats_notifications\",\"jLLYHvjea_mailpoet_subscriber_custom_field\",\"jLLYHvjea_mailpoet_subscriber_ips\",\"jLLYHvjea_mailpoet_subscriber_segment\",\"jLLYHvjea_mailpoet_subscriber_tag\",\"jLLYHvjea_mailpoet_subscribers\",\"jLLYHvjea_mailpoet_tags\",\"jLLYHvjea_mailpoet_user_agents\",\"jLLYHvjea_mailpoet_user_flags\",\"jLLYHvjea_options\",\"jLLYHvjea_postmeta\",\"jLLYHvjea_posts\",\"jLLYHvjea_social_users\",\"jLLYHvjea_solid_affiliate_affiliate_customer_links\",\"jLLYHvjea_solid_affiliate_affiliate_groups\",\"jLLYHvjea_solid_affiliate_affiliate_meta\",\"jLLYHvjea_solid_affiliate_affiliate_product_rates\",\"jLLYHvjea_solid_affiliate_affiliates\",\"jLLYHvjea_solid_affiliate_creatives\",\"jLLYHvjea_solid_affiliate_payouts\",\"jLLYHvjea_solid_affiliate_referrals\",\"jLLYHvjea_solid_affiliate_store_credit_transactions\",\"jLLYHvjea_solid_affiliate_visits\",\"jLLYHvjea_solid_affiliates_bulk_payouts\",\"jLLYHvjea_term_relationships\",\"jLLYHvjea_term_taxonomy\",\"jLLYHvjea_termmeta\",\"jLLYHvjea_terms\",\"jLLYHvjea_usermeta\",\"jLLYHvjea_users\",\"jLLYHvjea_wc_admin_note_actions\",\"jLLYHvjea_wc_admin_notes\",\"jLLYHvjea_wc_category_lookup\",\"jLLYHvjea_wc_customer_lookup\",\"jLLYHvjea_wc_download_log\",\"jLLYHvjea_wc_order_addresses\",\"jLLYHvjea_wc_order_coupon_lookup\",\"jLLYHvjea_wc_order_operational_data\",\"jLLYHvjea_wc_order_product_lookup\",\"jLLYHvjea_wc_order_stats\",\"jLLYHvjea_wc_order_tax_lookup\",\"jLLYHvjea_wc_product_attributes_lookup\",\"jLLYHvjea_wc_product_download_directories\",\"jLLYHvjea_wc_product_meta_lookup\",\"jLLYHvjea_wc_rate_limits\",\"jLLYHvjea_wc_reserved_stock\",\"jLLYHvjea_wc_tax_rate_classes\",\"jLLYHvjea_wc_webhooks\",\"jLLYHvjea_woocommerce_api_keys\",\"jLLYHvjea_woocommerce_attribute_taxonomies\",\"jLLYHvjea_woocommerce_downloadable_product_permissions\",\"jLLYHvjea_woocommerce_log\",\"jLLYHvjea_woocommerce_order_itemmeta\",\"jLLYHvjea_woocommerce_order_items\",\"jLLYHvjea_woocommerce_payment_tokenmeta\",\"jLLYHvjea_woocommerce_payment_tokens\",\"jLLYHvjea_woocommerce_sessions\",\"jLLYHvjea_woocommerce_shipping_zone_locations\",\"jLLYHvjea_woocommerce_shipping_zone_methods\",\"jLLYHvjea_woocommerce_shipping_zones\",\"jLLYHvjea_woocommerce_tax_rate_locations\",\"jLLYHvjea_woocommerce_tax_rates\",\"jLLYHvjea_wpcc_urls\",\"jLLYHvjea_wpsmtp_logs\",\"jLLYHvjea_yith_wcwl\",\"jLLYHvjea_yith_wcwl_lists\"],\"startTime\":1692264942.550785,\"fileOffset\":73077,\"wasInterrupted\":true,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":6541661,\"tablesSchemaSizes\":{\"jLLYHvjea_woocommerce_payment_tokens\":1024,\"jLLYHvjea_learndash_user_activity\":10456,\"jLLYHvjea_wc_download_log\":1024,\"jLLYHvjea_wc_order_product_lookup\":1024,\"jLLYHvjea_mailpoet_user_agents\":1024,\"jLLYHvjea_litespeed_url_file\":1024,\"jLLYHvjea_term_taxonomy\":13240,\"jLLYHvjea_wc_order_operational_data\":2048,\"jLLYHvjea_mailpoet_automation_triggers\":4096,\"jLLYHvjea_wc_category_lookup\":5320,\"jLLYHvjea_solid_affiliate_affiliate_customer_links\":1024,\"jLLYHvjea_actionscheduler_groups\":9468,\"jLLYHvjea_mailpoet_scheduled_tasks\":7392,\"jLLYHvjea_woocommerce_downloadable_product_permissions\":1024,\"jLLYHvjea_litespeed_url\":4096,\"jLLYHvjea_mailpoet_sending_queues\":1024,\"jLLYHvjea_actionscheduler_logs\":87180,\"jLLYHvjea_woocommerce_tax_rate_locations\":1024,\"jLLYHvjea_mailpoet_stats_notifications\":1024,\"jLLYHvjea_mailpoet_subscribers\":23692,\"jLLYHvjea_solid_affiliate_creatives\":4096,\"jLLYHvjea_woocommerce_sessions\":8904,\"jLLYHvjea_mailpoet_segments\":6484,\"jLLYHvjea_learndash_pro_quiz_master\":1024,\"jLLYHvjea_learndash_pro_quiz_statistic_ref\":1024,\"jLLYHvjea_terms\":18700,\"jLLYHvjea_mailpoet_statistics_woocommerce_purchases\":1024,\"jLLYHvjea_mailpoet_automations\":1024,\"jLLYHvjea_mailpoet_statistics_clicks\":1024,\"jLLYHvjea_mailpoet_newsletters\":4096,\"jLLYHvjea_mailpoet_feature_flags\":2048,\"jLLYHvjea_mailpoet_subscriber_tag\":1024,\"jLLYHvjea_woocommerce_log\":1024,\"jLLYHvjea_solid_affiliate_affiliate_meta\":11340,\"jLLYHvjea_mailpoet_custom_fields\":2048,\"jLLYHvjea_links\":1024,\"jLLYHvjea_woocommerce_order_itemmeta\":1024,\"jLLYHvjea_solid_affiliates_bulk_payouts\":1024,\"jLLYHvjea_commentmeta\":10312,\"jLLYHvjea_actionscheduler_actions\":136724,\"jLLYHvjea_mailpoet_forms\":1024,\"jLLYHvjea_comments\":8792,\"jLLYHvjea_learndash_pro_quiz_form\":1024,\"jLLYHvjea_mailpoet_automation_runs\":4096,\"jLLYHvjea_termmeta\":22096,\"jLLYHvjea_mailpoet_statistics_bounces\":1024,\"jLLYHvjea_term_relationships\":23209,\"jLLYHvjea_learndash_pro_quiz_category\":1024,\"jLLYHvjea_mailpoet_scheduled_task_subscribers\":1024,\"jLLYHvjea_wc_webhooks\":1024,\"jLLYHvjea_users\":8456,\"jLLYHvjea_mailpoet_statistics_forms\":1024,\"jLLYHvjea_mailpoet_automation_run_subjects\":4096,\"jLLYHvjea_mailpoet_migrations\":9924,\"jLLYHvjea_woocommerce_shipping_zones\":2072,\"jLLYHvjea_actionscheduler_claims\":3100,\"jLLYHvjea_options\":2956688,\"jLLYHvjea_learndash_pro_quiz_lock\":2048,\"jLLYHvjea_mailpoet_tags\":4096,\"jLLYHvjea_mailpoet_user_flags\":1024,\"jLLYHvjea_wc_admin_note_actions\":25752,\"jLLYHvjea_postmeta\":567376,\"jLLYHvjea_mailpoet_subscriber_segment\":4132,\"jLLYHvjea_mailpoet_newsletter_segment\":1024,\"jLLYHvjea_mailpoet_newsletter_option\":1024,\"jLLYHvjea_yith_wcwl_lists\":11016,\"jLLYHvjea_woocommerce_payment_tokenmeta\":1024,\"jLLYHvjea_mailpoet_statistics_unsubscribes\":1024,\"jLLYHvjea_woocommerce_tax_rates\":1024,\"jLLYHvjea_solid_affiliate_store_credit_transactions\":1024,\"jLLYHvjea_duplicator_pro_packages\":68112,\"jLLYHvjea_mailpoet_newsletter_posts\":1024,\"jLLYHvjea_wc_order_stats\":4096,\"jLLYHvjea_wc_order_addresses\":4096,\"jLLYHvjea_wc_product_meta_lookup\":11584,\"jLLYHvjea_woocommerce_shipping_zone_locations\":4128,\"jLLYHvjea_mailpoet_automation_run_logs\":4096,\"jLLYHvjea_mailpoet_newsletter_templates\":1091608,\"jLLYHvjea_wpcc_urls\":5848,\"jLLYHvjea_solid_affiliate_visits\":5472,\"jLLYHvjea_solid_affiliate_affiliates\":11336,\"jLLYHvjea_wc_product_attributes_lookup\":1024,\"jLLYHvjea_usermeta\":15200,\"jLLYHvjea_solid_affiliate_referrals\":4096,\"jLLYHvjea_mailpoet_dynamic_segment_filters\":1024,\"jLLYHvjea_posts\":1102200,\"jLLYHvjea_learndash_pro_quiz_statistic\":1024,\"jLLYHvjea_learndash_pro_quiz_prerequisite\":1024,\"jLLYHvjea_wpsmtp_logs\":2104,\"jLLYHvjea_social_users\":2048,\"jLLYHvjea_wc_reserved_stock\":1024,\"jLLYHvjea_mailpoet_statistics_newsletters\":1024,\"jLLYHvjea_woocommerce_order_items\":1024,\"jLLYHvjea_wc_order_coupon_lookup\":1024,\"jLLYHvjea_mailpoet_log\":1024,\"jLLYHvjea_mailpoet_newsletter_links\":2048,\"jLLYHvjea_wc_tax_rate_classes\":9288,\"jLLYHvjea_mailpoet_subscriber_custom_field\":1024,\"jLLYHvjea_woocommerce_api_keys\":2048,\"jLLYHvjea_wc_product_download_directories\":9380,\"jLLYHvjea_woocommerce_shipping_zone_methods\":2092,\"jLLYHvjea_yith_wcwl\":18816,\"jLLYHvjea_woocommerce_attribute_taxonomies\":1024,\"jLLYHvjea_learndash_user_activity_meta\":10328,\"jLLYHvjea_mailpoet_subscriber_ips\":1024,\"jLLYHvjea_wc_admin_notes\":30984,\"jLLYHvjea_mailpoet_automation_versions\":1024,\"jLLYHvjea_learndash_pro_quiz_question\":1024,\"jLLYHvjea_learndash_pro_quiz_template\":1024,\"jLLYHvjea_solid_affiliate_affiliate_product_rates\":1024,\"jLLYHvjea_wc_rate_limits\":4096,\"jLLYHvjea_learndash_pro_quiz_toplist\":1024,\"jLLYHvjea_wc_order_tax_lookup\":1024,\"jLLYHvjea_mailpoet_statistics_opens\":1024,\"jLLYHvjea_wc_customer_lookup\":2048,\"jLLYHvjea_solid_affiliate_affiliate_groups\":3140,\"jLLYHvjea_mailpoet_settings\":5020,\"jLLYHvjea_solid_affiliate_payouts\":4096,\"jLLYHvjea_duplicator_pro_entities\":8944,\"jLLYHvjea_mailpoet_newsletter_option_fields\":9324}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":false,\"copied_archive\":false,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":false,\"status_message_details\":\"\",\"started_timestamp\":null,\"stopped_timestamp\":null}],\"active_storage_id\":-1,\"template_id\":5}');

/* INSERT TABLE DATA: jLLYHvjea_learndash_user_activity */
INSERT INTO `jLLYHvjea_learndash_user_activity` VALUES(1, 2, 452, 452, 'access', 0, 1692264105, 0, 1692264105),
 (2, 2, 452, 452, 'course', 0, 1692264158, 0, 1692264165),
 (3, 2, 454, 452, 'lesson', 1, 1692264158, 1692264165, 1692264165),
 (4, 2, 456, 452, 'lesson', 0, 1692264166, NULL, 1692264166);

/* INSERT TABLE DATA: jLLYHvjea_learndash_user_activity_meta */
INSERT INTO `jLLYHvjea_learndash_user_activity_meta` VALUES(1, 2, 'steps_completed', '1'),
 (2, 2, 'steps_last_id', '456');

/* INSERT TABLE DATA: jLLYHvjea_mailpoet_migrations */
INSERT INTO `jLLYHvjea_mailpoet_migrations` VALUES(1, 'Migration_20221028_105818', '2023-08-16 17:12:48', '2023-08-16 17:12:48', 0, NULL),
 (2, 'Migration_20221110_151621', '2023-08-16 17:12:48', '2023-08-16 17:12:48', 0, NULL),
 (3, 'Migration_20230111_120000', '2023-08-16 17:12:48', '2023-08-16 17:12:48', 0, NULL),
 (4, 'Migration_20230111_130000', '2023-08-16 17:12:48', '2023-08-16 17:12:48', 0, NULL),
 (5, 'Migration_20230215_050813', '2023-08-16 17:12:48', '2023-08-16 17:12:48', 0, NULL),
 (6, 'Migration_20230221_200520', '2023-08-16 17:12:48', '2023-08-16 17:12:48', 0, NULL),
 (7, 'Migration_20230421_135915', '2023-08-16 17:12:49', '2023-08-16 17:12:49', 0, NULL),
 (8, 'Migration_20230503_210945', '2023-08-16 17:12:49', '2023-08-16 17:12:49', 0, NULL),
 (9, 'Migration_20230605_174836', '2023-08-16 17:12:49', '2023-08-16 17:12:49', 0, NULL),
 (10, 'Migration_20230703_105957', '2023-08-16 17:12:49', '2023-08-16 17:12:49', 0, NULL),
 (11, 'Migration_20221028_105818_App', '2023-08-16 17:12:49', '2023-08-16 17:12:49', 0, NULL),
 (12, 'Migration_20230109_144830', '2023-08-16 17:12:49', '2023-08-16 17:12:49', 0, NULL),
 (13, 'Migration_20230131_121621', '2023-08-16 17:12:49', '2023-08-16 17:12:49', 0, NULL),
 (14, 'Migration_20230419_080000', '2023-08-16 17:12:49', '2023-08-16 17:12:49', 0, NULL),
 (15, 'Migration_20230425_211517', '2023-08-16 17:12:49', '2023-08-16 17:12:49', 0, NULL),
 (16, 'Migration_20230712_180341', '2023-08-16 17:12:49', '2023-08-16 17:12:49', 0, NULL);

/* INSERT TABLE DATA: jLLYHvjea_mailpoet_newsletter_option_fields */
INSERT INTO `jLLYHvjea_mailpoet_newsletter_option_fields` VALUES(1, 'isScheduled', 'standard', NULL, '2023-08-16 17:12:49'),
 (2, 'scheduledAt', 'standard', NULL, '2023-08-16 17:12:49'),
 (3, 'event', 'welcome', NULL, '2023-08-16 17:12:49'),
 (4, 'segment', 'welcome', NULL, '2023-08-16 17:12:49'),
 (5, 'role', 'welcome', NULL, '2023-08-16 17:12:49'),
 (6, 'afterTimeNumber', 'welcome', NULL, '2023-08-16 17:12:49'),
 (7, 'afterTimeType', 'welcome', NULL, '2023-08-16 17:12:49'),
 (8, 'intervalType', 'notification', NULL, '2023-08-16 17:12:49'),
 (9, 'timeOfDay', 'notification', NULL, '2023-08-16 17:12:49'),
 (10, 'weekDay', 'notification', NULL, '2023-08-16 17:12:49'),
 (11, 'monthDay', 'notification', NULL, '2023-08-16 17:12:49'),
 (12, 'nthWeekDay', 'notification', NULL, '2023-08-16 17:12:49'),
 (13, 'schedule', 'notification', NULL, '2023-08-16 17:12:49'),
 (14, 'group', 'automatic', NULL, '2023-08-16 17:12:49'),
 (15, 'group', 'automation', NULL, '2023-08-16 17:12:49'),
 (16, 'group', 'automation_transactional', NULL, '2023-08-16 17:12:49'),
 (17, 'event', 'automatic', NULL, '2023-08-16 17:12:49'),
 (18, 'event', 'automation', NULL, '2023-08-16 17:12:49'),
 (19, 'event', 'automation_transactional', NULL, '2023-08-16 17:12:49'),
 (20, 'sendTo', 'automatic', NULL, '2023-08-16 17:12:49'),
 (21, 'segment', 'automatic', NULL, '2023-08-16 17:12:49'),
 (22, 'afterTimeNumber', 'automatic', NULL, '2023-08-16 17:12:49'),
 (23, 'afterTimeType', 'automatic', NULL, '2023-08-16 17:12:49'),
 (24, 'meta', 'automatic', NULL, '2023-08-16 17:12:49'),
 (25, 'afterTimeNumber', 're_engagement', NULL, '2023-08-16 17:12:49'),
 (26, 'afterTimeType', 're_engagement', NULL, '2023-08-16 17:12:49'),
 (27, 'automationId', 'automation', NULL, '2023-08-16 17:12:49'),
 (28, 'automationStepId', 'automation', NULL, '2023-08-16 17:12:49');

/* INSERT TABLE DATA: jLLYHvjea_mailpoet_newsletter_templates */
INSERT INTO `jLLYHvjea_mailpoet_newsletter_templates` VALUES(1, 0, 'Welcome Email: Blank 1 Column', '[\"welcome\",\"blank\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Hi, new subscriber!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>[subscriber:firstname | default:Subscriber],<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>You recently joined our list and we\'d like to give you a warm welcome!<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>Want to get to know us better? Check out some of our most popular articles: <\\/p>\\n<ol>\\n<li><a href=\\\"https:\\/\\/www.mailpoet.com\\/blog\\/the-importance-of-focus-when-writing\\/\\\">The Importance of Focus When Writing<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.mailpoet.com\\/blog\\/writing-next-great-email-subject-line\\/\\\">How to Write a Great Subject Line<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.mailpoet.com\\/blog\\/write-advice-motivation\\/\\\">Just Sit Down and Write &ndash; Advice on Motivation from Ernest Hemingway<\\/a><\\/li>\\n<\\/ol>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"https:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"https:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/welcome-email-blank-1-column/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (2, 0, 'Welcome Email: Blank 1:2 Column', '[\"welcome\",\"blank\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Hi, new subscriber!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>[subscriber:firstname | default:Subscriber],<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>You recently joined our list and we\'d like to give you a warm welcome!<\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Our Most Popular Posts<\\/h3>\"},{\"type\":\"text\",\"text\":\"<ul>\\n<li><a href=\\\"https:\\/\\/www.mailpoet.com\\/blog\\/the-importance-of-focus-when-writing\\/\\\">The Importance of Focus When Writing<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.mailpoet.com\\/blog\\/writing-next-great-email-subject-line\\/\\\">How to Write a Great Subject Line<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.mailpoet.com\\/blog\\/write-advice-motivation\\/\\\">Just Sit Down and Write &ndash; Advice on Motivation from Ernest Hemingway<\\/a><\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>What\'s Next?<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>Add a single button to your newsletter in order to have one clear call-to-action, which will increase your click rates.<\\/p>\"},{\"type\":\"button\",\"text\":\"Read up!\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"https:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"https:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/welcome-email-blank-1-2-column/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (3, 0, 'Gift Welcome', '[\"welcome\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/gift\\/Gift-Header-1.jpg\",\"alt\":\"Gift-Header-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#e7e7e7\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #dd2d2d;\\\">We\'re so happy you\'re onboard!<\\/span><\\/h2>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in. <\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue. Aliquam ultricies purus vel commodo vehicula.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#dd2d2d\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/gift\\/Gift-Footer.jpg\",\"alt\":\"Gift-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"23px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Address Line 1<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Address Line 2<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>City<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Country<\\/strong><\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"5.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 11px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a><span>&nbsp;|&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#dd2d2d\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/gift/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (4, 0, 'Minimal', '[\"welcome\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#303c54\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/Minimal-Logo1.png\",\"alt\":\"Minimal-Logo1\",\"fullWidth\":false,\"width\":\"590px\",\"height\":\"93px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"80px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><span style=\\\"color: #8b9cbc;\\\">EST.2009<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"41px\"}}},{\"type\":\"text\",\"text\":\"<h2>Welcome to Minimal, Kim.<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in. Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue. Aliquam ultricies purus vel commodo vehicula. Cras sollicitudin nunc facilisis neque tristique sagittis.<\\/p>\\n<p><\\/p>\\n<p>Maecenas iaculis, lacus malesuada dictum dapibus, justo justo molestie lorem, ac dapibus magna urna vel arcu. Aliquam erat volutpat. Sed bibendum, ipsum sed ullamcorper blandit, eros odio interdum nibh, non venenatis metus lacus vitae lectus.<\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"30px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#d9d9d9\"}}},{\"type\":\"text\",\"text\":\"<h2>Some of our recent stories<\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/plasma-stingray111-800x533.jpg\",\"alt\":\"plasma-stingray111-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/gettyimages-578313682-800x533.jpg\",\"alt\":\"gettyimages-578313682-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/5_what_to_do_p352m1141746-800x533.jpg\",\"alt\":\"5_what_to_do_p352m1141746-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f3f3f3\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"47px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/Minimal-Logo-Small.png\",\"alt\":\"Minimal-Logo-Small\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"23px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #808080;\\\">Unsubscribe<\\/a><\\/span><\\/p>\\n<p><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #808080;\\\">Manage your subscription<\\/a><\\/span><br \\/><span style=\\\"color: #999999;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f3f3f3\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Georgia\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Georgia\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Georgia\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Georgia\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#303c54\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"30px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#d9d9d9\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/minimal/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (5, 0, 'New Phone Purchase', '[\"welcome\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1b1821\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Logo.png\",\"alt\":\"Phone-Logo\",\"fullWidth\":true,\"width\":\"122px\",\"height\":\"23px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1b1821\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Title.png\",\"alt\":\"Phone-Title\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"215px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Header.jpg\",\"alt\":\"Phone-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Welcome to your brand new Casia 7200.<\\/strong><\\/span><\\/h3>\\n<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #8748d5;\\\">Let\'s get you all set up.<\\/span><\\/strong><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#8748d5\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"159px\",\"lineHeight\":\"45px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#2c2c2c\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">Address Line 1<\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">Address Line 2<\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">City<\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">Country<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Logo.png\",\"alt\":\"Phone-Logo\",\"fullWidth\":false,\"width\":\"122px\",\"height\":\"23px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"pinterest\",\"link\":\"http:\\/\\/www.pinterest.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Pinterest.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Pinterest\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/LinkedIn.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}]}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right; font-size: 11px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a><\\/p>\\n<p style=\\\"text-align: right; font-size: 11px;\\\"><a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#8748d5\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#1b1821\"},\"body\":{\"backgroundColor\":\"#1b1821\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/phone/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (6, 0, 'Sunglasses', '[\"welcome\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Logo.jpg\",\"alt\":\"Glasses-Logo\",\"fullWidth\":false,\"width\":\"250px\",\"height\":\"66px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"17px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Header-2.jpg\",\"alt\":\"Glasses-Header-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"116px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Here\'s what we sent you<\\/strong><\\/span><\\/h3>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Images-1.jpg\",\"alt\":\"Glasses-Images-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"650px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Choose These Frames\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"195px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Images-2.jpg\",\"alt\":\"Glasses-Images-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"650px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Choose These Frames\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"195px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Images-3.jpg\",\"alt\":\"Glasses-Images-3\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"650px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Choose These Frames\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"195px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"34.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Header.jpg\",\"alt\":\"Glasses-Header\",\"fullWidth\":true,\"width\":\"640px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Our Summer Range Is Here<\\/strong><\\/h3>\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit.<\\/p>\\n<p><\\/p>\\n<p>Fusce finibus convallis augue, ut viverra felis placerat in. Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue.&nbsp;<\\/p>\"},{\"type\":\"button\",\"text\":\"Find Out More\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"137px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"34.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Got any questions or need some help?<\\/strong><\\/span><\\/h2>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">We\'re just a click or a phone call away.<\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><\\/span><\\/p>\\n<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Call Us:<\\/strong> 08856877854<\\/span><\\/h3>\\n<h3 style=\\\"text-align: center;\\\"><\\/h3>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"23.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 11px;\\\"><strong><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #808080;\\\">Unsubscribe<\\/a>&nbsp;|&nbsp;<a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #808080;\\\">Manage your subscription<\\/a><\\/span><\\/strong><br \\/><span style=\\\"color: #808080;\\\">Add your postal address here!<\\/span><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/sunglasses/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (7, 0, 'Real Estate', '[\"welcome\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#8691be\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Logo-1-150x84.jpg\",\"alt\":\"Property-Logo-1\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"84px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#8691be\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\">TAKING&nbsp;THE WORRY OUT OF REAL ESTATE<\\/span><\\/strong><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Welcome Home<\\/span><\\/h1>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Header.jpg\",\"alt\":\"Property-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"782px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\">We\'re here to help you move<\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Icon-1.png\",\"alt\":\"Property-Icon-1\",\"fullWidth\":false,\"width\":\"48px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex.<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Icon-2.png\",\"alt\":\"Property-Icon-2\",\"fullWidth\":false,\"width\":\"48px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex.<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Icon-3.png\",\"alt\":\"Property-Icon-3\",\"fullWidth\":false,\"width\":\"48px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"22.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#8691be\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">We\'d love to keep you updated with our latest news. <\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Sign up to our newsletter now and you\'ll never miss a thing.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Sign Up Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#8691be\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#6a7087\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffffff;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffffff;\\\">Manage your subscription<\\/a><\\/span><\\/strong><br \\/><span style=\\\"color: #ffffff;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#6a7087\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/real-estate/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (8, 0, 'App Welcome', '[\"welcome\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#32b6c6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Logo-1.png\",\"alt\":\"App-Signup-Logo\",\"fullWidth\":false,\"width\":\"80px\",\"height\":\"80px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center; margin: 0;\\\"><strong>Welcome to Appy<\\/strong><\\/h1><p style=\\\"text-align: center; margin: 0;\\\"><span style=\\\"color: #ffffff;\\\">Let\'s get started!<\\/span><\\/p>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Header.png\",\"alt\":\"App-Signup-Header\",\"fullWidth\":false,\"width\":\"1280px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Hi [subscriber:firstname | default:subscriber],<\\/p>\\n                                  <p style=\\\"text-align: center;\\\"><\\/p>\\n                                  <p style=\\\"text-align: center;\\\">In MailPoet, you can write emails in plain text, just like in a regular email. This can make your email newsletters more personal and attention-grabbing.<\\/p>\\n                                  <p style=\\\"text-align: center;\\\"><\\/p>\\n                                  <p style=\\\"text-align: center;\\\">Is this too simple? You can still style your text with basic formatting, like <strong>bold<\\/strong> or <em>italics.<\\/em><\\/p>\\n                                  <p style=\\\"text-align: center;\\\"><\\/p>\\n                                  <p style=\\\"text-align: center;\\\">Finally, you can also add a call-to-action button between 2 blocks of text, like this:<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"23px\"}}},{\"type\":\"button\",\"text\":\"Get Started Here\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#32b6c6\",\"borderColor\":\"#32b6c6\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"188px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Team.jpg\",\"alt\":\"App-Signup-Team\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"700px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Logo-Footer.png\",\"alt\":\"App-Signup-Logo-Footer\",\"fullWidth\":false,\"width\":\"50px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><strong>Appy<\\/strong><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><span>Address Line 1<\\/span><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><span>Address Line 2<\\/span><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><span>City<\\/span><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a><span> | <\\/span><a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#404040\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#404040\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#32b6c6\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#32b6c6\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/app_welcome/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (9, 0, 'Welcome to FoodBox', '[\"welcome\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-Logo.png\",\"alt\":\"Food-Delivery-Logo\",\"fullWidth\":false,\"width\":\"640px\",\"height\":\"180px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-App.png\",\"alt\":\"Food-Delivery-App\",\"fullWidth\":false,\"width\":\"640px\",\"height\":\"180px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h1><strong>Welcome to FoodBox<\\/strong><\\/h1>\\n                                  <h2><strong>Lorem ipsum dolor sit amet<\\/strong><\\/h2>\\n                                  <p>Curabitur sollicitudin eros eu cursus sollicitudin. Suspendisse laoreet sollicitudin urna, ut lacinia risus dictum a. Integer a neque eu magna commodo sodales eu eget ante.<\\/p>\"},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7cc119\",\"borderColor\":\"#7cc119\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-Focus.jpg\",\"alt\":\"Food-Delivery-Focus\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"800px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"31.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#e5e5e5\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\">Get started in 3 simple steps<\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-1-1.png\",\"alt\":\"Food-Delivery-1\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"250px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sollicitudin eros eu cursus sollicitudin.<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-2-1.png\",\"alt\":\"Food-Delivery-2\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"250px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"text-align: center;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sollicitudin eros eu cursus sollicitudin.<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-3-1.png\",\"alt\":\"Food-Delivery-3\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"250px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"text-align: center;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sollicitudin eros eu cursus sollicitudin.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7cc119\",\"borderColor\":\"#7cc119\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#4599da\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 14px;\\\"><strong><span style=\\\"color: #ffffff;\\\">Link 1 - Link 2 - Link 3 - Link 4<\\/span><\\/strong><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#4599da\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\"},\"h1\":{\"fontColor\":\"#4599da\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#878787\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"link\":{\"fontColor\":\"#4599da\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f4f4f4\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/food_box/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (10, 0, 'Poet', '[\"welcome\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#909090\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"144px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Logo.png\",\"alt\":\"Poet-Logo\",\"fullWidth\":false,\"width\":\"166px\",\"height\":\"144px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1>Thanks for signing up!<\\/h1>\\n    <p><span style=\\\"color: #000000;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"66px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 12px;\\\"><span style=\\\"color: #999999;\\\"><strong>Latest p<\\/strong><\\/span><\\/p>\\n    <h2><strong>The 26th of December<\\/strong><\\/h2>\\n    <h3><span>A Tuesday, day of Tiw,<\\/span><br \\/><span>god of war, dawns in darkness.<\\/span><br \\/><span>The short holiday day of talking by the fire,<\\/span><br \\/><span>floating on snowshoes among<\\/span><br \\/><span>ancient self-pollarded maples,<\\/span><br \\/><span>visiting, being visited, giving<\\/span><br \\/><span>a rain gauge, receiving red socks,<\\/span><br \\/><span>watching snow buntings nearly over<\\/span><br \\/><span>their heads in snow stab at spirtled bits<\\/span><br \\/><span>of sunflower seeds the chickadees<\\/span><br \\/><span>hold with their feet to a bough<\\/span><br \\/><span>and hack apart, scattering debris<\\/span><br \\/><span>like sloppy butchers, is over.<\\/span><br \\/><span>Irregular life begins. Telephone calls,<\\/span><br \\/><span>Google searches, evasive letters,<\\/span><br \\/><span>complicated arrangements, faxes,<\\/span><br \\/><span>second thoughts, consultations,<\\/span><br \\/><span>e-mails, solemnly given kisses.<\\/span><\\/h3>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Images-1.jpg\",\"alt\":\"Poet-Images\",\"fullWidth\":true,\"width\":\"400px\",\"height\":\"1200px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#393939\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff;\\\">What did you think of this poem? Let me know on one of my social media channels.<\\/span><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"styles\":{\"block\":{\"textAlign\":\"right\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\">Poetry books<\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Books-1.png\",\"alt\":\"Poet-Books-1\",\"fullWidth\":false,\"width\":\"220px\",\"height\":\"646px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Books-3.png\",\"alt\":\"Poet-Books-3\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"646px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Books-2.png\",\"alt\":\"Poet-Books-2\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"646px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Logo.png\",\"alt\":\"Poet-Logo\",\"fullWidth\":false,\"width\":\"166px\",\"height\":\"144px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#939393\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#333333\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#646464\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#393939\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"24px\"},\"h2\":{\"fontColor\":\"#393939\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"30px\"},\"h3\":{\"fontColor\":\"#646464\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"16px\"},\"link\":{\"fontColor\":\"#393939\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ebebeb\"},\"body\":{\"backgroundColor\":\"#ebebeb\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#939393\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#333333\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\",\"styles\":{\"block\":{\"textAlign\":\"right\"}}},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#909090\",\"textDecoration\":\"none\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/poet/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (11, 0, 'Post Notifications: Blank 1 Column', '[\"notification\",\"blank\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"fake-logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Check Out Our New Blog Posts! <\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>MailPoet can <span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><em>automatically<\\/em> <\\/span><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">send your new blog posts to your subscribers.<\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">Below, you\'ll find three recent posts, which are displayed automatically, thanks to the <em>Automatic Latest Content<\\/em> widget, which can be found in the right sidebar, under <em>Content<\\/em>.<\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">To edit the settings and styles of your post, simply click on a post below.<\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/post-notifications-blank-1-column/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (12, 0, 'Modular Style Stories', '[\"notification\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/Modular-Logo.png\",\"alt\":\"Modular-Logo\",\"fullWidth\":false,\"width\":\"271px\",\"height\":\"37px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"26px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"pinterest\",\"link\":\"http:\\/\\/www.pinterest.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Pinterest.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Pinterest\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\",\"height\":\"40px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"1px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"120px\",\"lineHeight\":\"40px\",\"fontColor\":\"#b956c5\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"3px\",\"borderColor\":\"#efe7f0\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/gettyimages-578313682-800x533.jpg\",\"alt\":\"Ladybird\\u2019s transparent shell reveals how it folds its wings\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Ladybird&rsquo;s transparent shell reveals how it folds its wings<\\/strong><\\/h3>\\n<p class=\\\"mailpoet_wp_post\\\">They certainly know how to fold. A see-through artificial wing case has been used to watch for the first time as ladybirds put away their wings after flight.<\\/p>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/plasma-stingray111-800x533.jpg\",\"alt\":\"Plasma jet engines that could take you from the ground to space\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Plasma jet engines that could take you from ground to space<\\/strong><\\/h3>\\n<p class=\\\"mailpoet_wp_post\\\">FORGET fuel-powered jet engines. We&rsquo;re on the verge of having aircraft that can fly from the ground up to the edge of space using air and electricity alone.<\\/p>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/cutting-through-the-smog-what-to-do-to-fight-air-pollution\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/5_what_to_do_p352m1141746-800x533.jpg\",\"alt\":\"Cutting through the smog: What to do to fight air pollution\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>Cutting through the smog: What to do to fight air pollution<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/cutting-through-the-smog-what-to-do-to-fight-air-pollution\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/gettyimages-578313682-800x533.jpg\",\"alt\":\"Ladybird\\u2019s transparent shell reveals how it folds its wings\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>Ladybird&rsquo;s transparent shell reveals how it folds its wings<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/plasma-stingray111-800x533.jpg\",\"alt\":\"Plasma jet engines that could take you from the ground to space\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>Plasma jet engines that could take you from the ground to space<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"21px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffffff;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffffff;\\\">Manage your subscription<\\/a><\\/span><br \\/><span style=\\\"color: #ffffff;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h3\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#b956c5\"},\"body\":{\"backgroundColor\":\"#efe7f0\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"2\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"aboveTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"116px\",\"lineHeight\":\"40px\",\"fontColor\":\"#b956c5\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"3px\",\"borderColor\":\"#ffffff\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContent\",\"terms\":[],\"withLayout\":false},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"1px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"120px\",\"lineHeight\":\"40px\",\"fontColor\":\"#b956c5\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"3px\",\"borderColor\":\"#efe7f0\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"aboveTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"posts\",\"offset\":0,\"terms\":[],\"search\":\"\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/modular-style-stories/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (13, 0, 'Stripped RSS Style Layout', '[\"notification\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rss-simple-news\\/RSS-Logo-2.png\",\"alt\":\"RSS-Logo-2\",\"fullWidth\":true,\"width\":\"210px\",\"height\":\"90px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong><span style=\\\"color: #333333;\\\">Latest RSS Simple&nbsp;Posts<\\/span><\\/strong><\\/h3>\\n<p><span style=\\\"color: #999999;\\\">Week 23: 23\\/19\\/19<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"5\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more.\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#ececec\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<p><span style=\\\"color: #808080;\\\"><strong>RSS Simple<\\/strong><\\/span><\\/p>\\n<p><span style=\\\"color: #808080; font-size: 11px;\\\"><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a><span>&nbsp;|&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/strong><\\/span><\\/p>\\n<p><span style=\\\"color: #808080; font-size: 11px;\\\"><strong><span>Add your postal address here!<\\/span><\\/strong><\\/span><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#3478f5\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#3478f5\",\"textDecoration\":\"none\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f4f4f4\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"3\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#efe7f0\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContent\",\"terms\":[],\"withLayout\":false},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more.\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#ececec\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/rss-simple-news/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (14, 0, 'One Full Post In An Email', '[\"notification\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/not-so-medium\\/Not-So-Medium-Logo.png\",\"alt\":\"Not-So-Medium-Logo\",\"fullWidth\":false,\"width\":\"210px\",\"height\":\"90px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p><strong><em>Welcome to this week\'s post. <\\/em><\\/strong><\\/p>\\n<p><em>Every Friday, we send you the most interesting story&nbsp;of the week in full.<\\/em><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d6d6d6\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"63px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"1\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h1\",\"titleAlignment\":\"center\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"aboveText\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"aboveText\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"View this post online & share!\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><em>Share this with your friends<\\/em><\\/strong><\\/p>\\n<p style=\\\"text-align: center;\\\"><em>We promise not to spam anyone, and we only send our great articles to any email addresses in our list. Promise!<\\/em><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"google-plus\",\"link\":\"http:\\/\\/plus.google.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Google-Plus.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Google Plus\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/LinkedIn.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d6d6d6\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/strong><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#2c2c2c\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Georgia\",\"fontSize\":\"18px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"1\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h1\",\"titleAlignment\":\"center\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"aboveText\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"aboveText\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"View this post online & share!\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"63px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/not-so-medium/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (15, 0, 'Wide Story Layout', '[\"notification\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f0f0f0\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wide-story-layout\\/Wide-Logo.png\",\"alt\":\"Wide-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"37px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #808080;\\\">Our Latest Posts<\\/span><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read The Post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Lucida\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#f0f0f0\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"30px\",\"borderColor\":\"#f0f0f0\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wide-story-layout\\/Wide-Footer.jpg\",\"alt\":\"Wide-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"721px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"21px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffffff;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffffff;\\\">Manage your subscription<\\/a><\\/span><br \\/><span style=\\\"color: #ffffff;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Lucida\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Lucida\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Lucida\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#5ecd39\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f0f0f0\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read The Post\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Lucida\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#f0f0f0\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"30px\",\"borderColor\":\"#f0f0f0\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read The Post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Lucida\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/wide-story-layout/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (16, 0, 'Industry Conference', '[\"notification\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Logo.png\",\"alt\":\"Conf-Logo\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"150px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff; font-size: 11px; text-transform: uppercase; opacity: 0.5; letter-spacing: 3px;\\\">Get ready for the biggest email conference of the year<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Header-2.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"56px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Ticket.png\",\"alt\":\"Conf-Ticket\",\"fullWidth\":false,\"width\":\"339px\",\"height\":\"177px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"font-size: 42px;\\\"><strong><span style=\\\"color: #ffffff; line-height: 1.2; position: relative; top: -5px;\\\">Email Boston 2018<\\/span><\\/strong><\\/span><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"133px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"right\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"147px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"oldest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"4px\",\"borderColor\":\"#dddddd\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Bottom-2.png\",\"alt\":\"Conf-Bottom\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"34px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Industry-Coupon.png\",\"display\":\"fit\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"75px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">---<\\/span><\\/h3>\\n    <h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Grab 20% off your tickets right now<\\/span><\\/h3>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">We\'re offering an exclusive 20% off tickets with this coupon code!<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"CouPon_Code\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"3px\",\"borderRadius\":\"14px\",\"borderStyle\":\"solid\",\"width\":\"229px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"33px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"45px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Top.png\",\"alt\":\"Conf-Top\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"12px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"14px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"7px\",\"borderColor\":\"#e1e1e1\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Holding.jpg\",\"alt\":\"Conf-Holding\",\"fullWidth\":false,\"width\":\"1000px\",\"height\":\"667px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"46px\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Check out&nbsp;this year\'s event<\\/strong><\\/h3>\\n    <p>We\'ve ramped up everything this year for our conference, including amazing new speakers and guests, and a few surprises for everyone.<\\/p>\"},{\"type\":\"button\",\"text\":\"Buy a ticket here\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"147px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"1.5px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"7px\",\"borderColor\":\"#e1e1e1\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Bottom-2.png\",\"alt\":\"Conf-Bottom\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"30px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"header\",\"text\":\"<p>&nbsp;<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#8d8d8d\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #b8291e;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #b8291e;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #b8291e;\\\">Manage your subscription<\\/a><\\/span><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arvo\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arvo\",\"fontSize\":\"26px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arvo\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#b8291e\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#222222\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"right\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"147px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"oldest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"4px\",\"borderColor\":\"#dddddd\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"3px\",\"borderRadius\":\"14px\",\"borderStyle\":\"solid\",\"width\":\"229px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"padding\":\"1.5px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"7px\",\"borderColor\":\"#515151\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"75px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#8d8d8d\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/industry-conference/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (17, 0, 'Science Weekly', '[\"notification\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Science-Logo.png\",\"alt\":\"Science-Logo\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"300px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Title-22.png\",\"alt\":\"Health-Mag-Title-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"214px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#b1b6d1\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>The latest news from the world of science<\\/strong><\\/span><\\/h1>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"40px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"2\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"borderColor\":\"#2b2d37\",\"borderWidth\":\"1px\",\"borderRadius\":\"21px\",\"borderStyle\":\"solid\",\"width\":\"114px\",\"lineHeight\":\"33px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#b1b6d1\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-End-1.png\",\"alt\":\"Health-Mag-End\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-Start.png\",\"alt\":\"Health-Mag-Promo-Start\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"text\",\"text\":\"<h2><strong>Download our app!<\\/strong><\\/h2>\\n                      <p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed in odio dui. Duis et dolor nec erat dictum laoreet. Morbi dapibus turpis id eros viverra tempor. <\\/span><\\/p>\\n                      <p><span><\\/span><\\/p>\\n                      <p><span>Fusce et diam ac sapien posuere luctus. Etiam in vehicula metus, ac viverra elit. Duis diam lacus, molestie vel enim non, rutrum placerat massa. Suspendisse a elit tincidunt, egestas lacus at, maximus diam. <\\/span><\\/p>\\n                      <p><span><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Download Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"borderColor\":\"#2b2d37\",\"borderWidth\":\"1px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"144px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Phone.png\",\"alt\":\"Health-Mag-Phone\",\"fullWidth\":false,\"width\":\"400px\",\"height\":\"573px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-End.png\",\"alt\":\"Health-Mag-Promo-End\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"35px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-Start.png\",\"alt\":\"Health-Mag-Promo-Start\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\">Keep In Touch With Us<\\/h3>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-End.png\",\"alt\":\"Health-Mag-Promo-End\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"26px\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #b1b6d1;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #b1b6d1;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #b1b6d1;\\\">Manage your subscription<\\/a><\\/span><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\"},\"text\":{\"fontColor\":\"#d6d6d6\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#2b2d37\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"2\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"borderColor\":\"#2b2d37\",\"borderWidth\":\"1px\",\"borderRadius\":\"21px\",\"borderStyle\":\"solid\",\"width\":\"114px\",\"lineHeight\":\"33px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/science_weekly/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (18, 0, 'Newspaper Traditional', '[\"notification\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f2f9f8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"28px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"font-size: 15px;\\\"><em><strong>[date:mtext][date:dordinal],[date:y]<\\/strong><\\/em><\\/h3>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #008080;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #008080;\\\">View this in your browser.<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f2f9f8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/newspaper-traditional\\/News-Logo.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"100px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Local News<\\/strong><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong>Sports&nbsp;Updates &amp; Scores<\\/strong><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><strong>Business News<\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left;\\\"><strong>Check Out Our New Blog Posts! <\\/strong><\\/h1>\\n    <p style=\\\"text-align: left;\\\">&nbsp;<\\/p>\\n    <p style=\\\"text-align: left;\\\">MailPoet can <span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><em>automatically<\\/em> <\\/span><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">send your new blog posts to your subscribers.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">Below, you\'ll find three recent posts, which are displayed automatically, thanks to the <em>Automatic Latest Content<\\/em> widget, which can be found in the right sidebar, under <em>Content<\\/em>.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">To edit the settings and styles of your post, simply click on a post below.<\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\",\"height\":\"28px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/newspaper-traditional\\/News-Logo.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"100px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #458687;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #458687;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #458687;\\\">Manage your subscription<\\/a><\\/span><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\",\"height\":\"21px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#3d8076\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f2f9f8\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/newspaper-traditional/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (19, 0, 'Clear News', '[\"notification\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"27px\"}}},{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"11px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/News-Logo-1.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"167px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: right;\\\"><span style=\\\"color: #808080;\\\"><strong>October 2018<\\/strong><\\/span><\\/h3>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left; line-height: 1.3;\\\"><strong>Good Morning!<\\/strong><\\/h1>\\n    <h3>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce egestas nisl vel ante finibus fringilla ullamcorper non lectus. Aenean leo neque, egestas et lacus eu, viverra luctus nisi. Donec dapibus mauris at fringilla consequat. Cras sed porta nunc. Ut tincidunt luctus felis sed suscipit. Sed tristique faucibus fermentum.<\\/h3>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"24px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/UEl2.gif\",\"alt\":\"UEl2\",\"fullWidth\":false,\"width\":\"360px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2><strong>Today\'s Top Stories<\\/strong><\\/h2>\"}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":false,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2><strong>We cover all types of news<\\/strong><\\/h2>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"World\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e23f3f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Business\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#50b6ce\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Politics\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#506dce\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Sports\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e1bc2d\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Science\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#a650ce\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Health\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#64b03c\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Family\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#278f6e\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Arts\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#7c5e5e\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Local\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#4d4d4d\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/News-Crossword.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff;\\\">The Friday Crossword<\\/span><\\/h2>\\n    <p style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum vitae ornare elit. Duis laoreet justo sed fringilla maximus. Aenean pharetra nec risus a vestibulum.<\\/span><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get started\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"right\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"22px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"34.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/News-Logo-1.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"167px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a><\\/strong><\\/p>\\n    <p style=\\\"text-align: center;\\\"><strong><a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/strong><\\/p>\"},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Add your postal address!<\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]},{\"type\":\"social\",\"iconSet\":\"default\",\"icons\":[]}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Source Sans Pro\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"16px\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":false,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#4d4d4d\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"34.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"titleOnly\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"centered\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":false,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"posts\",\"offset\":0,\"terms\":[],\"search\":\"\"},\"social\":{\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"11px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/clear-news/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (20, 0, 'Dog Food', '[\"woocommerce\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Logo.png\",\"alt\":\"Dog-Logo\",\"fullWidth\":false,\"width\":\"42px\",\"height\":\"91px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"31px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"line-height: 1.2em;\\\"><strong>Thanks for buying your dog food from us<\\/strong><\\/h1>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Header-1024x409.jpg\",\"alt\":\"Dog-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"511px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Here\'s some other pawsome things to try...&nbsp;<\\/strong><\\/h2>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Product-1.jpg\",\"alt\":\"Dog-Product-1\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Dog Jumper<\\/strong><\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex.<\\/span><\\/p>\\n<p><span><strong><\\/strong><\\/span><\\/p>\\n<p><em><strong>$19.99<\\/strong><\\/em><\\/p>\"},{\"type\":\"button\",\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\",\"borderColor\":\"#000000\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"113px\",\"lineHeight\":\"28px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Product-2.jpg\",\"alt\":\"Dog-Product-2\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Dog&nbsp;Socks<\\/strong><\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><span><em><strong>$19.99<\\/strong><\\/em><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\",\"borderColor\":\"#000000\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"113px\",\"lineHeight\":\"28px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Product-3.jpg\",\"alt\":\"Dog-Product-3\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Glow Collar<\\/strong><\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex.<\\/span><\\/p>\\n<p><em><\\/em><\\/p>\\n<p><em><strong>$19.99<\\/strong><\\/em><\\/p>\"},{\"type\":\"button\",\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\",\"borderColor\":\"#000000\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"113px\",\"lineHeight\":\"28px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#000000\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"45px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"text\",\"text\":\"<h3><strong><\\/strong><span style=\\\"color: #ffffff;\\\">Our Guarantee<\\/span><\\/h3>\\n<p><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue. Morbi id nunc commodo, tempor erat et, pretium neque. Vivamus ante sapien, consequat vitae ante quis, facilisis pellentesque mi. Praesent at scelerisque leo. Donec elementum mi consequat, ultrices lorem nec, vestibulum arcu. Aenean id libero vitae felis consequat maximus<\\/span><\\/p>\\n<p><span style=\\\"color: #ffffff;\\\"><em><\\/em><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#d4d4d4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d4d4d4\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><em><span style=\\\"color: #000000;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #000000;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #000000;\\\">Manage your subscription<\\/a><\\/span><\\/em><\\/strong><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#d4d4d4\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\",\"borderColor\":\"#000000\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"113px\",\"lineHeight\":\"28px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#d4d4d4\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/dog-food/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (21, 0, 'Abandoned Cart – Kids', '[\"woocommerce\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#c3e1e8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#c3e1e8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Logo.png\",\"alt\":\"Kids-Clothing-Logo\",\"fullWidth\":true,\"width\":\"250px\",\"height\":\"121px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"google-plus\",\"link\":\"http:\\/\\/plus.google.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Google-Plus.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Google Plus\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #4e4e4e;\\\"><strong>Boys Clothes<\\/strong><\\/span><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #4e4e4e;\\\"><strong>Girls Clothes<\\/strong><\\/span><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #4e4e4e;\\\"><strong>Toys & Games<\\/strong><\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#9cd1e1\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"80px\"}}},{\"type\":\"text\",\"text\":\"<h1><strong>Wait!<\\/strong><\\/h1><h3>You\\u2019ve left something in your cart!<\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"100px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #4e4e4e;\\\"><strong>Don\\u2019t worry, we saved it for you\\u2026<\\/strong><\\/span><\\/h2>\"}]}]},{\"type\":\"abandonedCartContent\",\"withLayout\":true,\"amount\":\"2\",\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"titlePosition\":\"aboveExcerpt\",\"featuredImagePosition\":\"left\",\"pricePosition\":\"below\",\"readMoreType\":\"none\",\"readMoreText\":\"\",\"readMoreButton\":[],\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}},\"context\":\"abandonedCartContent.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Go To Cart\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"154px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#fceba5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>YOU MIGHT ALSO LIKE\\u2026<\\/strong><\\/h2>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Image-3.jpg\",\"alt\":\"Kids-Clothing-Image-3\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Cherry Dress<\\/strong><\\/p><p><span>$10.99<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"View\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"left\",\"width\":\"90px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Image-2.jpg\",\"alt\":\"Kids-Clothing-Image-2\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Red T-Shirt<\\/strong><\\/p><p><span>$9.49<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"View\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"left\",\"width\":\"90px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Image-4.jpg\",\"alt\":\"Kids-Clothing-Image-4\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Pink Dance Dress<\\/strong><\\/p><p><span>$11.99<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"View\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"left\",\"width\":\"90px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Footer.jpg\",\"alt\":\"Kids-Clothing-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"107px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#c3e1e8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Logo-Footer-150x61.png\",\"alt\":\"Kids-Clothing-Logo-Footer\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"61px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><span style=\\\"color: #333333;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #333333;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #333333;\\\">Manage your subscription<\\/a><\\/span><\\/strong><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"lineHeight\":\"1.6\"},\"h1\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\",\"lineHeight\":\"1.6\"},\"h2\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\",\"lineHeight\":\"1.6\"},\"h3\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\",\"lineHeight\":\"1.6\"},\"link\":{\"fontColor\":\"#9bd2e0\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#c3e1e8\"}},\"blockDefaults\":{\"abandonedCartContent\":{\"amount\":\"2\",\"withLayout\":true,\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"pricePosition\":\"below\",\"readMoreType\":\"none\",\"readMoreText\":\"\",\"readMoreButton\":[],\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"abandonedCartContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"abandonedCartContent\",\"titlePosition\":\"aboveExcerpt\"},\"automatedLatestContent\":{\"amount\":\"5\",\"authorPrecededBy\":\"Author:\",\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"categoriesPrecededBy\":\"Categories:\",\"contentType\":\"post\",\"displayType\":\"excerpt\",\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}}},\"featuredImagePosition\":\"belowTitle\",\"imageFullWidth\":false,\"inclusionType\":\"include\",\"readMoreButton\":{\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"180px\"}},\"text\":\"Read more\",\"url\":\"[postLink]\"},\"readMoreText\":\"Read more\",\"readMoreType\":\"button\",\"showAuthor\":\"no\",\"showCategories\":\"no\",\"showDivider\":true,\"sortBy\":\"newest\",\"titleAlignment\":\"left\",\"titleFormat\":\"h1\",\"titleIsLink\":false},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"authorPrecededBy\":\"Author:\",\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"categoriesPrecededBy\":\"Categories:\",\"contentType\":\"post\",\"displayType\":\"excerpt\",\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}}},\"featuredImagePosition\":\"alternate\",\"imageFullWidth\":false,\"inclusionType\":\"include\",\"readMoreButton\":{\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"180px\"}},\"text\":\"Read more\",\"url\":\"[postLink]\"},\"readMoreText\":\"Read more\",\"readMoreType\":\"button\",\"showAuthor\":\"no\",\"showCategories\":\"no\",\"showDivider\":true,\"sortBy\":\"newest\",\"titleAlignment\":\"left\",\"titleFormat\":\"h1\",\"titleIsLink\":false,\"withLayout\":true},\"button\":{\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"154px\"}},\"text\":\"Go To Cart\",\"url\":\"\",\"type\":\"button\"},\"container\":[],\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}}},\"footer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"}},\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\"},\"posts\":{\"amount\":\"10\",\"authorPrecededBy\":\"Author:\",\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"categoriesPrecededBy\":\"Categories:\",\"contentType\":\"post\",\"displayType\":\"excerpt\",\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}}},\"featuredImagePosition\":\"belowTitle\",\"imageFullWidth\":false,\"inclusionType\":\"include\",\"postStatus\":\"publish\",\"readMoreButton\":{\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"180px\"}},\"text\":\"Read more\",\"url\":\"[postLink]\"},\"readMoreText\":\"Read more\",\"readMoreType\":\"link\",\"showAuthor\":\"no\",\"showCategories\":\"no\",\"showDivider\":true,\"sortBy\":\"newest\",\"titleAlignment\":\"left\",\"titleFormat\":\"h1\",\"titleIsLink\":false},\"products\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"pricePosition\":\"below\",\"readMoreType\":\"link\",\"readMoreText\":\"Buy now\",\"readMoreButton\":{\"text\":\"Buy now\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"height\":\"32px\",\"iconType\":\"facebook\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"link\":\"http:\\/\\/www.facebook.com\",\"text\":\"Facebook\",\"type\":\"socialIcon\",\"width\":\"32px\"},{\"height\":\"32px\",\"iconType\":\"twitter\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"link\":\"http:\\/\\/www.twitter.com\",\"text\":\"Twitter\",\"type\":\"socialIcon\",\"width\":\"32px\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"80px\"}},\"type\":\"spacer\"},\"header\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"}},\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\"},\"woocommerceHeading\":{\"contents\":{\"new_account\":\"New Order: #0001\",\"processing_order\":\"Thank you for your order\",\"completed_order\":\"Thanks for shopping with us\",\"customer_note\":\"A note has been added to your order\"}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/kids-clothing/thumbnail.20201028.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (22, 0, 'Rock Band', '[\"woocommerce\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#060d13\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Header-2.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#060d13\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"315px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"48px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #7acff0;\\\">Free track download<\\/span><\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #d4d4d4;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam. Nunc diam leo, bibendum eget aliquam eget, commodo vitae lectus<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Download now for free\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#152533\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"2px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"18.5px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#1c2f40\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">We\'ve been busy in the studio<\\/span><\\/h2>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #d4d4d4;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Albums-2.jpg\",\"alt\":\"RockBand-Albums-2\",\"fullWidth\":false,\"width\":\"250px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Magnus Opium<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Buy now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7acff0\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"83px\",\"lineHeight\":\"32px\",\"fontColor\":\"#1c2f40\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Albums-1.jpg\",\"alt\":\"RockBand-Albums-1\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Skeletal Bones<\\/p>\"},{\"type\":\"button\",\"text\":\"Buy now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7acff0\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"83px\",\"lineHeight\":\"32px\",\"fontColor\":\"#1c2f40\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Albums-3.jpg\",\"alt\":\"RockBand-Albums-3\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Blinded by Vision<\\/p>\"},{\"type\":\"button\",\"text\":\"Buy now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7acff0\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"83px\",\"lineHeight\":\"32px\",\"fontColor\":\"#1c2f40\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Tours.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1c2f40\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"37px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: right;\\\">New Tour Dates<\\/h1>\\n    <p style=\\\"text-align: right;\\\">14th March - London, UK<\\/p>\\n    <p style=\\\"text-align: right;\\\">15th March - Leeds, UK<\\/p>\\n    <p style=\\\"text-align: right;\\\">16th March - Birmingham, UK<\\/p>\\n    <p style=\\\"text-align: right;\\\">19th March - Manchester, UK<\\/p>\\n    <p style=\\\"text-align: right;\\\">21st March - Glasgow, UK<\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"144px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\">Bounce Rate<\\/h3>\"},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#aaaaaa\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#060d13\"},\"body\":{\"backgroundColor\":\"#060d13\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Buy now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7acff0\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"83px\",\"lineHeight\":\"32px\",\"fontColor\":\"#1c2f40\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"18.5px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#1c2f40\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#aaaaaa\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"none\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/rock-band/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (23, 0, 'Wine City (with coupon)', '[\"woocommerce\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"37px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wine-city\\/Wine-Logo.png\",\"alt\":\"Wine-Logo\",\"fullWidth\":false,\"width\":\"136px\",\"height\":\"67px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"31px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #6d6d6d;\\\"><strong>Red Wine<\\/strong><\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #6d6d6d;\\\"><strong>White&nbsp;Wine<\\/strong><\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #6d6d6d;\\\"><strong>Rose&nbsp;Wine<\\/strong><\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wine-city\\/Wine-Header-1.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Have a drink on us<\\/strong><\\/span><\\/h1>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"231px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"34px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #6d6d6d;\\\"><strong>You\'re our VIP - now it\'s time to celebrate!&nbsp;<\\/strong><\\/span><\\/h2>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #6d6d6d;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue.<\\/span><\\/p>\"},{\"productIds\":[],\"excludedProductIds\":[],\"productCategoryIds\":[],\"excludedProductCategoryIds\":[],\"type\":\"coupon\",\"amount\":10,\"amountMax\":100,\"discountType\":\"percent\",\"expiryDay\":10,\"usageLimit\":\"\",\"usageLimitPerUser\":\"\",\"minimumAmount\":\"\",\"maximumAmount\":\"\",\"emailRestrictions\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#6d6d6d\",\"borderWidth\":\"2px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"219px\",\"lineHeight\":\"50px\",\"fontColor\":\"#6d6d6d\",\"fontFamily\":\"Courier New\",\"fontSize\":\"30px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"source\":\"createNew\",\"code\":\"XXXX-XXXXXXX-XXXX\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"17px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><span style=\\\"color: #6d6d6d;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #6d6d6d;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #6d6d6d;\\\">Manage your subscription<\\/a><\\/span><\\/strong><br \\/><span style=\\\"color: #6d6d6d;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"17px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"231px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/wine-city/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (24, 0, 'Abandoned Cart – Fitness', '[\"woocommerce\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e6e1e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/fitness\\/Fitness-Logo-1.jpg\",\"alt\":\"Fitness-Logo-1\",\"fullWidth\":true,\"width\":\"180px\",\"height\":\"96px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e6e1e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e6e1e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Get back in the game<\\/strong><\\/h1>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/fitness\\/Fitness-Header.jpg\",\"alt\":\"Fitness-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"696px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>You\'ve left something in your cart...<\\/strong><\\/h3>\"}]}]},{\"type\":\"abandonedCartContent\",\"withLayout\":true,\"amount\":\"2\",\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"titlePosition\":\"aboveExcerpt\",\"featuredImagePosition\":\"left\",\"pricePosition\":\"hidden\",\"readMoreType\":\"none\",\"readMoreText\":\"\",\"readMoreButton\":[],\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"abandonedCartContent.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Recover Cart\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#343434\",\"borderWidth\":\"3px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"146px\",\"lineHeight\":\"37px\",\"fontColor\":\"#343434\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#afd147\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>Still interested?<\\/strong><\\/h3>\\n<p style=\\\"text-align: center;\\\"><strong>Here\'s 20% off your order if you complete it right now. We\'re nice like that.<\\/strong><\\/p>\"},{\"productIds\":[],\"excludedProductIds\":[],\"productCategoryIds\":[],\"excludedProductCategoryIds\":[],\"type\":\"coupon\",\"amount\":10,\"amountMax\":100,\"discountType\":\"percent\",\"expiryDay\":10,\"usageLimit\":\"\",\"usageLimitPerUser\":\"\",\"minimumAmount\":\"\",\"maximumAmount\":\"\",\"emailRestrictions\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#afd147\",\"borderColor\":\"#56741d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"219px\",\"lineHeight\":\"50px\",\"fontColor\":\"#56741d\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"source\":\"createNew\",\"code\":\"XXXX-XXXXXXX-XXXX\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/fitness\\/Fitness-Logo-Footer-1.png\",\"alt\":\"Fitness-Logo-Footer-1\",\"fullWidth\":false,\"width\":\"180px\",\"height\":\"52px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\">Address Line 1, Address Line 2, City, Country<\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\"><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #999999;\\\">Unsubscribe<\\/a><span>&nbsp;<\\/span>|<span>&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #999999;\\\">Manage your subscription<\\/a><\\/strong><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"lineHeight\":\"1.6\"},\"h1\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\",\"lineHeight\":\"1.6\"},\"h2\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\",\"lineHeight\":\"1.6\"},\"h3\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\",\"lineHeight\":\"1.6\"},\"link\":{\"fontColor\":\"#3c3c3c\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#222222\"}},\"blockDefaults\":{\"abandonedCartContent\":{\"amount\":\"2\",\"withLayout\":true,\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"pricePosition\":\"hidden\",\"readMoreType\":\"none\",\"readMoreText\":\"\",\"readMoreButton\":[],\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"abandonedCartContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"abandonedCartContent\",\"titlePosition\":\"aboveExcerpt\"},\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Recover Cart\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#343434\",\"borderWidth\":\"3px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"146px\",\"lineHeight\":\"37px\",\"fontColor\":\"#343434\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":[],\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"products\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"pricePosition\":\"below\",\"readMoreType\":\"link\",\"readMoreText\":\"Buy now\",\"readMoreButton\":{\"text\":\"Buy now\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}},\"woocommerceHeading\":{\"contents\":{\"new_account\":\"New Order: #0001\",\"processing_order\":\"Thank you for your order\",\"completed_order\":\"Thanks for shopping with us\",\"customer_note\":\"A note has been added to your order\"}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/fitness/thumbnail.20201028.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (25, 0, 'Motor', '[\"woocommerce\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #d52a2a;\\\"><strong>Welcome to Vector Motors<\\/strong><\\/span><\\/p>\\n    <p style=\\\"text-align: center; font-size: 11px;\\\"><span style=\\\"color: #d52a2a;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/span><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/motor\\/Car-Header-2.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#d52a2a\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/motor\\/Car-Header-logo-1.png\",\"alt\":\"Car-Header-logo-1\",\"fullWidth\":false,\"width\":\"167.5px\",\"height\":\"349px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"118px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"font-size: 35px; line-height: 40px; text-align: left; border-left: 10px solid #d52a2a; margin-left: 20px; padding-left: 20px;\\\"><strong><span style=\\\"color: #ffffff;\\\">Welcome to the club<\\/span><\\/strong><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"72px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #d52a2a;\\\">You\'ve bought the car,&nbsp;here\'s&nbsp;what happens next.<\\/span><\\/strong><\\/h2>\\n    <p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue. Morbi id nunc commodo, tempor erat et, pretium neque. <\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span><\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span>Vivamus ante sapien, consequat vitae ante quis, facilisis pellentesque mi. Praesent at scelerisque leo. Donec elementum mi consequat, ultrices lorem nec, vestibulum arcu. Aenean id libero vitae felis consequat maximus.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1><strong>We\'re here to help<\\/strong><\\/h1>\\n    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue. Morbi id nunc commodo, tempor erat et, pretium neque.<\\/p>\\n    <p><\\/p>\\n    <p><strong><a href=\\\"\\\">Get in touch with us here<\\/a><\\/strong><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\",\"height\":\"113px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"42px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Servicing Plans\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#d52a2a\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"176px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/motor\\/Car-Wheel.jpg\",\"alt\":\"Car-Wheel\",\"fullWidth\":true,\"width\":\"600px\",\"height\":\"560px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>We\'ll be in touch soon with updates<\\/strong><\\/h3>\\n    <p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue. Morbi id nunc commodo, tempor erat et, pretium neque.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #d52a2a;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #d52a2a;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #d52a2a;\\\">Manage your subscription<\\/a><\\/span><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/motor\\/Car-Footer.jpg\",\"alt\":\"Car-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"275px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d52a2a\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Roboto\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#d52a2a\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#e3e3e3\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Servicing Plans\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#d52a2a\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"176px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"18.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"5px\",\"borderColor\":\"#d52a2a\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"118px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#d52a2a\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/motor/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (26, 0, 'Avocado', '[\"woocommerce\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f3f8f3\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/avocado\\/Avocado-Logo-2.png\",\"alt\":\"Avocado-Logo-2\",\"fullWidth\":false,\"width\":\"212px\",\"height\":\"89px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"33px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><strong>Has to be fresh<\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ddeeba\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"58px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Holy Guacamole!<\\/strong><\\/h1>\\n<h2 style=\\\"text-align: center;\\\">Your monthly avocado<\\/h2>\\n<h2 style=\\\"text-align: center;\\\">delivery starts right now.<\\/h2>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/avocado\\/Avocado-Header-1.jpg\",\"alt\":\"Avocado-Header-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"644px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/avocado\\/Avocado-Recipe.jpg\",\"alt\":\"Avocado-Recipe\",\"fullWidth\":true,\"width\":\"600px\",\"height\":\"890px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"135px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>A quick and easy recipe to get you started...<\\/strong><\\/h3>\\n<p style=\\\"text-align: left;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer blandit tortor nec eleifend maximus. Nulla est lectus, tincidunt quis molestie vitae, suscipit non orci.<\\/p>\"},{\"type\":\"button\",\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9ecd2e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"28px\",\"borderStyle\":\"solid\",\"width\":\"111px\",\"lineHeight\":\"36px\",\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#9ecd2e\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #333333;\\\"><\\/span><\\/strong><\\/p>\\n<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #333333;\\\"><\\/span><\\/strong><strong><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.<\\/span><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ddeeba\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"58px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Got a friend that hass to have this too ?<\\/strong><\\/h2>\\n<h2 style=\\\"text-align: center;\\\"><\\/h2>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/avocado\\/Avocado-Coupon.jpg\",\"alt\":\"Avocado-Coupon\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"382px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#dbefb4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Send them your exclusive coupon code now and they\'ll receive 50% off their next order, and you\'ll get your next box for free!&nbsp;<\\/p>\"},{\"productIds\":[],\"excludedProductIds\":[],\"productCategoryIds\":[],\"excludedProductCategoryIds\":[],\"type\":\"coupon\",\"amount\":10,\"amountMax\":100,\"discountType\":\"percent\",\"expiryDay\":10,\"usageLimit\":\"\",\"usageLimitPerUser\":\"\",\"minimumAmount\":\"\",\"maximumAmount\":\"\",\"emailRestrictions\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#dbefb4\",\"borderColor\":\"#3d3d3d\",\"borderWidth\":\"3px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"254px\",\"lineHeight\":\"50px\",\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"source\":\"createNew\",\"code\":\"XXXX-XXXXXXX-XXXX\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#dbefb4\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#f3f8f3\",\"height\":\"44px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><strong><span style=\\\"color: #9ecd2e;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #9ecd2e;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #9ecd2e;\\\">Manage your subscription<\\/a><\\/span><\\/strong><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h3\":{\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#9ecd2e\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f3f8f3\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#9ecd2e\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"33px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/avocado/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (27, 0, 'Book store (with coupon)', '[\"woocommerce\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#125674\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Logo.png\",\"alt\":\"Book-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#125674\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"100px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\">Turn more pages this weekend...<\\/span><\\/strong><\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Just to say thanks, here\'s a small gift from us to you.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"71px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Body-2.png\",\"display\":\"tile\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"21px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #5094ad;\\\"><strong>Read more every week<\\/strong><\\/span><\\/p>\\n    <h2 style=\\\"text-align: center;\\\"><strong>Your free gift!<\\/strong><\\/h2>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Body-2.png\",\"display\":\"tile\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"2px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#125674\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Body-2.png\",\"display\":\"tile\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, adipiscing elit. Fusce mollis orci justo,<\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span>commodo mattis nisi vitae. Sed aliquam, ex ac lacinia tempus,<\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span>enim urna luctus odio, at leo ante non.<\\/span><\\/p>\"},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>20% off all books<\\/strong><\\/h2>\"},{\"productIds\":[],\"excludedProductIds\":[],\"productCategoryIds\":[],\"excludedProductCategoryIds\":[],\"type\":\"coupon\",\"amount\":10,\"amountMax\":100,\"discountType\":\"percent\",\"expiryDay\":10,\"usageLimit\":\"\",\"usageLimitPerUser\":\"\",\"minimumAmount\":\"\",\"maximumAmount\":\"\",\"emailRestrictions\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#125674\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#125674\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"source\":\"createNew\",\"code\":\"XXXX-XXXXXXX-XXXX\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Image-Wide-2.png\",\"alt\":\"Book-Image-Wide\",\"fullWidth\":true,\"width\":\"1200px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#cdc391\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#cdc391\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#125674\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#125674\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Logo.png\",\"alt\":\"Book-Logo\",\"fullWidth\":false,\"width\":\"96px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #cdc391;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #cdc391;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #cdc391;\\\">Manage your subscription<\\/a><\\/span><br \\/><span style=\\\"color: #ffffff;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #ffffff;\\\">View this in your browser.<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Noticia Text\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#125674\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"2px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#125674\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/book-store-with-coupon/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (28, 0, 'Flowers (with coupon)', '[\"woocommerce\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eae5e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #000000;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #000000;\\\">View this email in your browser.<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flowers-Logo.png\",\"alt\":\"Flowers-Logo\",\"fullWidth\":false,\"width\":\"110px\",\"height\":\"180px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"44px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flowers-Header.jpg\",\"alt\":\"Flowers-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"850px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Just for you.<\\/strong><\\/h1>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Welcome to our flower store - as a token of our appreciation for you signing up,<\\/strong><\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>here\'s a little gift from us for your next order.<\\/strong><\\/span><\\/p>\"},{\"productIds\":[],\"excludedProductIds\":[],\"productCategoryIds\":[],\"excludedProductCategoryIds\":[],\"type\":\"coupon\",\"amount\":10,\"amountMax\":100,\"discountType\":\"percent\",\"expiryDay\":10,\"usageLimit\":\"\",\"usageLimitPerUser\":\"\",\"minimumAmount\":\"\",\"maximumAmount\":\"\",\"emailRestrictions\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#292929\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"source\":\"createNew\",\"code\":\"XXXX-XXXXXXX-XXXX\"},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333; font-size: 11px;\\\"><strong><\\/strong><strong>10% off your next order with us. Terms and Conditions apply.<\\/strong><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"45px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>A little inspiration to get you started...<\\/strong><\\/h2>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><strong>New flowers delivered<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut rutrum et lacus a dignissim. Curabitur id nisi malesuada, pharetra massa ut, bibendum lacus.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Buy Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"3px\",\"borderStyle\":\"solid\",\"width\":\"85px\",\"lineHeight\":\"36px\",\"fontColor\":\"#292929\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flower-1.jpg\",\"alt\":\"Flower-1\",\"fullWidth\":false,\"width\":\"730px\",\"height\":\"604px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flower-2.jpg\",\"alt\":\"Flower-2\",\"fullWidth\":false,\"width\":\"730px\",\"height\":\"604px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><strong>Save with a subscription<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut rutrum et lacus a dignissim. Curabitur id nisi malesuada, pharetra massa ut, bibendum lacus.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Buy Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"3px\",\"borderStyle\":\"solid\",\"width\":\"85px\",\"lineHeight\":\"36px\",\"fontColor\":\"#292929\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><strong>Collect from our store<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut rutrum et lacus a dignissim. Curabitur id nisi malesuada, pharetra massa ut, bibendum lacus.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Buy Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"3px\",\"borderStyle\":\"solid\",\"width\":\"85px\",\"lineHeight\":\"36px\",\"fontColor\":\"#292929\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flower-3.jpg\",\"alt\":\"Flower-3\",\"fullWidth\":false,\"width\":\"730px\",\"height\":\"604px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eae5e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #b3748a;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #b3748a;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #b3748a;\\\">Manage your subscription<\\/a><\\/span><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#e0a9bc\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eae5e5\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Buy Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"3px\",\"borderStyle\":\"solid\",\"width\":\"85px\",\"lineHeight\":\"36px\",\"fontColor\":\"#292929\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"392px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/flowers-with-coupon/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (29, 0, 'Newsletter: Blank 1 Column', '[\"standard\",\"blank\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Let\'s Get Started! <\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>It\'s time to design your newsletter! In the right sidebar, you\'ll find 4 menu items that will help you customize your newsletter:<\\/p>\\n<ol>\\n<li>Content<\\/li>\\n<li>Columns<\\/li>\\n<li>Styles<\\/li>\\n<li>Preview<\\/li>\\n<\\/ol>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/newsletter-blank-1-column/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (30, 0, 'Newsletter: Blank 1:2 Column', '[\"standard\",\"blank\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Let\'s Get Started!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>It\'s time to design your newsletter! In the right sidebar, you\'ll find 4 menu items that will help you customize your newsletter:<\\/p>\\n<ol>\\n<li>Content<\\/li>\\n<li>Columns<\\/li>\\n<li>Styles<\\/li>\\n<li>Preview<\\/li>\\n<\\/ol>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2>This template has...<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>In the right sidebar, you can add these layout blocks to your email:<\\/p>\\n<ul>\\n<li>1 column<\\/li>\\n<li>2 columns<\\/li>\\n<li>3 columns<\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2>... a 2-column layout.<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p><span style=\\\"line-height: 25.6px;\\\">You can change a layout\'s background color by clicking on the settings icon on the right edge of the Designer. Simply hover over this area to see the Settings (gear) icon.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/newsletter-blank-1-2-column/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (31, 0, 'Newsletter: Blank 1:2:1 Column', '[\"standard\",\"blank\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Let\'s Get Started!<\\/strong><\\/h1>\\n<p>It\'s time to design your newsletter! In the right sidebar, you\'ll find four menu items that will help you customize your newsletter:<\\/p>\\n<ol>\\n<li>Content<\\/li>\\n<li>Columns<\\/li>\\n<li>Styles<\\/li>\\n<li>Preview<\\/li>\\n<\\/ol>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2>This template has...<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>In the right sidebar, you can add layout blocks to your email:<\\/p>\\n<ul>\\n<li>1 column<\\/li>\\n<li>2 columns<\\/li>\\n<li>3 columns<\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2>... a 2-column layout.<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>You can change a layout\'s background color by clicking on the settings icon on the right edge of the Designer. Simply hover over this area to see the Settings (gear) icon.<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"font-weight: 600;\\\">Let\'s end with a single column. <\\/span><\\/h3>\\n<p style=\\\"line-height: 25.6px;\\\">In the right sidebar, you can add these layout blocks to your email:<\\/p>\\n<p style=\\\"line-height: 25.6px;\\\"><\\/p>\\n<ul style=\\\"line-height: 25.6px;\\\">\\n<li>1 column<\\/li>\\n<li>2 columns<\\/li>\\n<li>3 columns<\\/li>\\n<\\/ul>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/newsletter-blank-1-2-1-column/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (32, 0, 'Newsletter: Blank 1:3 Column', '[\"standard\",\"blank\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Let\'s Get Started! <\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>It\'s time to design your newsletter! In the right sidebar, you\'ll find four menu items that will help you customize your newsletter:<\\/p>\\n<ol>\\n<li>Content<\\/li>\\n<li>Columns<\\/li>\\n<li>Styles<\\/li>\\n<li>Preview<\\/li>\\n<\\/ol>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>This template...<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>In the right sidebar, you can add layout blocks to your newsletter.<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>... has a...<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>You have the choice of:<\\/p>\\n<ul>\\n<li>1 column<\\/li>\\n<li>2 columns<\\/li>\\n<li>3 columns<\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>3-column layout.<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>You can add as many layout blocks as you want!<\\/p>\"},{\"type\":\"text\",\"text\":\"\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/newsletter-blank-1-3-column/thumbnail.20190930.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (33, 0, 'Simple Text', '[\"standard\",\"blank\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\">Hi [subscriber:firstname | default:subscriber],<\\/p>\\n<p style=\\\"text-align: left;\\\"><\\/p>\\n<p style=\\\"text-align: left;\\\">In MailPoet, you can write emails in plain text, just like in a regular email. This can make your email newsletters more personal and attention-grabbing.<\\/p>\\n<p style=\\\"text-align: left;\\\"><\\/p>\\n<p style=\\\"text-align: left;\\\">Is this too simple? You can still style your text with basic formatting, like <strong>bold<\\/strong> or <em>italics.<\\/em><\\/p>\\n<p style=\\\"text-align: left;\\\"><\\/p>\\n<p style=\\\"text-align: left;\\\">Finally, you can also add a call-to-action button between 2 blocks of text, like this:<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"23px\"}}},{\"type\":\"button\",\"text\":\"It\'s time to take action!\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}},{\"type\":\"text\",\"text\":\"<p>Thanks for reading. See you soon!<\\/p>\\n<p>&nbsp;<\\/p>\\n<p><strong><em>The MailPoet Team<\\/em><\\/strong><\\/p>\"},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/simple-text/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (34, 0, 'Take a Hike', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/header.jpg\",\"alt\":\"header\",\"fullWidth\":true,\"width\":\"1320px\",\"height\":\"483px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p>Hi&nbsp;[subscriber:firstname | default:explorer]<\\/p>\\n                      <p><\\/p>\\n                      <p>Aliquam feugiat nisl eget eleifend congue. Nullam neque tellus, elementum vel elit dictum, tempus sagittis nunc. Phasellus quis commodo odio. Vestibulum vitae mi vel quam rhoncus egestas eget vitae eros.&nbsp;<\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1><strong>How to plan your hiking route<\\/strong><\\/h1>\\n                      <p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Aliquam dictum urna ac lacus dapibus rhoncus.<\\/p>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"https:\\/\\/www.google.co.uk\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"150px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/map.jpg\",\"alt\":\"map\",\"fullWidth\":false,\"width\":\"330px\",\"height\":\"227px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/boots.jpg\",\"alt\":\"boots\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2><strong>Tried &amp; tested: Our favourite walking boots<\\/strong><\\/h2>\\n                        <p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.&nbsp;<\\/p>\"},{\"type\":\"button\",\"text\":\"See Reviews\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"150px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>Hikers Gallery<\\/strong><\\/h3>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/gallery3.jpg\",\"alt\":\"gallery3\",\"fullWidth\":true,\"width\":\"1000px\",\"height\":\"750px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/gallery1-300x225.jpg\",\"alt\":\"gallery1\",\"fullWidth\":true,\"width\":\"300px\",\"height\":\"225px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/gallery2-1.jpg\",\"alt\":\"gallery2\",\"fullWidth\":true,\"width\":\"1000px\",\"height\":\"750px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Edit this to insert text<\\/p>\"},{\"type\":\"button\",\"text\":\"View More Photos\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"214px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>Hiking goes social...<\\/strong><\\/h3>\"},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"google-plus\",\"link\":\"http:\\/\\/plus.google.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Google-Plus.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Google Plus\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#4f230c\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#423c39\",\"fontFamily\":\"Courier New\",\"fontSize\":\"24px\"},\"h2\":{\"fontColor\":\"#265f6d\",\"fontFamily\":\"Courier New\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#423c39\",\"fontFamily\":\"Courier New\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#843c15\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#843c15\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/take_a_hike/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (35, 0, 'News Day', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#f2f2f2\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/news_day\\/News-Outlet-Title-2.jpg\",\"alt\":\"News-Outlet-Title-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"700px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left;\\\"><span style=\\\"color: #2ca5d2;\\\"><strong>Top Story<\\/strong><\\/span><\\/h1>\"},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><strong>Plasma jet engines that could take you from the ground to space<\\/strong><\\/h2>\"},{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/news_day\\/plasma-stingray111-800x533.jpg\",\"alt\":\"Plasma jet engines that could take you from the ground to space\",\"fullWidth\":false,\"width\":\"413.28125px\",\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p class=\\\"mailpoet_wp_post\\\">FORGET fuel-powered jet engines. We\\u2019re on the verge of having aircraft that can fly from the ground up to the edge of space using air and electricity alone. Traditional jet engines create thrust by mixing compressed air with fuel and igniting it. The burning mixture expands rapidly and is blasted out of the back of the engine, pushing it forwards. &hellip;<\\/p><p><a href=\\\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #2ca5d2;\\\"><strong>Popular Posts Today<\\/strong><\\/span><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Cutting through the smog: What to do to fight air pollution<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">Tackling our air problems starts with traffic control, but individual action to reduce energy use and intensive farming would also help clean our air.<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/cutting-through-the-smog-what-to-do-to-fight-air-pollution\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Ladybird&rsquo;s transparent shell reveals how it&nbsp;moves<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">They certainly know how to fold. A see-through artificial wing case has been used to watch for the first time as ladybirds put away their wings after flight.<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Brazil&rsquo;s history-making Hurricane<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">Jairzinho has just made history. In claiming the fourth goal of an unforgettable 1970 FIFA World Cup Mexico&trade; Final against Italy, he has maintained his record of scoring in every one of Brazil&rsquo;s matches en route to the Trophy.<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/brazils-history-making-hurricane\\/\\\">Read More<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Iceland&rsquo;s dentist-coach defying convention and expectations<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">As Iceland&rsquo;s key matches loom, with kick-off just a couple of hours away, you will find their national coach in the pub. This may seem unusual...<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/icelands-dentist-coach-defying-convention-and-expectations\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Impact and legacy of 2018 FIFA World Cup Russia<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">Organising a FIFA World Cup&trade; in a sustainable manner is a major challenge. The scale of the event inevitably has an impact on the Host Country.&nbsp;<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/impact-and-legacy-of-2018-fifa-world-cup-russia-facts-and-figures\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Lineker&rsquo;s life-changing treble<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">Given that he won the Golden Boot in his first and came within a whisker of the Final in his second, one might expect Gary Lineker to have a tough time picking his FIFA World Cup&trade; highlight. Yet the man who scored ten times...<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/linekers-life-changing-treble\\/\\\">Read More<\\/a><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#f2f2f2\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><strong>NewsDay<\\/strong><\\/p>\\n                      <p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/><br \\/><\\/p>\\n                      <p><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/LinkedIn.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#f2f2f2\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#2ca5d2\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f2f2f2\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/news_day/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (36, 0, 'World Cup', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Header.png\",\"alt\":\"Sports-Football-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"220px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Divider-1.png\",\"alt\":\"Sports-Football-Divider-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p><strong><span style=\\\"color: #ffffff; font-size: 14px;\\\">Issue #1<\\/span><\\/strong><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" target=\\\"_blank\\\" style=\\\"color: #ffffff; font-size: 14px; text-align: center;\\\">View In Browser<\\/a><\\/p>\\n                                        <p style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff; text-align: start;\\\">Monday 1st January 2017<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Header-1.png\",\"alt\":\"Sports-Football-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"580px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><strong>Welcome Back!<\\/strong><\\/h2>\\n                                      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod mauris velit, vel ultrices nibh bibendum quis. Donec eget fermentum magna.<\\/p>\\n                                      <p><\\/p>\\n                                      <p>Nullam congue dui lectus, quis pellentesque orci placerat eu. Fusce semper neque a mi aliquet vulputate sed sit amet nisi. Etiam sed nisl nec orci pretium lacinia eget in turpis. Maecenas in posuere justo. Vestibulum et sapien vestibulum, imperdiet neque in, maximus velit.<\\/p>\\n                                      <p><\\/p>\\n                                      <p>Proin dignissim elit magna, viverra scelerisque libero vehicula sed<\\/p>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Divider-3.png\",\"alt\":\"Sports-Football-Divider-3\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"padding-bottom: 0;\\\"><span style=\\\"font-weight: 600;\\\">Latest News<\\/span><\\/h2>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"View All News\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#d35400\",\"borderColor\":\"#d35400\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"right\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/brazils-history-making-hurricane\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/2865897_full-lnd.jpg\",\"alt\":\"Brazil\\u2019s history-making Hurricane\",\"fullWidth\":false,\"width\":652,\"height\":366,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Brazil&rsquo;s history-making Hurricane<\\/strong><\\/h3>\\n                                            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod mauris velit, vel ultrices nibh bibendum quis. Donec eget fermentum magna. Nullam congue dui lectus, quis pellentesque orci placerat eu. Fusce semper neque a mi aliquet vulputate sed sit amet nisi...<\\/p>\\n                                            <p><a href=\\\"http:\\/\\/mailpoet.info\\/brazils-history-making-hurricane\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/icelands-dentist-coach-defying-convention-and-expectations\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/2866107_full-lnd.jpg\",\"alt\":\"Iceland\\u2019s dentist-coach defying convention and expectations\",\"fullWidth\":false,\"width\":652,\"height\":366,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Iceland&rsquo;s dentist-coach defying convention and expectations<\\/strong><\\/h3>\\n                                          <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod mauris velit...<\\/p>\\n                                          <p><a href=\\\"http:\\/\\/mailpoet.info\\/icelands-dentist-coach-defying-convention-and-expectations\\/\\\">Read More<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/impact-and-legacy-of-2018-fifa-world-cup-russia-facts-and-figures\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/2709222_full-lnd.jpg\",\"alt\":\"Impact and legacy of 2018 FIFA World Cup Russia: facts and figures\",\"fullWidth\":false,\"width\":652,\"height\":366,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Impact and legacy of 2018 FIFA World Cup Russia: facts and figures<\\/strong><\\/h3>\\n                                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod...<\\/p>\\n                                        <p><a href=\\\"http:\\/\\/mailpoet.info\\/impact-and-legacy-of-2018-fifa-world-cup-russia-facts-and-figures\\/\\\">Read More<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/linekers-life-changing-treble\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/2867790_full-lnd.jpg\",\"alt\":\"Lineker\\u2019s life-changing treble\",\"fullWidth\":false,\"width\":652,\"height\":366,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Lineker&rsquo;s life-changing treble<\\/strong><\\/h3>\\n                                      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod mauris velit&nbsp;<span style=\\\"background-color: inherit;\\\">consequat lorem at est congue...<\\/span><\\/p>\\n                                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/linekers-life-changing-treble\\/\\\">Read More<\\/a><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Divider-2.png\",\"alt\":\"Sports-Football-Divider-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Footer-1.png\",\"alt\":\"Sports-Football-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#b55311\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Logo-Small.png\",\"alt\":\"Sports-Football-Logo-Small\",\"fullWidth\":false,\"width\":\"772px\",\"height\":\"171px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#da6110\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#da6110\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#222222\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/world_cup/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (37, 0, 'Festival Event', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#0a5388\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/festival_event\\/festival-header.jpg\",\"alt\":\"festival-header\",\"fullWidth\":true,\"width\":\"1320px\",\"height\":\"879px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"36px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\">Pack your glowsticks, <br \\/>Boomfest is back!&nbsp;<\\/h1>\\n                        <p><\\/p>\\n                        <p style=\\\"text-align: center;\\\">Duis tempor nisl in risus hendrerit venenatis. <br \\/>Curabitur ornare venenatis nisl non ullamcorper. <\\/p>\"},{\"type\":\"button\",\"text\":\"Duis id tincidunt\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#0a5388\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"260px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Maecenas scelerisque nisi sit amet metus efficitur dapibus!&nbsp;<br \\/>Ut eros risus, facilisis ac aliquet vel, posuere ut urna.<\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"28px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\">Confirmed Lineup<\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><em><span style=\\\"color: #bae2ff;\\\">Main Stage<\\/span><\\/em><\\/h3><p>Quisque libero<br \\/>Nulla convallis<br \\/>Vestibulum Ornare<br \\/>Consectetur Odio<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><em><span style=\\\"color: #bae2ff;\\\">New Acts Stage<\\/span><\\/em><\\/h3><p>Nulla interdum<br \\/>Massa nec<br \\/>Pharetra<br \\/>Varius<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><em><span style=\\\"color: #bae2ff;\\\">Comedy Stage<\\/span><\\/em><\\/h3><p>In pulvinar<br \\/>Risus sed<br \\/>Condimentum<br \\/>Feugiat<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\">New to the festival this year<\\/h2>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"9px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/festival_event\\/street-food.jpg\",\"alt\":\"street food\",\"fullWidth\":true,\"width\":\"499px\",\"height\":\"750px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3>Award-winning Street Food<\\/h3><p>Nullam pharetra lectus id porta pulvinar. Proin ac massa nibh. Nullam ac mi pharetra, lobortis nunc et, placerat leo. Mauris eu feugiat elit. Pellentesque eget turpis eu diam vehicula convallis non <a href=\\\"https:\\/\\/www.mailpoet.com\\\">luctus enim.<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/festival_event\\/happy.jpeg\",\"alt\":\"happy\",\"fullWidth\":true,\"width\":\"499px\",\"height\":\"750px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3>Prepare to&nbsp;dazzle with our Glitter Run<\\/h3><p>Donec quis orci at metus finibus tincidunt. Sed vel urna sed urna maximus congue eu et turpis. Nulla tempus hendrerit justo eget molestie. Vivamus quis molestie lacus. Donec commodo odio a nisi feugiat, vitae egestas mi.<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}}},{\"type\":\"footer\",\"text\":\"<p>Mauris tristique ultricies ullamcorper. <br \\/>Don\'t want to hear from us?&nbsp;<a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a><\\/p><p><\\/p><p>Add your postal address here.&nbsp;<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"13px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"36px\"},\"h2\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"26px\"},\"h3\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"24px\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#8d062b\"},\"body\":{\"backgroundColor\":\"#0a5388\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/festival_event/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (38, 0, 'Retro Computing Magazine', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#4473a1\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#008282\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/retro_computing_magazine\\/Windows94-Header.png\",\"alt\":\"Windows94-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"740px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #ffffff;\\\">View this in your browser.<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"#008282\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left;\\\"><strong>We\'re upgrading!<\\/strong><\\/h1>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In elementum nunc vel est congue, a venenatis nunc aliquet. Curabitur luctus, nulla et dignissim elementum, ipsum eros fermentum nulla, non cursus eros mi eu velit. Nunc ex nibh, porta vulputate pharetra ac, placerat sed orci. Etiam enim enim, aliquet nec ligula in, ultrices iaculis dolor. Suspendisse potenti. Praesent fringilla augue ut lorem mattis, vitae fringilla nunc faucibus. <\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><span>Quisque in leo felis. Etiam at libero et enim tincidunt scelerisque. Ut felis lectus, imperdiet quis justo quis, elementum sagittis tellus. Sed elementum, lacus at iaculis vestibulum, nunc leo gravida nisi, sed dapibus nisi odio ac ex. Aliquam id arcu dictum, cursus quam id, eleifend libero.<\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"ridge\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1><strong>Latest News<\\/strong><\\/h1>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>What is it like to use a Windows 98 PC in 2017?<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p class=\\\"mailpoet_wp_post\\\"><span>Computers are much more advanced than they were even a few years ago, but of course we all like to complain about the dumb things they sometimes do. It&rsquo;s easy to forget how clunky things used to be, though...<\\/span><\\/p>\\n<p><a href=\\\"http:\\/\\/mailpoet.info\\/odds-on-10-science-breakthroughs-you-can-bet-on\\/\\\">Read more<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Windows 95 still finds life online<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p class=\\\"mailpoet_wp_post\\\">Microsoft&rsquo;s Windows 95 has reached the ripe old age of 22 this year and to commemorate this milestone, TheNextWeb goes into some details about the operating system that users may have missed over the years...<\\/p>\\n<p><a href=\\\"http:\\/\\/mailpoet.info\\/brazils-history-making-hurricane\\/\\\">Read more<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>New Sinclair ZX Spectrum Fully Funded<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p class=\\\"mailpoet_wp_post\\\">The new Sinclair ZX Spectrum Next home computer which was launched on Kickstarter to mark the 35th birthday of the original Spectrum produced by Sinclair Research has been fully funded in less than 48 hours...<\\/p>\\n<p><a href=\\\"http:\\/\\/mailpoet.info\\/cutting-through-the-smog-what-to-do-to-fight-air-pollution\\/\\\">Read more<\\/a><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#008282\",\"height\":\"50px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#008282\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2><strong><span style=\\\"color: #ffffff;\\\">Did you know?<\\/span><\\/strong><\\/h2>\\n<p><span style=\\\"color: #ffffff;\\\">At the time of creation and development, the microcomputers in Japan were not powerful enough to handle the complex tasks related to the design and programming of Space Invaders. Nishikado then designed his own hardware and developmental tools to make the game a reality.<\\/span><\\/p>\\n<p><strong><span style=\\\"color: #ffffff;\\\"><\\/span><\\/strong><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/retro_computing_magazine\\/Windows94-Today.png\",\"alt\":\"Windows94-Today\",\"fullWidth\":false,\"width\":\"364px\",\"height\":\"291px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#008282\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong>Let\'s get social!<\\/strong><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#008282\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Courier New\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Courier New\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#008282\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#008282\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/retro_computing_magazine/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50');
INSERT INTO `jLLYHvjea_mailpoet_newsletter_templates` VALUES(39, 0, 'Shoes', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/shoes\\/Retail-Shoes-Logo.png\",\"alt\":\"Retail-Shoes-Logo\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"220px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/shoes\\/Retail-Shoes-Header.jpg\",\"alt\":\"Retail-Shoes-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"700px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f1b512\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #614a0d;\\\">Our New Range<\\/span><\\/h2>\\n                      <p style=\\\"text-align: center;\\\"><span style=\\\"color: #614a0d;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque cursus aliquam urna, non ultricies diam sagittis sit amet. Etiam tempus a metus sed tincidunt.<\\/span><\\/p>\\n                      <p style=\\\"text-align: center;\\\"><span style=\\\"color: #614a0d;\\\">Curabitur fermentum ligula eget lacus aliquam volutpat. Integer sapien neque, laoreet quis lobortis sed, semper eget magna. Suspendisse potentiu.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Find Out More\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#41c7bf\",\"borderColor\":\"#28a9a2\",\"borderWidth\":\"2px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#36b0a9\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"70px\"}}},{\"type\":\"text\",\"text\":\"<h2><span style=\\\"color: #ffffff;\\\">Handcrafted Shoes<\\/span><\\/h2>\\n                       <p style=\\\"font-size: 14px;\\\"><span><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque cursus aliquam urna, non ultricies diam sagittis sit amet. Etiam tempus a metus sed tincidunt. Curabitur fermentum ligula eget lacus aliquam volutpat.<\\/span><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/shoes\\/Retail-Shoes-Boxes-1.jpg\",\"alt\":\"Retail-Shoes-Boxes-1\",\"fullWidth\":true,\"width\":\"700px\",\"height\":\"700px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#36b0a9\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/shoes\\/Retail-Shoes-Boxes-2.jpg\",\"alt\":\"Retail-Shoes-Boxes-2\",\"fullWidth\":true,\"width\":\"700px\",\"height\":\"700px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"70px\"}}},{\"type\":\"text\",\"text\":\"<h2><span style=\\\"color: #ffffff;\\\">Perfect For Any Occasion<\\/span><\\/h2>\\n                      <p style=\\\"font-size: 14px;\\\"><span><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque cursus aliquam urna, non ultricies diam sagittis sit amet. Etiam tempus a metus sed tincidunt. Curabitur fermentum ligula eget lacus aliquam volutpat.<\\/span><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>We\'re open every day!<\\/strong><\\/h3>\\n                        <p style=\\\"text-align: center;\\\">Call in any time and we\'ll help you pick the best shoes for any occasion.<\\/p>\\n                        <p style=\\\"text-align: center;\\\">If you\'re not happy, just bring them back to us and we\'ll give you a full refund.<\\/p>\"},{\"type\":\"button\",\"text\":\"Check Out Our Website\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#41c7bf\",\"borderColor\":\"#28a9a2\",\"borderWidth\":\"2px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"220px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#d3d3d3\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/shoes\\/Retail-Shoes-Logo-Footer.png\",\"alt\":\"Retail-Shoes-Logo-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"60px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span style=\\\"color: #999999;\\\">Address Line 1<\\/span><\\/p>\\n                      <p style=\\\"text-align: center; font-size: 12px;\\\"><span style=\\\"color: #999999;\\\">Address Line 2<\\/span><\\/p>\\n                      <p style=\\\"text-align: center; font-size: 12px;\\\"><span style=\\\"color: #999999;\\\">City<\\/span><\\/p>\\n                      <p style=\\\"text-align: center; font-size: 12px;\\\"><span style=\\\"color: #999999;\\\">Country<\\/span><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#41c7bf\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f6f6f6\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/shoes/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (40, 0, 'Music', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2d2d\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/music\\/Music-Logo.png\",\"alt\":\"Music-Logo\",\"fullWidth\":false,\"width\":\"496px\",\"height\":\"78px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/music\\/music-header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"70px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #393939;\\\"><strong>You Play.<\\/strong><\\/span><\\/h1>\\n<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #393939;\\\"><strong>They Listen.<\\/strong><\\/span><\\/h1>\"},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #878787;\\\">Up to 50% off all of our instruments.<\\/span><\\/h2>\\n<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #878787;\\\">This week only.<\\/span><\\/h2>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"176px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Choose a category and get playing<\\/strong><\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Electric Guitars\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Trumpets\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"DJ Equipment\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Amps\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Drums\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Pianos\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Banjos\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Synthesizers\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Guitar Pedals\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Harmonicas\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Flutes\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Headphones\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2d2d\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2d2d\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/music\\/Music-Logo.png\",\"alt\":\"Music-Logo\",\"fullWidth\":false,\"width\":\"496px\",\"height\":\"78px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 11px;\\\"><span style=\\\"color: #999999;\\\"><em><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #999999;\\\">Unsubscribe<\\/a><\\/strong><\\/em><\\/span><\\/p>\\n<p style=\\\"text-align: center; font-size: 11px;\\\"><span style=\\\"color: #999999;\\\"><em><strong><a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #999999;\\\">Manage your subscription<\\/a><\\/strong><\\/em><\\/span><br \\/><span style=\\\"color: #999999;\\\">Add your postal address here!<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"36px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#2d2d2d\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#2d2d2d\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"176px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/music/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (41, 0, 'Hotels', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2a31\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/hotels\\/Hotel-Logo-1.png\",\"alt\":\"Hotel-Logo\",\"fullWidth\":false,\"width\":\"554px\",\"height\":\"200px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>My Favourites<\\/strong><\\/span><\\/h3>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Recent Bookings<\\/strong><\\/span><\\/h3>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/hotels\\/Hotel-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h1><span style=\\\"color: #ffffff;\\\"><strong>Pets go free<\\/strong><\\/span><\\/h1>\"},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\">Stay in any Exquisite hotel this summer and bring your pet for free!<\\/span><\\/h2>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"button\",\"text\":\"Find Out More\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffc600\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"46px\",\"fontColor\":\"#3f3f3f\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><strong>Get ready to travel in Exquiste style...<\\/strong><\\/h2>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In elementum nunc vel est congue, a venenatis nunc aliquet. Curabitur luctus, nulla et dignissim elementum, ipsum eros fermentum nulla, non cursus eros mi eu velit. Nunc ex nibh, porta vulputate pharetra ac, placerat sed orci. Etiam enim enim, aliquet nec ligula in, ultrices iaculis dolor. Suspendisse potenti. Praesent fringilla augue ut lorem mattis, vitae fringilla nunc faucibus.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/hotels\\/dubai-paris.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}}},{\"type\":\"text\",\"text\":\"<h1><span style=\\\"color: #ffffff;\\\"><strong>Dubai<\\/strong><\\/span><\\/h1>\\n<h2><span style=\\\"color: #ffffff;\\\">From $199<strong><br \\/><\\/strong><\\/span><\\/h2>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}}},{\"type\":\"text\",\"text\":\"<h1><strong><span style=\\\"color: #ffffff;\\\">Paris<\\/span><\\/strong><\\/h1>\\n<h2><span style=\\\"color: #ffffff;\\\">From $149<\\/span><\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/hotels\\/toronto-delhi.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}}},{\"type\":\"text\",\"text\":\"<h1><span style=\\\"color: #ffffff;\\\"><strong>Toronto<\\/strong><\\/span><\\/h1>\\n<h2><span style=\\\"color: #ffffff;\\\">From $229<\\/span><\\/h2>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}}},{\"type\":\"text\",\"text\":\"<h1><span style=\\\"color: #ffffff;\\\"><strong>New Delhi<\\/strong><\\/span><\\/h1>\\n<h2><span style=\\\"color: #ffffff;\\\">From $149<\\/span><\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/hotels\\/rio-london.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}}},{\"type\":\"text\",\"text\":\"<h1><span style=\\\"color: #ffffff;\\\"><strong>Rio de Janeiro<\\/strong><\\/span><\\/h1>\\n<h2><span style=\\\"color: #ffffff;\\\">From $329<\\/span><\\/h2>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}}},{\"type\":\"text\",\"text\":\"<h1><span style=\\\"color: #ffffff;\\\"><strong>London<\\/strong><\\/span><\\/h1>\\n<h2><span style=\\\"color: #ffffff;\\\">From $99<\\/span><\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffc600\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Just for you...<\\/strong><\\/h2>\\n<p style=\\\"text-align: center;\\\">Here\'s 10% off your next booking with us.<\\/p>\\n<p style=\\\"text-align: center;\\\">Just grab the code below and paste it when required on the booking form!<\\/p>\"},{\"type\":\"button\",\"text\":\"VALU3DCUST\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffc600\",\"borderColor\":\"#000000\",\"borderWidth\":\"2px\",\"borderRadius\":\"6px\",\"borderStyle\":\"solid\",\"width\":\"219px\",\"lineHeight\":\"40px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Courier New\",\"fontSize\":\"30px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2a31\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2a31\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/hotels\\/Hotel-Logo-Small.png\",\"alt\":\"Hotel-Logo-Small\",\"fullWidth\":true,\"width\":\"554px\",\"height\":\"200px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2a31\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Address Line 1 <\\/strong><\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Address Line 2 <\\/strong><\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>City <\\/strong><\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Country<\\/strong><\\/span><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #ffc600;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffc600;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffc600;\\\">Manage your subscription<\\/a><\\/span><br \\/><span style=\\\"color: #ffffff;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\"},\"h3\":{\"fontColor\":\"#2d2a31\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#008282\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#2d2a31\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Find Out More\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffc600\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"46px\",\"fontColor\":\"#3f3f3f\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/hotels/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (42, 0, 'Piece of cake', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><strong>Open daily from 9am to 9pm |&nbsp;<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/strong><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"#ececeb\"},\"text\":{\"fontColor\":\"#606060\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#d42b2b\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/piece_of_cake\\/Restaurant-Bakery-Logo-1.png\",\"alt\":\"Restaurant-Bakery-Logo-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"180px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/piece_of_cake\\/Restaurant-Bakery-Header.jpg\",\"alt\":\"Restaurant-Bakery-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"1600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>It\'s our Birthday!<\\/strong><\\/h1>\"},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center; line-height: 1.4;\\\">To celebrate, we\'re adding a slice of our Birthday cake to every order. Pop in this weekend to use our special offer code and enjoy!<\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; border: 3px dashed #d42b2b; color: #d42b2b; padding: 10px; font-size: 24px;\\\"><strong>HAPPYBDAY<\\/strong><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ececeb\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ececeb\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"background-color: #ececeb; line-height: 1.3;\\\"><span style=\\\"font-weight: 600;\\\"><span style=\\\"font-size: 12px; text-align: center;\\\">Add your postal address here.<\\/span><\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right; line-height: 1.3;\\\"><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #d42b2b; text-decoration: none; font-size: 12px; text-align: center;\\\">Unsubscribe<\\/a><\\/strong><\\/p>\\n                      <p style=\\\"text-align: right; line-height: 1.3;\\\"><strong><a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #d42b2b; text-decoration: none; font-size: 12px; text-align: center;\\\">Manage&nbsp;Subscription<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ececeb\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#606060\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#606060\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#d42b2b\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#606060\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#d42b2b\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ececeb\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/piece_of_cake/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (43, 0, 'Buddhist Temple', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#00050b\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"11px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#787878\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"80px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Logo.png\",\"alt\":\"Buddhist-Logo\",\"fullWidth\":false,\"width\":\"170px\",\"height\":\"99px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"text\",\"text\":\"<h1>With our thoughts, we make the <span style=\\\"color: #f37f31;\\\">world<\\/span><\\/h1>\\n    <p><span style=\\\"color: #dedede;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum. Vestibulum finibus sapien in enim ultricies, vel placerat risus lacinia.<\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#f37f31\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Avatar.jpg\",\"alt\":\"Buddhist-Avatar\",\"fullWidth\":false,\"width\":\"70px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"text\",\"text\":\"<p><span style=\\\"color: #999999;\\\">Special Event<\\/span><\\/p>\\n    <h3>Dalai Lama visit<\\/h3>\\n    <p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Book tickets here\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f37f31\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"145px\",\"lineHeight\":\"35px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#f37f31\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #f37f31;\\\">New prayer flags<\\/span><\\/h3>\\n    <p><span style=\\\"color: #dedede;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum. Vestibulum finibus sapien in enim ultricies, vel placerat risus lacinia.<\\/span><\\/p>\\n    <p><a href=\\\"http:\\/\\/a9d.fc4.mwp.accessdomain.com\\\">Find out more &gt;<\\/a><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/5bafccfc554c7f08176ec084.png\",\"alt\":\"5bafccfc554c7f08176ec084\",\"fullWidth\":false,\"width\":\"280px\",\"height\":\"524px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Social.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f37f31\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"45px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"90px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Sharing matters to us<\\/span><\\/h3>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum. Vestibulum finibus sapien in enim ultricies, vel placerat risus lacinia.<\\/span><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"45px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Images-1.jpg\",\"alt\":\"Buddhist-Images-1\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #dedede;\\\">Meditation for beginners<\\/span><\\/h3>\\n    <p><span style=\\\"color: #dedede;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum.<\\/span>&nbsp;<\\/span><\\/p>\\n    <p><a href=\\\"http:\\/\\/a9d.fc4.mwp.accessdomain.com\\\">Find out more &gt;<\\/a><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Images-2.jpg\",\"alt\":\"Buddhist-Images-2\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #dedede;\\\">Planning your trip to a temple<\\/span><\\/h3>\\n    <p><span style=\\\"color: #dedede;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum.<\\/span>&nbsp;<\\/span><\\/p>\\n    <p><a href=\\\"http:\\/\\/a9d.fc4.mwp.accessdomain.com\\\">Find out more &gt;<\\/a><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Images-3.jpg\",\"alt\":\"Buddhist-Images-3\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #dedede;\\\">Visit the sunken statues<\\/span><\\/h3>\\n    <p><span style=\\\"color: #dedede;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum.<\\/span>&nbsp;<\\/span><\\/p>\\n    <p><a href=\\\"http:\\/\\/a9d.fc4.mwp.accessdomain.com\\\">Find out more &gt;<\\/a><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#f37f31\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Logo.png\",\"alt\":\"Buddhist-Logo\",\"fullWidth\":false,\"width\":\"170px\",\"height\":\"99px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#f37f31\",\"textDecoration\":\"underline\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#eeeeee\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#eeeeee\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#eeeeee\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#eeeeee\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#f37f31\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#00050b\"},\"body\":{\"backgroundColor\":\"#00050b\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Book tickets here\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f37f31\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"145px\",\"lineHeight\":\"35px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#f37f31\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#f37f31\",\"textDecoration\":\"underline\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"11px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#787878\",\"textDecoration\":\"none\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/buddhist-temple/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (44, 0, 'Mosque', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#009146\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"10px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"none\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/Mosque-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#333333\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"100px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/Mosque-Logo.png\",\"alt\":\"Mosque-Logo\",\"fullWidth\":false,\"width\":\"182px\",\"height\":\"119px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\"><strong>JANUARY 2019<\\/strong><\\/span><\\/p>\\n    <h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Newsletter<\\/span><\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc scelerisque ut purus vel eleifend. Curabitur mollis nisi id mauris efficitur pretium.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"90px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #009146;\\\"><strong>Upcoming Events<\\/strong><\\/span><\\/h2>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/Mosque-Images-1.jpg\",\"alt\":\"Mosque-Images-1\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #999999;\\\"><strong>14th&nbsp;January 2019<\\/strong><\\/span><\\/p>\\n    <h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><span>The Four Imams<\\/span><\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc scelerisque ut purus vel eleifend. Curabitur mollis nisi id mauris.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><strong><a href=\\\"\\\">Find out more &gt;<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/Mosque-Images-2.jpg\",\"alt\":\"Mosque-Images-2\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #999999;\\\"><strong>23rd&nbsp;January 2019<\\/strong><\\/span><\\/p>\\n    <h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><span>Prayer Makes Perfect<\\/span><\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc scelerisque ut purus vel eleifend. Curabitur mollis nisi id mauris.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong><a href=\\\"\\\">Find out more &gt;<\\/a><\\/strong><\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/Mosque-Images-3.jpg\",\"alt\":\"Mosque-Images-3\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #999999;\\\"><strong>29th&nbsp;January 2019<\\/strong><\\/span><\\/p>\\n    <h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><span>Plaster Carving<\\/span><\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc scelerisque ut purus vel eleifend. Curabitur mollis nisi id mauris.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong><a href=\\\"http:\\/\\/a9d.fc4.mwp.accessdomain.com\\\">Find out more &gt;<\\/a><\\/strong><\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#009146\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"5.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#009146\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #009146;\\\"><strong>Prayer Times<\\/strong><\\/span><\\/h2>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong><\\/strong><strong>Fajr<\\/strong><\\/h2>\"},{\"type\":\"button\",\"text\":\"7.04pm\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Sunrise<\\/strong><\\/h2>\"},{\"type\":\"button\",\"text\":\"8.41am\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Dhuhr<\\/strong><\\/h2>\"},{\"type\":\"button\",\"text\":\"12.35pm\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Asr<\\/strong><\\/h2>\"},{\"type\":\"button\",\"text\":\"2.01pm\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Maghrib<\\/strong><\\/h2>\"},{\"type\":\"button\",\"text\":\"4.21pm\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Isha\'a<\\/strong><\\/h2>\"},{\"type\":\"button\",\"text\":\"5.58pm\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/bg-2.jpg\",\"alt\":\"bg-2\",\"fullWidth\":false,\"width\":\"1200px\",\"height\":\"286px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#009146\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/Mosque-Logo.png\",\"alt\":\"Mosque-Logo\",\"fullWidth\":false,\"width\":\"144px\",\"height\":\"119px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"11px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#009146\",\"textDecoration\":\"underline\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"13px\"},\"h1\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#009146\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#e3e3e3\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"5.58pm\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"5.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#009146\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"11px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#009146\",\"textDecoration\":\"underline\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"10px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"none\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/mosque/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (45, 0, 'Synagogue', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2b3d5e\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#7386a7\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#384e76\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"padding\":\"7.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#0d7e85\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#384e76\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Logo.png\",\"alt\":\"Synagogue-Logo\",\"fullWidth\":false,\"width\":\"180px\",\"height\":\"208px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"27px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Header-2.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#384e76\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"140px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"44px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\">Welcome&nbsp;back<\\/span><\\/h1>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\">This month we\'ll be discussing important topics around our faith, and highlighting some events that you may be interested in.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"38px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #04aeb9;\\\"><strong><span>S P E C I A L&nbsp; E V E N T<\\/span><\\/strong><\\/span><\\/p>\\n    <h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\">Stories In Song<\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\">An afternoon of comedy and music with Daniel Cainer. This multi-award-winning master-songwriter and great musician brings our family trees to life.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Tickets available here\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"175px\",\"lineHeight\":\"38px\",\"fontColor\":\"#093c3f\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"43px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Back-1.jpg\",\"display\":\"tile\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/male-18.jpg\",\"alt\":\"male-18\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"360px\",\"styles\":{\"block\":{\"textAlign\":\"right\"}}},{\"type\":\"text\",\"text\":\"<p class=\\\"font_2\\\" style=\\\"text-align: right;\\\"><span style=\\\"color: #384e76;\\\"><strong>Ariel Abel<\\/strong><\\/span><\\/p>\\n    <p class=\\\"font_2\\\" style=\\\"font-size: 11px; text-align: right;\\\"><span style=\\\"color: #384e76;\\\">Princes Road Synagogue&nbsp;<span>Rabbi&nbsp;<\\/span><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get in touch\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"90px\",\"lineHeight\":\"30px\",\"fontColor\":\"#093c3f\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"fontWeight\":\"bold\",\"textAlign\":\"right\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">Greetings from our Rabbi&nbsp;<\\/span><\\/h2>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed pellentesque magna erat, vitae ultricies eros porttitor eleifend. Fusce luctus accumsan risus, at rhoncus ante vehicula in. Praesent ut ultricies ipsum. Sed lacus dolor, laoreet nec tincidunt ut, commodo nec augue. In dignissim justo eget ante facilisis ornare.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\"><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\"><span>Cras in lacus ac lectus hendrerit porta. Morbi pretium id nisi eget placerat. Integer nec quam nec augue luctus facilisis. Nam sollicitudin velit nec risus mattis, quis porttitor tortor consequat. Vivamus nec justo vel lectus pharetra volutpat.<\\/span><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\"><span><\\/span><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\"><span>Quisque eget vestibulum quam, eu fermentum ipsum.<\\/span><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#384e76\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"padding\":\"6.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#04aeb9\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #384e76;\\\">Latest News<\\/span><\\/h2>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #384e76;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed pellentesque magna erat, vitae ultricies eros porttitor eleifend.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Images-1.jpg\",\"alt\":\"Synagogue-Images-1\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">Building work started this week<\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed pellentesque magna erat.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"81px\",\"lineHeight\":\"30px\",\"fontColor\":\"#093c3f\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Images-2.jpg\",\"alt\":\"Synagogue-Images-2\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">What\'s life like as a Jewish teenager?<\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed pellentesque magna erat.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"81px\",\"lineHeight\":\"30px\",\"fontColor\":\"#093c3f\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Images-3.jpg\",\"alt\":\"Synagogue-Images-3\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">The life of paper in a modern world<\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed pellentesque magna erat.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"81px\",\"lineHeight\":\"30px\",\"fontColor\":\"#093c3f\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2b3d5e\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Keep in touch with us<\\/span><\\/h2>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed pellentesque magna erat, vitae ultricies eros porttitor eleifend.<\\/span><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2b3d5e\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2b3d5e\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Logo.png\",\"alt\":\"Synagogue-Logo\",\"fullWidth\":false,\"width\":\"180px\",\"height\":\"208px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#04aeb9\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2b3d5e\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"13px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#2b3d5e\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Get in touch\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"90px\",\"lineHeight\":\"30px\",\"fontColor\":\"#093c3f\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"fontWeight\":\"bold\",\"textAlign\":\"right\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"padding\":\"6.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#04aeb9\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#04aeb9\",\"textDecoration\":\"underline\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#7386a7\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/synagogue/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (46, 0, 'Faith', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/faith\\/church-header.jpg\",\"alt\":\"church-header\",\"fullWidth\":true,\"width\":\"1036px\",\"height\":\"563px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\">Spreading Love &amp; Hope...<\\/h1><p>Duis id molestie ex. Quisque finibus magna in justo tristique pellentesque. Nulla sed leo facilisis arcu malesuada molestie vel quis dolor. Donec imperdiet condimentum odio ut elementum. Aenean nisl massa, rutrum a ullamcorper eget, molestie non erat.&nbsp;<\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f3f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\">Family Faith Events<\\/h2>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/faith\\/family.jpg\",\"alt\":\"family\",\"fullWidth\":false,\"width\":\"660px\",\"height\":\"880px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p>In maximus tempus pellentesque. Nunc scelerisque ante odio, vel placerat dui fermentum efficitur. Integer vitae ex suscipit, aliquet eros vitae, ornare est. <a href=\\\"http:\\/\\/www.example.com\\\">Aenean vel dapibus nisi<\\/a>.<\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2>Thoughts &amp; Prayers<\\/h2>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/faith\\/pray.jpg\",\"alt\":\"pray\",\"fullWidth\":false,\"width\":\"660px\",\"height\":\"880px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p>Donec sed vulputate ipsum. In scelerisque rutrum interdum. Donec imperdiet dignissim erat, in dictum lectus accumsan ut. <a href=\\\"http:\\/\\/www.example.com\\\">Aliquam erat volutpat.<\\/a><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\">Latest News<\\/h1>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"1px\",\"borderColor\":\"#dcdcdc\"}}},{\"type\":\"automatedLatestContent\",\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#dfeaf3\",\"borderColor\":\"#00ddff\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"45px\",\"fontColor\":\"#597890\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#dfeaf3\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#e7eff6\",\"padding\":\"13px\",\"borderStyle\":\"ridge\",\"borderWidth\":\"6px\",\"borderColor\":\"#597890\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#e7eff6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/><b>Add your postal address here!<\\/b>\",\"styles\":{\"block\":{\"backgroundColor\":\"#e7eff6\"},\"text\":{\"fontColor\":\"#787878\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"14px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#787878\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Find us socially:<\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#787878\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#597890\",\"fontFamily\":\"Comic Sans MS\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#597890\",\"fontFamily\":\"Comic Sans MS\",\"fontSize\":\"18px\"},\"h3\":{\"fontColor\":\"#787878\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#597890\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#e7eff6\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/faith/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (47, 0, 'College', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/college\\/College-Logo.png\",\"alt\":\"College-Logo\",\"fullWidth\":false,\"width\":\"106px\",\"height\":\"652px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"36px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"33px\"}}},{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/college\\/College-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#333333\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #ffcc00;\\\"><strong>S U M M E R&nbsp; &nbsp;E D I T I O N<\\/strong><\\/span><\\/p>\\n    <h1 style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\">Graduation Day is Coming<\\/span><\\/h1>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce dapibus iaculis risus ut tincidunt. Integer gravida mauris erat, vehicula blandit velit ultrices ut.&nbsp;<\\/span><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"54px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #999999;\\\"><strong>H E A D M A S T E R \' S&nbsp; &nbsp;B L O G<\\/strong><\\/span><\\/p>\\n    <h2 style=\\\"text-align: left;\\\"><strong><span style=\\\"color: #333333;\\\">Your hard work pays off in the future to come<\\/span><\\/strong><\\/h2>\\n    <p><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"18.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffcc00\"}}},{\"type\":\"text\",\"text\":\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur purus quam, semper eget nisl at, pretium fermentum ligula. Ut augue elit, congue non nisl eget, venenatis ornare ante. Aliquam erat volutpat. Maecenas facilisis eget risus vel scelerisque.<\\/p>\\n    <p><\\/p>\\n    <p>Etiam eros arcu, vestibulum at iaculis ut, iaculis nec est. Ut ut malesuada purus. Etiam sed accumsan eros, eu aliquam nisl. Nam faucibus sit amet felis at euismod. Sed efficitur varius tincidunt. Curabitur varius, nunc id interdum sodales, felis purus congue nulla, at semper orci est id mauris. Ut euismod vel dui sed mollis. Aliquam vestibulum id leo eu tristique. Etiam sit amet lacus vitae mi dignissim iaculis id ac nulla.<\\/p>\\n    <p><\\/p>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/college\\/College-Image.jpg\",\"alt\":\"College-Image\",\"fullWidth\":false,\"width\":\"1200px\",\"height\":\"800px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p><\\/p>\\n    <p>Praesent mi lorem, varius sit amet mattis at, sollicitudin ac enim. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam rhoncus tellus eleifend, accumsan magna in, imperdiet mauris. Cras a justo in lectus semper fermentum. Integer porta vel risus a varius. Aliquam nec nulla dui. Nulla congue ornare fringilla.<\\/p>\\n    <p><\\/p>\\n    <p>Nulla gravida interdum velit, nec pretium lacus placerat vel. Curabitur vitae arcu condimentum, iaculis nisl ac, viverra augue.<\\/p>\\n    <p><\\/p>\\n    <p>Etiam tincidunt justo quam, ac suscipit lectus hendrerit ac.<\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/college\\/College-Avatar.jpg\",\"alt\":\"College-Avatar\",\"fullWidth\":true,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p><\\/p>\\n    <p><\\/p>\\n    <p><strong>Mr George Chalk<\\/strong><\\/p>\\n    <p>Headmaster &amp; Director<\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"44px\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Need some tips and advice?&nbsp;<\\/strong><\\/p>\\n    <p>Here\'s the latest updates from our blog:<\\/p>\\n    <p><\\/p>\\n    <p><a href=\\\"http:\\/\\/mailpoet-sg.com\\\">7 ways to destress before an exam even starts<\\/a><\\/p>\\n    <p><\\/p>\\n    <p><a href=\\\"http:\\/\\/mailpoet-sg.com\\\">Focussing on the right content is key to being successful<\\/a><\\/p>\\n    <p><\\/p>\\n    <p><a href=\\\"http:\\/\\/mailpoet-sg.com\\\">Getting a degree is only the start of the battle<\\/a><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffcc00;\\\"><strong><\\/strong><\\/span><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a><span>&nbsp;|&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/><span>Add your postal address here!<\\/span><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/college\\/College-Logo.png\",\"alt\":\"College-Logo\",\"fullWidth\":false,\"width\":\"106px\",\"height\":\"652px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Source Sans Pro\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"30px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"24px\"},\"link\":{\"fontColor\":\"#447c9d\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"18.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffcc00\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}', 'https://ps.w.org/mailpoet/assets/newsletter-templates/college/thumbnail.20190411-1500.jpg', NULL, 1, NULL, '2023-08-16 17:12:50'),
 (48, 0, 'Renewable Energy', '[\"standard\",\"all\"]', '', '{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#313f58\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #fdb323;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #fdb323;\\\">View in browser &gt;<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#016fc1\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Logo.png\",\"alt\":\"Energy-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"145px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"36px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/LinkedIn.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\">2018 Energy Report<\\/span><\\/strong><\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse maximus purus vel sem rutrum pulvinar. Pellentesque at justo id ipsum porttitor viverra non porta nisl.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Read it here\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#fdb323\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"135px\",\"lineHeight\":\"44px\",\"fontColor\":\"#2e2e2e\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"197px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\"><strong>R E C E N T<\\/strong><\\/span><\\/p>\\n    <h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #003366;\\\"><strong>Here\'s what\'s happening this week<\\/strong><\\/span><\\/h2>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Image-1.jpg\",\"alt\":\"Energy-Image-1\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #003366;\\\"><strong>How can electricity be better?<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#fdb323\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"30px\",\"fontColor\":\"#2e2e2e\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Image-2.jpg\",\"alt\":\"Energy-Image-2\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #003366;\\\"><strong>Nuclear power for newcomers<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#fdb323\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"30px\",\"fontColor\":\"#2e2e2e\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Image-3.jpg\",\"alt\":\"Energy-Image-3\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #003366;\\\"><strong>Saving the planet, one trip at a time<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#fdb323\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"30px\",\"fontColor\":\"#2e2e2e\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Image-Tall.jpg\",\"alt\":\"Energy-Image-Tall\",\"fullWidth\":true,\"width\":\"600px\",\"height\":\"900px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #999999;\\\"><strong>S P O N S O R E D<\\/strong><\\/span><\\/p>\\n    <h2><span style=\\\"color: #003366;\\\"><strong>Control your heating and your spending with our amazing app<\\/strong><\\/span><\\/h2>\\n    <p><span style=\\\"color: #003366;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse maximus purus vel sem rutrum pulvinar.&nbsp;<\\/span><\\/p>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/CityNews-GoogleDownload.png\",\"alt\":\"CityNews-GoogleDownload\",\"fullWidth\":false,\"width\":\"130px\",\"height\":\"168px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/CityNews-AppleDownload.png\",\"alt\":\"CityNews-AppleDownload\",\"fullWidth\":false,\"width\":\"130px\",\"height\":\"168px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#313f58\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Logo.png\",\"alt\":\"Energy-Logo\",\"fullWidth\":true,\"width\":\"134px\",\"height\":\"145px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/skvshop.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/LinkedIn.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #fdb323;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #fdb323;\\\">Unsubscribe<\\/a>&nbsp;|&nbsp;<a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #fdb323;\\\">Manage your subscription<\\/a><\\/span><br \\/><span style=\\\"color: #999999;\\\">Add your postal address here!<\\/span><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"36px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#2ea1cd\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#313f58\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width