<p align="center">
  <img 
    alt="Shepherd.js Logo"
    src="https://i.imgur.com/cowwtSX.png"/>
</p>

<div>
  <a href="https://shipshape.io">
    <img align="left" src="http://i.imgur.com/DWHQjA5.png" alt="Ship Shape" width="50" height="50"/>
  </a>
 
  **[Shepherd is maintained by Ship Shape. Contact us for web app consulting, development, and training for your project](https://shipshape.io/ember-consulting/)**.
</div>  

[![npm version](https://badge.fury.io/js/shepherd.js.svg)](http://badge.fury.io/js/shepherd.js)
![Download count all time](https://img.shields.io/npm/dt/shepherd.js.svg)
[![npm](https://img.shields.io/npm/dm/shepherd.js.svg)]()
![npm bundle size](https://img.shields.io/bundlephobia/minzip/shepherd.js.svg)
[![Build Status](https://travis-ci.org/shipshapecode/shepherd.svg?branch=master)](https://travis-ci.org/shipshapecode/shepherd)
[![Maintainability](https://api.codeclimate.com/v1/badges/b295b0cc0d828ccc1b76/maintainability)](https://codeclimate.com/github/shipshapecode/shepherd/maintainability)
[![Test Coverage](https://api.codeclimate.com/v1/badges/b295b0cc0d828ccc1b76/test_coverage)](https://codeclimate.com/github/shipshapecode/shepherd/test_coverage)
[![StackShare](https://img.shields.io/badge/Follow%20on-StackShare-blue.svg?logo=stackshare&style=flat)](https://stackshare.io/shepherd-js)  


<a href="https://shepherdjs.dev/">
  <img 
    src="/demo/assets/img/demo.png" 
    alt="Guide your users through a tour of your app" 
    style="height: auto; max-width: 800px; width: 100%;"/>
</a>

Browsers support
----------------------------------------------------------

| [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/edge/edge_48x48.png" alt="IE / Edge" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>IE / Edge | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/firefox/firefox_48x48.png" alt="Firefox" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Firefox | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/chrome/chrome_48x48.png" alt="Chrome" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Chrome | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/safari/safari_48x48.png" alt="Safari" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Safari |
| --------- | --------- | --------- | --------- |
| Edge| last 2 versions| last 2 versions| last 2 versions

IE 11
----------------------------------------------------------

Shepherd v6.x no longer ships with the required polyfills to work with IE 11 out of the box,
however, if you are supporting IE 11 already, you are probably shipping some polyfills.
The only required polyfills are `Object.assign`, `Symbol`, and `element.matches` for things to work. 
Our demo app includes the polyfills using [Polyfill.io](https://polyfill.io/v3/), but Babel, core-js, etc would all work.

```html
<script src="https://polyfill.io/v3/polyfill.min.js?features=Object.assign%2CSymbol%2CElement.prototype.matches"></script>
```

You will also need a [Web Components polyfill](https://www.webcomponents.org/polyfills), which we include with:

```html
<script src="https://cdn.jsdelivr.net/npm/@webcomponents/webcomponentsjs@2.2.10/webcomponents-bundle.js"></script>
```

Documentation
----------------------------------------------------------

[API documentation](https://shepherdjs.dev/docs/)

Demo
----------------------------------------------------------

[Demo](https://shepherdjs.dev/)

Contributing
----------------------------------------------------------

We encourage contributions of all kinds. If you would like to contribute in some way, please review our [guidelines for contributing](CONTRIBUTING.md).

License
----------------------------------------------------------
[MIT License](LICENSE)

Projects Using Shepherd
----------------------------------------------------------

Here we showcase some of the awesome libraries built using Shepherd.

### JS Framework Wrappers

### [ember-shepherd](https://github.com/shipshapecode/ember-shepherd)

Ember addon for the site tour library Shepherd

### [angular-shepherd](https://github.com/shipshapecode/angular-shepherd)

An Angular wrapper for the site tour library Shepherd

### [react-shepherd](https://github.com/shipshapecode/react-shepherd)

A React wrapper for the site tour library Shepherd

### [vue-shepherd](https://github.com/shipshapecode/vue-shepherd)

A Vue wrapper for the site tour library Shepherd

### Rails gems

### [abraham](https://github.com/actmd/abraham)

Rails engine that generates and tracks Shepherd tours within an application

### Websites and Apps

### [SimplePlanner](https://simpleplanner.io)

[SimplePlanner](https://simpleplanner.io) uses Shepherd to help new users get familiar with its collaborative scheduling approach. 
You do need to sign up via OAuth or email to see the scheduling tour. 
Check out the [Envato Tuts+ Startup Series on its codebase](https://code.tutsplus.com/series/building-your-startup-with-php--cms-742) which describes how Simple Planner was built.

### [Brokermate](https://www.brokermate.com/) 

[Brokermate](https://www.brokermate.com/) uses Shepherd to guide users through initial setup steps.

### Your Project Here

If you have a cool open-source library built on Shepherd, PR this doc.
