<?php

// NOTES
// This is a template for creating CRUD resources.
// Do not edit this file.
// To customize do the following once you copy and paste it:
// [ ] replace "Template" with your model name (uppercase and singular)
// [ ] replace "template" with your model name (lowercase and singular)

namespace SolidAffiliate\Controllers;

use SolidAffiliate\Lib\ControllerFunctions;
use SolidAffiliate\Lib\URLs;
use SolidAffiliate\Lib\Validators;
use SolidAffiliate\Lib\VO\Either;
use SolidAffiliate\Lib\VO\Schema;
use SolidAffiliate\Lib\VO\SchemaEntry;
use SolidAffiliate\Models\Template;
use SolidAffiliate\Views\Admin\Templates\EditView;
use SolidAffiliate\Views\Admin\Templates\NewView;
use SolidAffiliate\Views\Shared\DeleteResourceView;
use SolidAffiliate\Views\Shared\WPListTableView;


/**
 * TemplatesController
 * 
 * @psalm-suppress PropertyNotSetInConstructor
 */
class TemplatesController
{
    const POST_PARAM_SUBMIT_CREATIVE = 'submit_template';
    const NONCE_SUBMIT_CREATIVE = 'solid-affiliate-templates-new';

    const POST_PARAM_DELETE_CREATIVE = 'delete_template';
    const NONCE_DELETE_CREATIVE = 'solid-affiliate-templates-delete';


    /**
     * @since 1.0.0
     *
     * @return void
     */
    public static function admin_root()
    {
        $action = isset($_GET["action"]) ? (string)$_GET["action"] : "index";

        switch ($action) {
            case "index":
                TemplatesController::GET_admin_index();
                break;
            case "new":
                TemplatesController::GET_admin_new();
                break;
            case "edit":
                $ids = ControllerFunctions::extract_ids_from_get($_GET);
                TemplatesController::GET_admin_edit($ids[0]);
                break;
            case "delete":
                $ids = ControllerFunctions::extract_ids_from_get($_GET);
                TemplatesController::GET_admin_delete($ids);
                break;
            default:
                TemplatesController::GET_admin_index();
                break;
        }
    }

    /**
     * @return void
     */
    public static function GET_admin_index()
    {
        $o = WPListTableView::render(Template::ADMIN_PAGE_KEY, Template::admin_list_table(), 'Templates');
        echo ($o);
    }

    /**
     * @return void
     */
    public static function GET_admin_new()
    {
        echo NewView::render();
    }

    /**
     * @param int $id
     *
     * @return void
     */
    public static function GET_admin_edit($id)
    {
        $maybe_visit = Template::find($id);
        if (is_null($maybe_visit)) {
            _e('Not found', 'solid-affiliate');
        } else {
            $item = (object)$maybe_visit->attributes;
            echo EditView::render($item);
        }
    }


    /**
     * @param array<int> $ids
     *
     * @return void
     */
    public static function GET_admin_delete($ids)
    {
        $delete_view_configs = [
            'singular_name' => 'Template',
            'plural_name' => 'Templates',
            'form_id' => 'templates-new',
            'nonce' => TemplatesController::NONCE_DELETE_CREATIVE,
            'submit_action' => TemplatesController::POST_PARAM_DELETE_CREATIVE,
            'children_classes' => []
        ];

        $o = DeleteResourceView::render($delete_view_configs, $ids);
        echo ($o);
    }

    /**
     * Creates the Resource
     *
     * @return void
     */
    public static function POST_admin_create_and_update_handler()
    {
        $args   = [
            'page' => Template::ADMIN_PAGE_KEY,
            'class_string' => Template::class,
            'success_msg_create' => "Successfully created Template",
            'success_msg_update' => "Successfully updated Template",
            'error_msg' => 'There was an error upserting Template.',
            'schema' => Template::schema(),
            'upsert_function' =>
            /** 
             * @param array<string, mixed> $args
             * @return Either<int> */
            function ($args) {
                return Template::upsert($args);
            },
            'capability' => 'read'
        ];

        ControllerFunctions::generic_upsert_handler($_POST, $args);
    }

    /**
     * @since 1.0.0
     *
     * @hook admin_init
     *
     * @return void
     */
    public static function POST_admin_delete_handler()
    {
        ////////////////////////////////////////////////////////////////////////
        // variables
        $args = [
            'page' => Template::ADMIN_PAGE_KEY,
            'success_msg' => "Successfully deleted Template",
            'error_msg' => 'There was an error.',
            'delete_by_id_function' =>
            /**
             * @param int $id
             * 
             * @return Either<int>
             */
            function ($id) {
                return Template::delete($id, true);
            },
        ];

        ControllerFunctions::generic_delete_handler($_POST, $args);
        ////////////////////////////////////////////////////////////////////////
    }

    /**
     * @return void
     */
    public static function POST_admin_table_bulk_actions_handler()
    {
        $schema = new Schema(['entries' =>
        [
            'id' => new SchemaEntry([
                'type' => 'varchar',
                'is_enum' => true,
                'display_name' => 'id'
            ]),
            'action' => new SchemaEntry([
                'type' => 'varchar',
                'display_name' => 'action'
            ]),
        ]]);


        $eitherPostParams = ControllerFunctions::extract_and_validate_POST_params(
            $_POST,
            ['id', 'action'],
            $schema
        );

        if ($eitherPostParams->isLeft) {
            ControllerFunctions::handle_redirecting_and_exit('REDIRECT_BACK', $eitherPostParams->left);
        } else {
            $bulk_action_string = (string)$eitherPostParams->right['action'];
            // TODO the idea is that we can encode the data type requirement in a Schema entry,
            // and ControllerFunctions::extract_and_validate_POST_params should take care of ensureing the type.
            // So we wouldn't need to do this below Validator.
            $ids = Validators::array_of_int($eitherPostParams->right['id']);

            switch ($bulk_action_string) {
                case 'Activate':
                    $templates = Template::find_many($ids);
                    Template::updateInstances($templates, ['status' => 'active']);
                    break;
                case 'Deactivate':
                    $templates = Template::find_many($ids);
                    Template::updateInstances($templates, ['status' => 'inactive']);
                    break;
                case 'Delete':
                    $delete_url = URLs::delete(Template::class, true);
                    ControllerFunctions::handle_redirecting_and_exit($delete_url, [], [], 'admin', ['id' => $ids]);
                    break;
                default:
                    ControllerFunctions::handle_redirecting_and_exit('REDIRECT_BACK', ["Invalid bulk action: {$bulk_action_string}"], [], 'admin');
                    break;
            }

            ControllerFunctions::handle_redirecting_and_exit('REDIRECT_BACK', [], ['Update Successful']);
        };
    }
}
